/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.misc;

import ic2.api.classic.crops.IFarmland;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Farmlands {
    public static IFarmland farmland = new Farmland();
    public static IFarmland dirtLand = new DirtLand();
    public static IFarmland spongeLand = new SpongeLand();
    public static IFarmland souland = new SoulLand();

    public static class SoulLand
    implements IFarmland {
        @Override
        public int getHumidity(World world, BlockPos pos) {
            return -3;
        }

        @Override
        public int getHumidity(IBlockState state) {
            return -3;
        }

        @Override
        public int getNutrients(World world, BlockPos pos) {
            return 5;
        }

        @Override
        public int getNutrients(IBlockState state) {
            return 5;
        }
    }

    public static class SpongeLand
    implements IFarmland {
        @Override
        public int getHumidity(World world, BlockPos pos) {
            return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)BlockSponge.field_176313_a) != false ? 4 : 0;
        }

        @Override
        public int getHumidity(IBlockState state) {
            return (Boolean)state.func_177229_b((IProperty)BlockSponge.field_176313_a) != false ? 4 : 0;
        }

        @Override
        public int getNutrients(World world, BlockPos pos) {
            return -2;
        }

        @Override
        public int getNutrients(IBlockState state) {
            return -2;
        }
    }

    public static class DirtLand
    implements IFarmland {
        @Override
        public int getHumidity(World world, BlockPos pos) {
            return 0;
        }

        @Override
        public int getHumidity(IBlockState state) {
            return 0;
        }

        @Override
        public int getNutrients(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            BlockDirt.DirtType type = (BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a);
            return type == BlockDirt.DirtType.DIRT ? 1 : (type == BlockDirt.DirtType.COARSE_DIRT ? -4 : 0);
        }

        @Override
        public int getNutrients(IBlockState state) {
            BlockDirt.DirtType type = (BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a);
            return type == BlockDirt.DirtType.DIRT ? 1 : (type == BlockDirt.DirtType.COARSE_DIRT ? -4 : 0);
        }
    }

    public static class Farmland
    implements IFarmland {
        @Override
        public int getHumidity(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            return (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a) >= 7 ? 2 : 0;
        }

        @Override
        public int getHumidity(IBlockState state) {
            return (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a) >= 7 ? 2 : 0;
        }

        @Override
        public int getNutrients(IBlockState state) {
            return 0;
        }

        @Override
        public int getNutrients(World world, BlockPos pos) {
            return 0;
        }
    }
}

