/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.base;

import com.google.common.math.DoubleMath;
import ic2.api.classic.tile.machine.IFuelMachine;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineFuelComp
extends GuiComponent {
    IFuelMachine fuel;
    Vec2i texPos;

    public MachineFuelComp(IFuelMachine tile, Box2D box, Vec2i pos) {
        super(box);
        this.fuel = tile;
        this.texPos = pos;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        float currentFuel = this.fuel.getFuel();
        if (currentFuel >= 1.0f) {
            Box2D box;
            int maxX;
            int lvl;
            int x = gui.getXOffset();
            int y = gui.getYOffset();
            float per = currentFuel / this.fuel.getMaxFuel();
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = DoubleMath.roundToInt((double)(per * (float)(maxX = (box = this.getPosition()).getHeight())), (RoundingMode)RoundingMode.CEILING)) <= 0) {
                return;
            }
            gui.func_73729_b(x + box.getX(), y + box.getY() + (box.getHeight() - ++lvl), this.texPos.getX(), this.texPos.getY() + (box.getHeight() - lvl), maxX, lvl);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY) && PlayerHandler.getClientPlayerHandler().hasEUReader()) {
            tooltips.add(Ic2InfoLang.machineFuel.getLocalizedFormatted(Float.valueOf(this.fuel.getFuel()), Float.valueOf(this.fuel.getMaxFuel())));
        }
    }
}

