/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.core.IC2;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockUpdatePacket
extends IC2Packet {
    int dimID;
    BlockPos pos;
    Block blockID;
    int meta;

    public BlockUpdatePacket() {
    }

    public BlockUpdatePacket(World world, BlockPos coord) {
        this.dimID = world.field_73011_w.getDimension();
        this.pos = coord;
        IBlockState state = world.func_180495_p(this.pos);
        this.blockID = state.func_177230_c();
        this.meta = this.blockID.func_176201_c(state);
    }

    @Override
    public void read(ByteBuf par1) {
        InputBuffer buffer = new InputBuffer(par1);
        this.dimID = buffer.readInt();
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.blockID = (Block)buffer.readForgeRegistryEntry(Block.field_149771_c);
        this.meta = buffer.readByte();
    }

    @Override
    public void write(ByteBuf par1) {
        OutputBuffer buffer = new OutputBuffer(par1);
        buffer.writeInt(this.dimID);
        buffer.writeLong(this.pos.func_177986_g());
        buffer.writeForgeEntry((IForgeRegistryEntry)this.blockID);
        buffer.writeByte((byte)this.meta);
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Contains Incorrect data");
        }
        world.func_175656_a(this.pos, this.blockID.func_176203_a(this.meta));
    }

    public String toString() {
        return "BlockUpdate Packet: Pos: " + this.pos.toString() + ", " + this.blockID.toString();
    }
}

