/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.registry;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.BasicFoodCanEffect;
import ic2.api.classic.recipe.machine.ICannerRegistry;
import ic2.core.IC2;
import ic2.core.block.personal.tile.TileEntityPersonalTank;
import ic2.core.fluid.IC2Fluid;
import ic2.core.item.armor.base.ItemArmorElectricJetpackBase;
import ic2.core.item.recipe.entry.ChorusFruitEffect;
import ic2.core.item.tfbp.bp.CultivatedBP;
import ic2.core.item.tfbp.bp.DesertificationBP;
import ic2.core.item.tfbp.bp.FlatificationBP;
import ic2.core.platform.registry.IMCManager;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class RegistryLoader {
    public static boolean DISABLE_PLATING = false;

    public static void preInit() {
        IMCManager.init();
        ICannerRegistry canning = ClassicRecipes.canningMachine;
        canning.registerCanEffect(new BasicFoodCanEffect(true, new PotionEffect(MobEffects.field_76438_s, 150, 0)).setRandom(0.8f));
        canning.registerCanEffect(new BasicFoodCanEffect(true, new PotionEffect(MobEffects.field_76436_u, 50, 0)));
        canning.registerCanEffect(new BasicFoodCanEffect(true, new PotionEffect(MobEffects.field_76438_s, 300, 0)).setRandom(0.3f));
        canning.registerCanEffect(new BasicFoodCanEffect(false, new PotionEffect(MobEffects.field_76428_l, 25, 1), new PotionEffect(MobEffects.field_76444_x, 600, 0)));
        canning.registerCanEffect(new BasicFoodCanEffect(false, new PotionEffect(MobEffects.field_76428_l, 100, 1), new PotionEffect(MobEffects.field_76429_m, 1500, 0), new PotionEffect(MobEffects.field_76426_n, 1500, 0), new PotionEffect(MobEffects.field_76444_x, 600, 3)));
        canning.registerCanEffect(new ChorusFruitEffect());
        canning.registerItemsForEffect(1, new ItemStack(Items.field_151078_bh));
        canning.registerItemsForEffect(2, new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151170_bI));
        canning.registerItemsForEffect(3, new ItemStack(Items.field_151076_bf));
        canning.registerItemsForEffect(4, new ItemStack(Items.field_151153_ao, 1, 0));
        canning.registerItemsForEffect(5, new ItemStack(Items.field_151153_ao, 1, 1));
        canning.registerItemsForEffect(6, new ItemStack(Items.field_185161_cS));
        canning.registerFuelMultiplier(new ItemStack(Items.field_151137_ax), 0.2f);
        canning.registerFuelMultiplier(new ItemStack(Items.field_151114_aO), 0.3f);
        canning.registerFuelMultiplier(new ItemStack(Items.field_151016_H), 0.4f);
        canning.registerFuelMultiplier(Ic2Items.fuelCell.func_77946_l(), 0.7f);
        canning.registerFuelValue(Ic2Items.coalFuelCell.func_77946_l(), 2548);
        canning.registerFuelValue(Ic2Items.bioFuelCell.func_77946_l(), 868);
        ClassicRecipes.teleRegistry.registerInventory(TileEntityChest.class);
        ClassicRecipes.teleRegistry.registerTank(TileEntityPersonalTank.class);
        ClassicRecipes.fluidGenerator.addEntry(IC2Fluid.getFluid("woodgas"), 250, 10.0f);
        ItemArmorElectricJetpackBase.addArmor(new ItemStack((Item)Items.field_151030_Z));
        ItemArmorElectricJetpackBase.addArmor(new ItemStack((Item)Items.field_151171_ah));
        ItemArmorElectricJetpackBase.addArmor(new ItemStack((Item)Items.field_151163_ad));
        ItemArmorElectricJetpackBase.addArmor(Ic2Items.bronzeChest.func_77946_l());
        ItemArmorElectricJetpackBase.addArmor(Ic2Items.compositeChest.func_77946_l());
        MinecraftForge.addGrassSeed((ItemStack)Ic2Items.hempSeeds.func_77946_l(), (int)5);
        CultivatedBP.init();
        FlatificationBP.init();
        DesertificationBP.init();
        RegistryLoader.initOreDict();
    }

    private static void initOreDict() {
        IC2 ic2 = IC2.getInstance();
        for (String oreName : OreDictionary.getOreNames()) {
            for (ItemStack ore : OreDictionary.getOres((String)oreName)) {
                ic2.onOreRegistering(new OreDictionary.OreRegisterEvent(oreName, ore));
            }
        }
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)Ic2Items.copperOre.func_77946_l());
        OreDictionary.registerOre((String)"oreTin", (ItemStack)Ic2Items.tinOre.func_77946_l());
        OreDictionary.registerOre((String)"oreUranium", (ItemStack)Ic2Items.uraniumOre.func_77946_l());
        OreDictionary.registerOre((String)"oreSilver", (ItemStack)Ic2Items.silverOre.func_77946_l());
        OreDictionary.registerOre((String)"blockBronze", (ItemStack)Ic2Items.bronzeBlock.func_77946_l());
        OreDictionary.registerOre((String)"blockCopper", (ItemStack)Ic2Items.copperBlock.func_77946_l());
        OreDictionary.registerOre((String)"blockTin", (ItemStack)Ic2Items.tinBlock.func_77946_l());
        OreDictionary.registerOre((String)"blockUranium", (ItemStack)Ic2Items.uraniumBlock.func_77946_l());
        OreDictionary.registerOre((String)"blockSilver", (ItemStack)Ic2Items.silverBlock.func_77946_l());
        OreDictionary.registerOre((String)"dustBronze", (ItemStack)Ic2Items.bronzeDust.func_77946_l());
        OreDictionary.registerOre((String)"dustClay", (ItemStack)Ic2Items.clayDust.func_77946_l());
        OreDictionary.registerOre((String)"dustCoal", (ItemStack)Ic2Items.coalDust.func_77946_l());
        OreDictionary.registerOre((String)"dustCopper", (ItemStack)Ic2Items.copperDust.func_77946_l());
        OreDictionary.registerOre((String)"dustGold", (ItemStack)Ic2Items.goldDust.func_77946_l());
        OreDictionary.registerOre((String)"dustIron", (ItemStack)Ic2Items.ironDust.func_77946_l());
        OreDictionary.registerOre((String)"dustSilver", (ItemStack)Ic2Items.silverDust.func_77946_l());
        OreDictionary.registerOre((String)"dustTin", (ItemStack)Ic2Items.tinDust.func_77946_l());
        OreDictionary.registerOre((String)"dustCharcoal", (ItemStack)Ic2Items.charcoalDust.func_77946_l());
        OreDictionary.registerOre((String)"dropUranium", (ItemStack)Ic2Items.uraniumDrop.func_77946_l());
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)Ic2Items.bronzeIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)Ic2Items.copperIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotRefinedIron", (ItemStack)Ic2Items.refinedIronIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotTin", (ItemStack)Ic2Items.tinIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotUranium", (ItemStack)Ic2Items.uraniumIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotSilver", (ItemStack)Ic2Items.silverIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotEnrichedUranium", (ItemStack)Ic2Items.redstoneUraniumIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotEnrichedUranium", (ItemStack)Ic2Items.blazeUraniumIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotEnrichedUranium", (ItemStack)Ic2Items.enderPearlUraniumIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotEnrichedUranium", (ItemStack)Ic2Items.netherStarUraniumIngot.func_77946_l());
        OreDictionary.registerOre((String)"ingotEnrichedUranium", (ItemStack)Ic2Items.charcoalUraniumIngot.func_77946_l());
        OreDictionary.registerOre((String)"itemRubber", (ItemStack)Ic2Items.rubber.func_77946_l());
        OreDictionary.registerOre((String)"itemRawRubber", (ItemStack)Ic2Items.stickyResin.func_77946_l());
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)Ic2Items.rubberSapling.func_77946_l());
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)Ic2Items.rubberLeaves.func_77946_l());
        OreDictionary.registerOre((String)"circuitBasic", (ItemStack)Ic2Items.electricCircuit.func_77946_l());
        OreDictionary.registerOre((String)"circuitAdvanced", (ItemStack)Ic2Items.advancedCircuit.func_77946_l());
        OreDictionary.registerOre((String)"gemDiamond", (ItemStack)Ic2Items.industrialDiamond.func_77946_l());
        OreDictionary.registerOre((String)"UUMatter", (ItemStack)Ic2Items.uuMatter.func_77946_l());
        OreDictionary.registerOre((String)"woodRubber", (ItemStack)Ic2Items.rubberWood.func_77946_l());
        OreDictionary.registerOre((String)"foodFlour", (ItemStack)Ic2Items.flour.func_77946_l());
    }

    public static void postPlate() {
        RegistryLoader.registerIfPresent("plateIron", Ic2Items.refinedIronIngot.func_77946_l());
        RegistryLoader.registerIfPresent("plateGold", new ItemStack(Items.field_151043_k));
        RegistryLoader.registerIfPresent("plateCopper", Ic2Items.copperIngot.func_77946_l());
        RegistryLoader.registerIfPresent("plateTin", Ic2Items.tinIngot.func_77946_l());
        RegistryLoader.registerIfPresent("plateLapis", new ItemStack(Items.field_151100_aR, 1, 4));
        RegistryLoader.registerIfPresent("plateBronze", Ic2Items.bronzeIngot.func_77946_l());
    }

    private static void registerIfPresent(String id, ItemStack stack) {
        if (DISABLE_PLATING) {
            return;
        }
        if (OreDictionary.getOres((String)id, (boolean)false).size() < 1 || IC2.config.getFlag("plateOverride")) {
            OreDictionary.registerOre((String)id, (ItemStack)stack);
        }
    }
}

