/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TileUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.content.turbine.TurbineUpdateProtocol;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityTurbineCasing
extends TileEntityMultiblock<SynchronizedTurbineData>
implements IStrictEnergyStorage {
    public TileEntityTurbineCasing() {
        this("TurbineCasing");
    }

    public TileEntityTurbineCasing(String name) {
        super(name);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            if (((SynchronizedTurbineData)this.structure).fluidStored != null && ((SynchronizedTurbineData)this.structure).fluidStored.amount <= 0) {
                ((SynchronizedTurbineData)this.structure).fluidStored = null;
                this.func_70296_d();
            }
            if (this.isRendering) {
                ((SynchronizedTurbineData)this.structure).lastSteamInput = ((SynchronizedTurbineData)this.structure).newSteamInput;
                ((SynchronizedTurbineData)this.structure).newSteamInput = 0;
                int stored = ((SynchronizedTurbineData)this.structure).fluidStored != null ? ((SynchronizedTurbineData)this.structure).fluidStored.amount : 0;
                double proportion = (double)stored / (double)((SynchronizedTurbineData)this.structure).getFluidCapacity();
                double flowRate = 0.0;
                if (stored > 0 && this.getEnergy() < ((SynchronizedTurbineData)this.structure).getEnergyCapacity()) {
                    double energyMultiplier = MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0 * (double)Math.min(((SynchronizedTurbineData)this.structure).blades, ((SynchronizedTurbineData)this.structure).coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
                    double rate = (double)((SynchronizedTurbineData)this.structure).lowerVolume * ((double)((SynchronizedTurbineData)this.structure).getDispersers() * MekanismConfig.current().generators.turbineDisperserGasFlow.val());
                    double origRate = rate = Math.min(rate, (double)((SynchronizedTurbineData)this.structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
                    rate = Math.min(Math.min((double)stored, rate), (this.getMaxEnergy() - this.getEnergy()) / energyMultiplier) * proportion;
                    flowRate = rate / origRate;
                    this.setEnergy(this.getEnergy() + (double)((int)rate) * energyMultiplier);
                    ((SynchronizedTurbineData)this.structure).fluidStored.amount = (int)((double)((SynchronizedTurbineData)this.structure).fluidStored.amount - rate);
                    ((SynchronizedTurbineData)this.structure).clientFlow = (int)rate;
                    ((SynchronizedTurbineData)this.structure).flowRemaining = Math.min((int)rate, ((SynchronizedTurbineData)this.structure).condensers * MekanismConfig.current().generators.condenserRate.val());
                    if (((SynchronizedTurbineData)this.structure).fluidStored.amount == 0) {
                        ((SynchronizedTurbineData)this.structure).fluidStored = null;
                    }
                } else {
                    ((SynchronizedTurbineData)this.structure).clientFlow = 0;
                }
                if (((SynchronizedTurbineData)this.structure).dumpMode == TileEntityGasTank.GasMode.DUMPING && ((SynchronizedTurbineData)this.structure).fluidStored != null) {
                    ((SynchronizedTurbineData)this.structure).fluidStored.amount -= Math.min(((SynchronizedTurbineData)this.structure).fluidStored.amount, Math.max(((SynchronizedTurbineData)this.structure).fluidStored.amount / 50, ((SynchronizedTurbineData)this.structure).lastSteamInput * 2));
                    if (((SynchronizedTurbineData)this.structure).fluidStored.amount == 0) {
                        ((SynchronizedTurbineData)this.structure).fluidStored = null;
                    }
                }
                float newRotation = (float)flowRate;
                boolean needsRotationUpdate = false;
                if (Math.abs(newRotation - ((SynchronizedTurbineData)this.structure).clientRotation) > 0.001f) {
                    ((SynchronizedTurbineData)this.structure).clientRotation = newRotation;
                    needsRotationUpdate = true;
                }
                if (((SynchronizedTurbineData)this.structure).needsRenderUpdate() || needsRotationUpdate) {
                    this.sendPacketToRenderer();
                }
                ((SynchronizedTurbineData)this.structure).prevFluid = ((SynchronizedTurbineData)this.structure).fluidStored != null ? ((SynchronizedTurbineData)this.structure).fluidStored.copy() : null;
            }
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize((String)"gui.industrialTurbine");
    }

    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.func_70093_af() && this.structure != null) {
            Mekanism.packetHandler.sendUpdatePacket((TileEntity)this);
            player.openGui((Object)MekanismGenerators.instance, 6, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            return true;
        }
        return false;
    }

    public double getEnergy() {
        return this.structure != null ? ((SynchronizedTurbineData)this.structure).electricityStored : 0.0;
    }

    public void setEnergy(double energy) {
        if (this.structure != null) {
            ((SynchronizedTurbineData)this.structure).electricityStored = Math.max(Math.min(energy, this.getMaxEnergy()), 0.0);
            MekanismUtils.saveChunk((TileEntity)this);
        }
    }

    public double getMaxEnergy() {
        return this.structure != null ? ((SynchronizedTurbineData)this.structure).getEnergyCapacity() : 0.0;
    }

    public int getScaledFluidLevel(long i) {
        if (this.structure == null || ((SynchronizedTurbineData)this.structure).getFluidCapacity() == 0 || ((SynchronizedTurbineData)this.structure).fluidStored == null) {
            return 0;
        }
        return (int)((long)((SynchronizedTurbineData)this.structure).fluidStored.amount * i / (long)((SynchronizedTurbineData)this.structure).getFluidCapacity());
    }

    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add((Object)((SynchronizedTurbineData)this.structure).volume);
            data.add((Object)((SynchronizedTurbineData)this.structure).lowerVolume);
            data.add((Object)((SynchronizedTurbineData)this.structure).vents);
            data.add((Object)((SynchronizedTurbineData)this.structure).blades);
            data.add((Object)((SynchronizedTurbineData)this.structure).coils);
            data.add((Object)((SynchronizedTurbineData)this.structure).condensers);
            data.add((Object)((SynchronizedTurbineData)this.structure).getDispersers());
            data.add((Object)((SynchronizedTurbineData)this.structure).electricityStored);
            data.add((Object)((SynchronizedTurbineData)this.structure).clientFlow);
            data.add((Object)((SynchronizedTurbineData)this.structure).lastSteamInput);
            data.add((Object)((SynchronizedTurbineData)this.structure).dumpMode.ordinal());
            TileUtils.addFluidStack((TileNetworkList)data, (FluidStack)((SynchronizedTurbineData)this.structure).fluidStored);
            if (this.isRendering) {
                ((SynchronizedTurbineData)this.structure).complex.write(data);
                data.add((Object)Float.valueOf(((SynchronizedTurbineData)this.structure).clientRotation));
            }
        }
        return data;
    }

    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            byte type;
            if (this.structure != null && (type = dataStream.readByte()) == 0) {
                ((SynchronizedTurbineData)this.structure).dumpMode = TileEntityGasTank.GasMode.values()[((SynchronizedTurbineData)this.structure).dumpMode.ordinal() == TileEntityGasTank.GasMode.values().length - 1 ? 0 : ((SynchronizedTurbineData)this.structure).dumpMode.ordinal() + 1];
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.clientHasStructure) {
            ((SynchronizedTurbineData)this.structure).volume = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).lowerVolume = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).vents = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).blades = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).coils = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).condensers = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).clientDispersers = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).electricityStored = dataStream.readDouble();
            ((SynchronizedTurbineData)this.structure).clientFlow = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).lastSteamInput = dataStream.readInt();
            ((SynchronizedTurbineData)this.structure).dumpMode = TileEntityGasTank.GasMode.values()[dataStream.readInt()];
            ((SynchronizedTurbineData)this.structure).fluidStored = TileUtils.readFluidStack((ByteBuf)dataStream);
            if (this.isRendering) {
                ((SynchronizedTurbineData)this.structure).complex = Coord4D.read((ByteBuf)dataStream);
                ((SynchronizedTurbineData)this.structure).clientRotation = dataStream.readFloat();
                SynchronizedTurbineData.clientRotationMap.put(((SynchronizedTurbineData)this.structure).inventoryID, Float.valueOf(((SynchronizedTurbineData)this.structure).clientRotation));
            }
        }
    }

    protected SynchronizedTurbineData getNewStructure() {
        return new SynchronizedTurbineData();
    }

    public MultiblockCache<SynchronizedTurbineData> getNewCache() {
        return new TurbineCache();
    }

    protected UpdateProtocol<SynchronizedTurbineData> getProtocol() {
        return new TurbineUpdateProtocol(this);
    }

    public MultiblockManager<SynchronizedTurbineData> getManager() {
        return MekanismGenerators.turbineManager;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }
}

