/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import omtteam.omlib.util.MathUtil;
import omtteam.omlib.util.RandomUtil;
import omtteam.omlib.util.WorldUtil;
import omtteam.openmodularturrets.compatibility.ModCompatibility;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.ArmorBypassDamageSource;
import omtteam.openmodularturrets.entity.projectiles.damagesources.NormalDamageSource;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.tileentity.turrets.AbstractDirectedTurret;
import omtteam.openmodularturrets.util.OMTUtil;
import omtteam.openmodularturrets.util.TurretHeadUtil;
import valkyrienwarfare.api.IPhysicsEntity;
import valkyrienwarfare.api.IPhysicsEntityManager;
import valkyrienwarfare.api.TransformType;

public abstract class RayTracingTurret
extends AbstractDirectedTurret {
    public RayTracingTurret(int tier) {
        super(tier);
    }

    protected abstract void renderRay(Vec3d var1, Vec3d var2);

    protected abstract SoundEvent getHitSound();

    protected abstract float getDamageModifier(Entity var1);

    protected abstract float getNormalDamageFactor();

    protected abstract float getBypassDamageFactor();

    protected abstract void applyHitEffects(Entity var1);

    protected abstract void applyLaunchEffects();

    protected abstract void handleBlockHit(IBlockState var1, BlockPos var2);

    @Override
    protected void doTargetedShot(Entity target, ItemStack ammo) {
        IPhysicsEntity physicsEntity;
        Vec3d targetPos = target.func_174791_d();
        double d0 = targetPos.field_72450_a;
        double d1 = targetPos.field_72448_b + (double)target.func_70047_e();
        double d2 = targetPos.field_72449_c;
        if (ModCompatibility.ValkyrienWarfareLoaded && (physicsEntity = IPhysicsEntityManager.INSTANCE.getPhysicsEntityFromShipSpace(this.func_145831_w(), this.func_174877_v())) != null) {
            Vec3d targetPosInShip = physicsEntity.transformVector(targetPos, TransformType.GLOBAL_TO_SUBSPACE);
            d0 = targetPosInShip.field_72450_a;
            d1 = targetPosInShip.field_72448_b + (double)target.func_70047_e();
            d2 = targetPosInShip.field_72449_c;
        }
        this.shootRay(d0, d1, d2, this.getActualTurretAccuracy());
    }

    @Override
    public boolean forceShot() {
        Vec3d direction = MathUtil.getVectorFromYawPitch((float)this.yaw, (float)this.pitch).func_186678_a(5.0);
        Vec3d baseVector = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.6, (double)this.func_174877_v().func_177952_p() + 0.5);
        Vec3d result = baseVector.func_178787_e(direction);
        this.shootRay(result.field_72450_a, result.field_72448_b, result.field_72449_c, this.getActualTurretAccuracy());
        return true;
    }

    protected void shootRay(double adjustedX, double adjustedY, double adjustedZ, double accuracy) {
        this.base.setEnergyStored(this.base.getEnergyStored(EnumFacing.DOWN) - this.getPowerRequiredForNextShot(), null);
        this.applyLaunchEffects();
        for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
            IPhysicsEntity physicsEntity;
            boolean hit = false;
            Vec3d vector = new Vec3d(adjustedX, adjustedY, adjustedZ);
            Vec3d baseVector = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.6, (double)this.func_174877_v().func_177952_p() + 0.5);
            if (ModCompatibility.ValkyrienWarfareLoaded && (physicsEntity = IPhysicsEntityManager.INSTANCE.getPhysicsEntityFromShipSpace(this.func_145831_w(), this.func_174877_v())) != null) {
                vector = physicsEntity.transformVector(vector, TransformType.SUBSPACE_TO_GLOBAL);
                baseVector = physicsEntity.transformVector(baseVector, TransformType.SUBSPACE_TO_GLOBAL);
            }
            double deviationModifier = 1.0 * ((double)this.target.field_70131_O < 0.5 ? 1.5 : 1.0) * (vector.func_72438_d(baseVector) * 0.5 / (double)(this.getTurretBaseRange() + TurretHeadUtil.getRangeUpgrades(this.base, this)) + 0.3);
            double xDev = RandomUtil.random.nextGaussian() * 0.035 * accuracy * deviationModifier;
            double yDev = RandomUtil.random.nextGaussian() * 0.035 * accuracy * deviationModifier;
            double zDev = RandomUtil.random.nextGaussian() * 0.035 * accuracy * deviationModifier;
            vector = vector.func_72441_c(xDev, yDev, zDev);
            baseVector = baseVector.func_178787_e(vector.func_178788_d(baseVector).func_72432_b().func_186678_a(0.75));
            this.func_145831_w().func_184133_a(null, this.field_174879_c, this.getLaunchSoundEffect(), SoundCategory.BLOCKS, OMTConfig.TURRETS.turretSoundVolume, new Random().nextFloat() + 0.5f);
            RayTraceResult blockTraceResult = this.field_145850_b.func_147447_a(baseVector, vector, false, true, false);
            List entityHits = WorldUtil.traceEntities(null, (Vec3d)baseVector, (Vec3d)vector, (World)this.field_145850_b);
            double blockRange = blockTraceResult != null ? blockTraceResult.field_72307_f.func_72438_d(baseVector) : 500.0;
            for (RayTraceResult result : entityHits) {
                Entity entity = result.field_72308_g;
                if (!(baseVector.func_72438_d(result.field_72307_f) <= blockRange) || !this.onHitEntity(entity)) continue;
                this.renderRay(baseVector, vector);
                hit = true;
                break;
            }
            if (hit) continue;
            if (blockTraceResult != null && blockTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                if (baseVector.func_72438_d(blockTraceResult.field_72307_f) <= blockRange) {
                    this.renderRay(baseVector, blockTraceResult.field_72307_f);
                    this.handleBlockHit(this.field_145850_b.func_180495_p(blockTraceResult.func_178782_a()), blockTraceResult.func_178782_a());
                }
            } else {
                this.renderRay(baseVector, vector.func_178787_e(vector.func_178788_d(baseVector).func_186678_a(2.0)));
            }
            this.renderRay(baseVector, vector.func_178787_e(vector.func_178788_d(baseVector).func_186678_a(2.0)));
        }
    }

    protected boolean onHitEntity(Entity entity) {
        if (entity != null && !entity.func_130014_f_().field_72995_K && !(entity instanceof TurretProjectile)) {
            if (entity instanceof EntityPlayer) {
                if (OMTUtil.canDamagePlayer((EntityPlayer)entity, this.base)) {
                    this.damageEntity(entity);
                    this.applyHitEffects(entity);
                    entity.field_70172_ad = -1;
                    this.func_145831_w().func_184133_a(null, entity.func_180425_c(), this.getHitSound(), SoundCategory.AMBIENT, OMTConfig.TURRETS.turretSoundVolume, RandomUtil.random.nextFloat() + 0.5f);
                    return true;
                }
                return false;
            }
            if (OMTUtil.canDamageEntity(entity, this.base)) {
                OMTUtil.setTagsForTurretHit(entity, this.base);
                this.damageEntity(entity);
                this.applyHitEffects(entity);
                entity.field_70172_ad = -1;
                this.func_145831_w().func_184133_a(null, entity.func_180425_c(), this.getHitSound(), SoundCategory.AMBIENT, OMTConfig.TURRETS.turretSoundVolume, RandomUtil.random.nextFloat() + 0.5f);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void damageEntity(Entity entity) {
        EntityLivingBase elb;
        float damageModifier = this.getDamageModifier(entity);
        float damage = (float)this.getTurretType().getSettings().baseDamage * damageModifier;
        int fakeDrops = TurretHeadUtil.getFakeDropsLevel(this.base);
        if (this.getTurretDamageAmpBonus() * (double)TurretHeadUtil.getAmpLevel(this.base) > 0.0 && entity instanceof EntityLivingBase) {
            elb = (EntityLivingBase)entity;
            damage = (float)((double)damage + (double)((int)elb.func_110143_aJ()) * this.getTurretDamageAmpBonus() * (double)TurretHeadUtil.getAmpLevel(this.base));
        }
        if (entity instanceof EntityLivingBase) {
            elb = (EntityLivingBase)entity;
            elb.func_70097_a((DamageSource)new NormalDamageSource(this.getTurretType().getInternalName(), fakeDrops, this.base, (WorldServer)this.func_145831_w(), false), damage * this.getNormalDamageFactor());
            elb.func_70097_a((DamageSource)new ArmorBypassDamageSource(this.getTurretType().getInternalName(), fakeDrops, this.base, (WorldServer)this.func_145831_w(), false), damage * this.getBypassDamageFactor());
        }
    }
}

