/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.component.multiblock;

import io.github.phantamanta44.libnine.component.multiblock.IMultiBlockUnit;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockConnectable;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockType;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class MultiBlockCore<T extends IMultiBlockUnit<T>>
extends MultiBlockConnectable<T> {
    private boolean formed = false;
    private final List<Runnable> formationStatusCallbacks = new ArrayList<Runnable>();

    public MultiBlockCore(T component, MultiBlockType<T> type) {
        super(component, type);
    }

    @Override
    @Nullable
    public MultiBlockCore<T> getCore() {
        return this;
    }

    @Override
    public void setCore(@Nullable MultiBlockCore<T> core) {
        throw new UnsupportedOperationException();
    }

    public boolean isFormed() {
        return this.formed;
    }

    public void onFormationStatusChange(Runnable callback) {
        this.formationStatusCallbacks.add(callback);
    }

    private void postFormationStatusChange() {
        this.formationStatusCallbacks.forEach(Runnable::run);
    }

    public boolean tryForm() {
        if (!this.formed) {
            ArrayDeque searchQueue = new ArrayDeque();
            searchQueue.offer(new SearchNode(this, null, 0));
            while (!searchQueue.isEmpty()) {
                SearchNode searchNode = (SearchNode)searchQueue.pop();
                block5: for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (!searchNode.canTraverse(dir)) continue;
                    switch (searchNode.connectable.tryEmit(dir)) {
                        case SUCCESS: {
                            if (searchNode.distance >= this.getType().getMaxSearchDist()) continue block5;
                            searchQueue.offer(new SearchNode(Objects.requireNonNull(searchNode.connectable.getAdjacent(dir)), dir.func_176734_d(), searchNode.distance + 1));
                            continue block5;
                        }
                        case CONFLICT: {
                            this.destroyTree();
                            return false;
                        }
                    }
                }
            }
            if (!this.getType().checkStructure(this)) {
                this.destroyTree();
                return false;
            }
            this.formed = true;
            this.postFormationStatusChange();
        }
        return true;
    }

    private void destroyTree() {
        ArrayDeque searchQueue = new ArrayDeque();
        searchQueue.offer(this);
        while (!searchQueue.isEmpty()) {
            MultiBlockConnectable connectable = (MultiBlockConnectable)searchQueue.pop();
            for (EnumFacing dir : connectable.getEmittingDirs()) {
                MultiBlockConnectable adjacent = connectable.getAdjacent(dir);
                if (adjacent == null) continue;
                searchQueue.offer(adjacent);
            }
            connectable.clearEmission();
        }
    }

    @Override
    public void disconnect() {
        if (this.formed) {
            this.destroyTree();
            this.formed = false;
            this.postFormationStatusChange();
        }
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        super.serBytes(data);
        data.writeBool(this.formed);
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        super.deserBytes(data);
        this.formed = data.readBool();
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        super.serNBT(tag);
        tag.func_74757_a("Formed", this.formed);
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        super.deserNBT(tag);
        this.formed = tag.func_74767_n("Formed");
    }

    private static class SearchNode<T extends IMultiBlockUnit<T>> {
        final MultiBlockConnectable<T> connectable;
        @Nullable
        final EnumFacing fromDir;
        final int distance;

        SearchNode(MultiBlockConnectable<T> connectable, @Nullable EnumFacing fromDir, int distance) {
            this.connectable = connectable;
            this.fromDir = fromDir;
            this.distance = distance;
        }

        boolean canTraverse(EnumFacing dir) {
            return dir != this.fromDir;
        }
    }
}

