/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.component.reservoir;

import io.github.phantamanta44.libnine.component.reservoir.IIntReservoir;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.function.IIntBiConsumer;
import io.github.phantamanta44.libnine.util.math.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;

public class SimpleIntReservoir
implements IIntReservoir {
    private final int capacity;
    private final Collection<IIntBiConsumer> callbacks;
    private int qty;

    public SimpleIntReservoir(int qty, int capacity) {
        this.qty = qty;
        this.capacity = capacity;
        this.callbacks = new ArrayList<IIntBiConsumer>();
    }

    public SimpleIntReservoir(int capacity) {
        this(0, capacity);
    }

    @Override
    public int getQuantity() {
        return this.qty;
    }

    @Override
    public void setQuantity(int qty) {
        if ((qty = MathUtils.clamp(qty, 0, this.getCapacity())) != this.qty) {
            int oldQty = this.qty;
            this.qty = qty;
            for (IIntBiConsumer callback : this.callbacks) {
                callback.accept(oldQty, qty);
            }
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int draw(int amount, boolean notSimulated) {
        int toTransfer = Math.min(amount, this.getQuantity());
        if (notSimulated) {
            this.offsetQuantity(-toTransfer);
        }
        return toTransfer;
    }

    @Override
    public int offer(int amount, boolean notSimulated) {
        int toTransfer = Math.min(amount, this.getRemainingCapacity());
        if (notSimulated) {
            this.offsetQuantity(toTransfer);
        }
        return toTransfer;
    }

    @Override
    public void onQuantityChange(IIntBiConsumer callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        tag.func_74768_a("Quantity", this.getQuantity());
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        this.setQuantity(tag.func_74762_e("Quantity"));
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        data.writeInt(this.getQuantity());
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        this.setQuantity(data.readInt());
    }
}

