/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import tinker_io.network.MessageHeatSmeltery;
import tinker_io.network.NetworkHandler;
import tinker_io.tileentity.TileEntitySmelteryItemCapacity;

public class TileEntityFuelInputMachine
extends TileEntitySmelteryItemCapacity
implements ITickable {
    public static final int MAX_PROGRESS_COUNT = 250;
    private static final int SLOTS_SIZE = 2;
    public static final String TAG_BURNING_COUNT = "burningCount";
    public static final String TAG_RATIO = "ratio";
    public static final String TAG_TARGET_TEMPERATURE = "targetTemp";
    public static final String TAG_CURRENT_SOLID_FUEL_TEMPERATURE = "currentSolidFuelTemp";
    private TileSmeltery tileSmeltery;
    private int tick = 0;
    private int burningCount = 0;
    private double ratio = 1.0;
    private int targetTemp = 0;
    private boolean isSmelteryHeatingItem = false;
    private int currentSolidFuelTemp = 0;

    public TileEntityFuelInputMachine() {
        super(2);
    }

    @Override
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot == 1 && TileEntityFurnace.func_145954_b((ItemStack)stack)) {
            return this.inventory.insertItem(slot, stack, simulate);
        }
        return super.insertItem(slot, stack, simulate);
    }

    public void func_73660_a() {
        if (this.getMasterPosition() == null) {
            return;
        }
        if (this.tick % 2 == 0) {
            this.tileSmeltery = this.getMasterTile();
            if (this.tileSmeltery != null) {
                this.updateSmelteryHeatingState();
                this.calculateRatio();
                this.calculateTemperature();
                this.burnSolidFuel();
            }
        }
        this.tick = (this.tick + 1) % 20;
    }

    private void calculateRatio() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack == ItemStack.field_190927_a) {
            this.ratio = 1.0;
        }
        this.ratio = (double)stack.func_190916_E() / 10.0 + 1.0;
    }

    private void burnSolidFuel() {
        if (this.currentSolidFuelTemp == 0 && this.isSmelteryHeatingItem && this.inventory.getStackInSlot(1) != ItemStack.field_190927_a) {
            this.currentSolidFuelTemp = this.getSolidFuelTemp();
            this.consumeItemStack(1, 1);
            this.func_70296_d();
        }
        int lastSolidFuelTemp = this.currentSolidFuelTemp;
        if (this.currentSolidFuelTemp != 0) {
            if (this.targetTemp - 300 != this.getNBT().func_74762_e("temperature")) {
                this.setSmelteryTemp(this.targetTemp);
            }
            if (this.burningCount == 0) {
                this.currentSolidFuelTemp = 0;
            }
            this.burningCount = (this.burningCount + 1) % 250;
        }
        if (lastSolidFuelTemp != 0 && this.currentSolidFuelTemp == 0) {
            this.resetTemp();
        }
    }

    public TileSmeltery getMasterTile() {
        TileSmeltery tileSmeltery = null;
        BlockPos masterPos = this.getMasterPosition();
        World world = this.func_145831_w();
        if (this.getHasMaster() && masterPos != null && world.func_175625_s(masterPos) instanceof TileSmeltery) {
            tileSmeltery = (TileSmeltery)world.func_175625_s(masterPos);
        }
        return tileSmeltery;
    }

    private int getFuelTemp() {
        if (this.tileSmeltery == null) {
            return 0;
        }
        FluidStack fluidStack = this.tileSmeltery.currentFuel;
        if (fluidStack != null) {
            return fluidStack.getFluid().getTemperature();
        }
        return 0;
    }

    private int getSolidFuelTemp() {
        int burnTime;
        ItemStack solidFuel = this.inventory.getStackInSlot(1);
        if (solidFuel != ItemStack.field_190927_a && (burnTime = TileEntityFurnace.func_145952_a((ItemStack)solidFuel)) > 0) {
            return burnTime;
        }
        return 0;
    }

    private void calculateTemperature() {
        int originFuelTemp = this.getFuelTemp();
        if (!this.isSmelteryHeatingItem) {
            this.targetTemp = this.getFuelTemp();
            return;
        }
        int fuelTempWithRatio = (int)((double)this.currentSolidFuelTemp * this.ratio);
        int f = fuelTempWithRatio / 2 + originFuelTemp;
        if (fuelTempWithRatio <= 20000) {
            f = fuelTempWithRatio * 6 / 100 + originFuelTemp;
        }
        if (f >= 200000) {
            f = 200000;
        }
        this.targetTemp = f;
    }

    private NBTTagCompound getNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.tileSmeltery != null) {
            this.tileSmeltery.func_189515_b(nbt);
            return nbt;
        }
        return null;
    }

    private void setSmelteryTempNBT(int temperature) {
        NBTTagCompound nbt = this.getNBT();
        if (nbt == null) {
            return;
        }
        nbt.func_74768_a("temperature", temperature);
        if (this.tileSmeltery != null) {
            this.tileSmeltery.func_145839_a(nbt);
        }
    }

    private void setSmelteryTemp(int temperature) {
        int n = temperature = temperature - 300 > 0 ? temperature - 300 : temperature;
        if (!this.field_145850_b.field_72995_K) {
            NetworkHandler.sendToServer(new MessageHeatSmeltery(this.func_174877_v(), temperature));
        }
        this.setSmelteryTempNBT(temperature);
    }

    private int[] getSmelteryTemps() {
        NBTTagCompound nbt = this.getNBT();
        if (nbt != null) {
            return nbt.func_74759_k("itemTemperatures");
        }
        return null;
    }

    private void updateSmelteryHeatingState() {
        NBTTagCompound nbt = this.getNBT();
        if (nbt != null) {
            int[] temps;
            for (int temp : temps = this.getSmelteryTemps()) {
                if (temp <= 0) continue;
                this.isSmelteryHeatingItem = true;
                return;
            }
        }
        this.isSmelteryHeatingItem = false;
    }

    public int getTargetTemp() {
        return this.targetTemp;
    }

    public void resetTemp() {
        this.setSmelteryTemp(this.getFuelTemp());
    }

    public boolean isSmelteryHeatingItem() {
        return this.isSmelteryHeatingItem;
    }

    @SideOnly(value=Side.CLIENT)
    public double getRatio() {
        return this.ratio;
    }

    @SideOnly(value=Side.CLIENT)
    public int getScaledBurningCount(int pixel) {
        return (int)((float)this.burningCount / 250.0f * (float)pixel);
    }

    public int getCurrentSolidFuelTemp() {
        return this.currentSolidFuelTemp;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a(TAG_BURNING_COUNT, this.burningCount);
        compound.func_74780_a(TAG_RATIO, this.ratio);
        compound.func_74768_a(TAG_TARGET_TEMPERATURE, this.targetTemp);
        compound.func_74768_a(TAG_CURRENT_SOLID_FUEL_TEMPERATURE, this.currentSolidFuelTemp);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.burningCount = compound.func_74762_e(TAG_BURNING_COUNT);
        this.ratio = compound.func_74769_h(TAG_RATIO);
        this.targetTemp = compound.func_74762_e(TAG_TARGET_TEMPERATURE);
        this.currentSolidFuelTemp = compound.func_74762_e(TAG_CURRENT_SOLID_FUEL_TEMPERATURE);
        super.func_145839_a(compound);
    }
}

