/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.statements;

import java.util.ArrayList;
import java.util.List;
import stanhebben.zenscript.compiler.EnvironmentScope;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.util.ZenPosition;

public class StatementBlock
extends Statement {
    private final List<Statement> statements;

    public StatementBlock(ZenPosition position, List<Statement> statements) {
        super(position);
        this.statements = statements;
    }

    @Override
    public void compile(IEnvironmentMethod environment) {
        environment.getOutput().position(this.getPosition());
        EnvironmentScope local = new EnvironmentScope(environment);
        for (Statement statement : this.statements) {
            statement.compile(local);
            if (!statement.isReturn()) continue;
            return;
        }
    }

    @Override
    public void compile(IEnvironmentMethod environment, boolean forced) {
        environment.getOutput().position(this.getPosition());
        EnvironmentScope local = new EnvironmentScope(environment);
        for (Statement statement : this.statements) {
            statement.compile(local, forced);
            if (!statement.isReturn()) continue;
            return;
        }
    }

    @Override
    public List<Statement> getSubStatements() {
        ArrayList<Statement> out = new ArrayList<Statement>();
        out.add(this);
        for (Statement statement : this.statements) {
            out.addAll(statement.getSubStatements());
        }
        return out;
    }
}

