/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.api.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.romvoid95.api.feature.Feature;
import net.romvoid95.api.feature.IFeature;
import net.romvoid95.galactic.core.GCTLog;

public abstract class Module {
    protected List<Feature> features = new ArrayList<Feature>();
    private List<Feature> enabledFeatures = new ArrayList<Feature>();

    public Module() {
        this.addClientFeatures();
        this.addCommonFeatures();
    }

    public abstract void addClientFeatures();

    public abstract void addCommonFeatures();

    public abstract void setupConfig();

    public void handleFeatures() {
        this.features.stream().filter(IFeature::isEnabled).forEach(feature -> {
            GCTLog.debug("Feature Enabled: " + feature.getClass().getSimpleName());
            this.enabledFeatures.add((Feature)feature);
        });
    }

    public void preInit() {
        this.setupConfig();
        this.enabledFeatures.stream().filter(Feature::usesEvents).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.enabledFeatures.forEach(Feature::preInit);
    }

    public void proxyPreInit() {
        this.enabledFeatures.stream().filter(Feature::sidedProxy).forEach(arg_0 -> ((EventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        this.enabledFeatures.forEach(Feature::proxyPreInit);
    }

    public void init() {
        this.enabledFeatures.forEach(Feature::init);
    }

    public void postInit() {
        this.enabledFeatures.forEach(Feature::postInit);
    }

    public void proxyInit() {
        this.enabledFeatures.forEach(Feature::proxyInit);
    }

    public void proxyPostInit() {
        this.enabledFeatures.forEach(Feature::proxyPostInit);
    }

    public void serverStartingEvent(FMLServerStartingEvent event) {
        this.enabledFeatures.forEach(feature -> feature.ServerStartingEvent(event));
    }

    protected void registerFeature(Feature feature) {
        this.features.add(feature);
    }
}

