/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.core.client.gui.element;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public abstract class GuiElement
extends Gui {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    protected final FontRenderer fontRenderer;
    public int packedFGColour;
    protected Minecraft mc = Minecraft.func_71410_x();
    protected int width;
    protected int height;
    protected int id;
    protected boolean hovered;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected static final ResourceLocation errorIcon = new ResourceLocation("galactictweaks", "textures/gui/imgerror.png");
    private int x;
    private int y;
    private String[] tooltips = new String[0];
    private int assignedPage = -1;

    protected GuiElement(int x, int y, int width, int height) {
        this.fontRenderer = this.mc.field_71466_p;
        this.setX(x);
        this.setY(y);
        this.width = width;
        this.height = height;
    }

    final BufferedImage scaleImage(BufferedImage img, int width, int height) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dimg = new BufferedImage(width, height, img.getType());
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, width, height, 0, 0, w, h, null);
        g.dispose();
        return dimg;
    }

    final BufferedImage loadImageFromURL(String url) throws IOException {
        HttpURLConnection httpcon = (HttpURLConnection)new URL(url).openConnection();
        httpcon.addRequestProperty("User-Agent", "Minecraft");
        BufferedImage img = ImageIO.read(httpcon.getInputStream());
        httpcon.disconnect();
        return img;
    }

    public boolean canHaveTooltip() {
        return true;
    }

    public String[] getTooltips() {
        return this.tooltips;
    }

    public final void setTooltips(String ... strings) {
        this.tooltips = strings;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public final int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public final int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public void playPressSound() {
        this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)(this.enabled ? 1.0f : 0.5f)));
    }

    public abstract void draw(int var1, int var2, float var3);

    public abstract void mouseClick(int var1, int var2, int var3);

    public abstract void mouseReleased(int var1, int var2, int var3);

    public abstract void keyTyped(char var1, int var2);

    public abstract void mouseClickMove(int var1, int var2, int var3, long var4);

    public void updateElement() {
    }

    public void handleMouseInput() {
    }

    public void handleKeyboardInput() {
    }

    public final void disable() {
        this.setEnabled(false);
    }

    public final void enable() {
        this.setEnabled(true);
    }

    public final void hide() {
        this.setVisible(false);
    }

    public final void show() {
        this.setVisible(true);
    }

    public final void assignToPage(int page) {
        this.assignedPage = page;
    }

    public final int getAssignedPage() {
        return this.assignedPage;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }
}

