/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.Charsets;

public class CapeUtil {
    private static final CapeUtil instance = new CapeUtil();
    private URLConnection connection;

    public static CapeUtil instance() {
        return instance;
    }

    private CapeUtil() {
        try {
            URL jsonUrl = new URL("https://raw.githubusercontent.com/TeamGalacticraft/capes/legacy/capesList.json");
            this.connection = jsonUrl.openConnection();
            this.connection.setConnectTimeout(10000);
            this.connection.setReadTimeout(10000);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCape(String uuid) {
        StringBuilder object = new StringBuilder();
        List<String> lines = this.readLines(this.connection);
        for (String line : lines) {
            object.append(line);
        }
        JsonElement json = new JsonParser().parse(object.toString());
        JsonObject obj = json.getAsJsonObject();
        try {
            return obj.getAsJsonObject("players").get(uuid).getAsString();
        }
        catch (Exception e) {
            return "none";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readLines(URLConnection connection) {
        ArrayList<String> list = new ArrayList<String>();
        try (InputStream inputStream = connection.getInputStream();){
            String line;
            InputStreamReader reader = new InputStreamReader(inputStream, Charsets.toCharset((Charset)StandardCharsets.UTF_8));
            BufferedReader bufReader = new BufferedReader(reader);
            while ((line = bufReader.readLine()) != null) {
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return list;
        }
    }
}

