/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.saltFission.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.saltFission.SaltFissionReactor;
import nc.multiblock.saltFission.SaltFissionVesselSetting;
import nc.multiblock.saltFission.tile.TileSaltFissionModerator;
import nc.multiblock.saltFission.tile.TileSaltFissionPartBase;
import nc.radiation.RadiationHelper;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.fluid.ITileFluid;
import nc.tile.generator.IFluidGenerator;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.util.GasHelper;
import nc.util.RegistryHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileSaltFissionVessel
extends TileSaltFissionPartBase
implements IFluidGenerator,
ITileFluid {
    @Nonnull
    private final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(2592, NCRecipes.salt_fission_valid_fluids.get(0)), new Tank(5184, new ArrayList<String>()), new Tank(2592, new ArrayList<String>())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{TankSorption.NON, TankSorption.NON, TankSorption.NON}));
    @Nonnull
    private FluidTileWrapper[] fluidSides;
    @Nonnull
    private GasTileWrapper gasWrapper;
    @Nonnull
    private SaltFissionVesselSetting[] vesselSettings = new SaltFissionVesselSetting[]{SaltFissionVesselSetting.DISABLED, SaltFissionVesselSetting.DISABLED, SaltFissionVesselSetting.DISABLED, SaltFissionVesselSetting.DISABLED, SaltFissionVesselSetting.DISABLED, SaltFissionVesselSetting.DISABLED};
    public final int fluidInputSize = 1;
    public final int fluidOutputSize = 1;
    public double baseProcessTime = 1.0;
    public double baseProcessHeat = 0.0;
    public double baseProcessRadiation = 0.0;
    private int baseVesselEfficiency;
    private int baseVesselMaxEfficiency;
    private double moderatorExtraEfficiency;
    private double moderatorMaxExtraEfficiency;
    private double moderatorHeatFactor;
    private double moderatorMaxHeatFactor;
    public boolean distributedTo = false;
    public boolean retrievedFrom = false;
    public double time;
    public boolean isProcessing;
    public boolean hasConsumed;
    public boolean canProcessInputs;
    public static final ProcessorRecipeHandler RECIPE_HANDLER = NCRecipes.salt_fission;
    protected RecipeInfo<ProcessorRecipe> recipeInfo;
    protected int vesselCount;

    public TileSaltFissionVessel() {
        super(CuboidalPartPositionType.INTERIOR);
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
    }

    @Override
    public void onMachineAssembled(SaltFissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    public void calculateEfficiency() {
        int newEfficiency = 1;
        int newMaxEfficiency = 1;
        block0: for (EnumFacing dir : EnumFacing.field_82609_l) {
            PartCheckInfo info = this.isVessel(dir, 1);
            if (info.partValid) {
                if (info.partActive) {
                    ++newEfficiency;
                }
                ++newMaxEfficiency;
                continue;
            }
            for (int i = 1; i <= NCConfig.fission_neutron_reach && this.isModerator(dir, i, false); ++i) {
                info = this.isVessel(dir, i + 1);
                if (!info.partValid) continue;
                if (info.partActive) {
                    ++newEfficiency;
                }
                ++newMaxEfficiency;
                continue block0;
            }
        }
        int moderatorCount = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.isModerator(dir, 1, true)) continue;
            ++moderatorCount;
        }
        this.baseVesselEfficiency = newEfficiency;
        this.baseVesselMaxEfficiency = newMaxEfficiency;
        this.moderatorExtraEfficiency = (double)(newEfficiency * moderatorCount) * NCConfig.fission_moderator_extra_power / 6.0;
        this.moderatorMaxExtraEfficiency = (double)(newMaxEfficiency * moderatorCount) * NCConfig.fission_moderator_extra_power / 6.0;
        this.moderatorHeatFactor = (double)(newEfficiency * moderatorCount) * NCConfig.fission_moderator_extra_heat / 6.0;
        this.moderatorMaxHeatFactor = (double)(newMaxEfficiency * moderatorCount) * NCConfig.fission_moderator_extra_heat / 6.0;
    }

    private PartCheckInfo isVessel(EnumFacing dir, int offset) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(dir, offset));
        if (!(tile instanceof TileSaltFissionVessel)) {
            return new PartCheckInfo(false, false);
        }
        TileSaltFissionVessel vessel = (TileSaltFissionVessel)tile;
        return new PartCheckInfo(vessel.isMultiblockAssembled(), vessel.canProcessInputs && vessel.isMultiblockAssembled());
    }

    private boolean isModerator(EnumFacing dir, int offset, boolean isInValidPosition) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(dir, offset));
        if (!(tile instanceof TileSaltFissionModerator)) {
            return false;
        }
        TileSaltFissionModerator moderator = (TileSaltFissionModerator)tile;
        moderator.isInModerationLine = true;
        if (isInValidPosition && this.canProcessInputs) {
            moderator.isInValidPosition = true;
        }
        return true;
    }

    public void doMeltdown() {
        IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)this.field_145850_b.func_175726_f(this.field_174879_c));
        if (chunkSource != null) {
            RadiationHelper.addToSourceRadiation(chunkSource, 8.0 * this.baseProcessRadiation * this.getSpeedMultiplier() * NCConfig.salt_fission_meltdown_radiation_multiplier);
        }
        IBlockState corium = RegistryHelper.getBlock("nuclearcraft:fluid_corium").func_176223_P();
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, corium);
        if (this.getMultiblock() != null) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos offPos = this.field_174879_c.func_177972_a(dir);
                if (!(((SaltFissionReactor)this.getMultiblock()).rand.nextDouble() < 0.75)) continue;
                this.field_145850_b.func_175713_t(offPos);
                this.field_145850_b.func_175656_a(offPos, corium);
            }
        }
    }

    public double getEfficiency() {
        return (double)this.baseVesselEfficiency + this.moderatorExtraEfficiency;
    }

    public double getMaxEfficiency() {
        return (double)this.baseVesselMaxEfficiency + this.moderatorMaxExtraEfficiency;
    }

    public double getHeatMultiplier() {
        return (double)this.baseVesselEfficiency * ((double)this.baseVesselEfficiency + 1.0) * 0.5 + this.moderatorHeatFactor;
    }

    public double getMaxHeatMultiplier() {
        return (double)this.baseVesselMaxEfficiency * ((double)this.baseVesselMaxEfficiency + 1.0) * 0.5 + this.moderatorMaxHeatFactor;
    }

    public double getProcessHeat() {
        return this.getHeatMultiplier() * this.baseProcessHeat * NCConfig.salt_fission_heat_generation;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
            this.hasConsumed = this.hasConsumed();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateVessel();
    }

    public void updateVessel() {
        if (!this.field_145850_b.field_72995_K) {
            this.setIsReactorOn();
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            this.tickVessel();
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
            }
            if (this.vesselCount == 0) {
                this.pushFluid();
                this.refreshRecipe();
                this.refreshActivity();
            }
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void tickVessel() {
        ++this.vesselCount;
        this.vesselCount %= NCConfig.machine_update_rate / 2;
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = RECIPE_HANDLER.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs(this.hasConsumed));
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs();
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public double getSpeedMultiplier() {
        return NCConfig.salt_fission_fuel_use;
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = 1.0;
            this.baseProcessHeat = 0.0;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipeInfo.getRecipe().getSaltFissionFuelTime();
        this.baseProcessHeat = this.recipeInfo.getRecipe().getSaltFissionFuelHeat();
        this.baseProcessRadiation = this.recipeInfo.getRecipe().getSaltFissionFuelRadiation();
        return true;
    }

    public boolean isProcessing() {
        return this.readyToProcess() && this.isReactorOn;
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed && this.isMultiblockAssembled();
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < 1; ++i) {
            if (this.tanks.get(i + 1 + 1).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (this.hasConsumed && !validRecipe) {
            for (Tank tank : this.getFluidInputs(true)) {
                tank.setFluidStored(null);
            }
            this.hasConsumed = false;
        }
        if (!canProcess) {
            this.time = MathHelper.func_151237_a((double)this.time, (double)0.0, (double)(this.baseProcessTime - 1.0));
        }
        return canProcess;
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.tanks.get(j + 1).isEmpty()) continue;
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.tanks.get(j + 1).getFluidAmount() + fluidProduct.getMaxStackSize(0) <= this.tanks.get(j + 1).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        List<Integer> fluidInputOrder = this.recipeInfo.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            if (this.tanks.get(i + 1 + 1).isEmpty()) continue;
            this.tanks.get(i + 1 + 1).setFluid(null);
        }
        for (i = 0; i < 1; ++i) {
            int maxStackSize = this.getFluidIngredients().get(fluidInputOrder.get(i)).getMaxStackSize(this.recipeInfo.getFluidIngredientNumbers().get(i));
            if (maxStackSize > 0) {
                this.tanks.get(i + 1 + 1).setFluidStored(new FluidStack(this.tanks.get(i).getFluid(), maxStackSize));
                this.tanks.get(i).changeFluidAmount(-maxStackSize);
            }
            if (!this.tanks.get(i).isEmpty()) continue;
            this.tanks.get(i).setFluid(null);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.getSpeedMultiplier());
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        this.time = !this.setRecipeStats() ? 0.0 : MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        for (int i = 2; i < 3; ++i) {
            this.tanks.get(i).setFluid(null);
        }
        if (!this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getNextStackSize(0) <= 0) continue;
            if (this.tanks.get(j + 1).isEmpty()) {
                this.tanks.get(j + 1).setFluidStored(fluidProduct.getNextStack(0));
                continue;
            }
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) continue;
            this.tanks.get(j + 1).changeFluidAmount(fluidProduct.getNextStackSize(0));
        }
        this.hasConsumed = false;
    }

    @Override
    public List<Tank> getFluidInputs(boolean consumed) {
        return consumed ? this.tanks.subList(2, 3) : this.tanks.subList(0, 1);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipeInfo.getRecipe().fluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipeInfo.getRecipe().fluidProducts();
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Nonnull
    public SaltFissionVesselSetting[] getVesselSettings() {
        return this.vesselSettings;
    }

    public void setVesselSettings(@Nonnull SaltFissionVesselSetting[] settings) {
        this.vesselSettings = settings;
    }

    public SaltFissionVesselSetting getVesselSetting(@Nonnull EnumFacing side) {
        return this.vesselSettings[side.func_176745_a()];
    }

    public void setVesselSetting(@Nonnull EnumFacing side, @Nonnull SaltFissionVesselSetting setting) {
        this.vesselSettings[side.func_176745_a()] = setting;
    }

    public void toggleVesselSetting(@Nonnull EnumFacing side) {
        this.setVesselSetting(side, this.getVesselSetting(side).next());
        this.refreshFluidConnections(side);
        this.markDirtyAndNotify();
    }

    public void refreshFluidConnections(@Nonnull EnumFacing side) {
        switch (this.getVesselSetting(side)) {
            case DISABLED: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            case DEFAULT: {
                this.setTankSorption(side, 0, TankSorption.IN);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            case DEPLETED_OUT: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.OUT);
                break;
            }
            case FUEL_SPREAD: {
                this.setTankSorption(side, 0, TankSorption.OUT);
                this.setTankSorption(side, 1, TankSorption.NON);
                break;
            }
            default: {
                this.setTankSorption(side, 0, TankSorption.NON);
                this.setTankSorption(side, 1, TankSorption.NON);
            }
        }
    }

    @Override
    public void pushFluidToSide(@Nonnull EnumFacing side) {
        block8: {
            TileEntity tile;
            SaltFissionVesselSetting thisSetting;
            block5: {
                SaltFissionVesselSetting vesselSetting;
                TileSaltFissionVessel vessel;
                block6: {
                    block7: {
                        thisSetting = this.getVesselSetting(side);
                        if (thisSetting == SaltFissionVesselSetting.DISABLED) {
                            return;
                        }
                        tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
                        if (!(tile instanceof TileSaltFissionVessel)) break block5;
                        vessel = (TileSaltFissionVessel)tile;
                        vesselSetting = vessel.getVesselSetting(side.func_176734_d());
                        if (thisSetting != SaltFissionVesselSetting.FUEL_SPREAD) break block6;
                        if (vesselSetting != SaltFissionVesselSetting.DEFAULT) break block7;
                        this.pushFuel(vessel);
                        this.pushDepleted(vessel);
                        break block8;
                    }
                    if (vesselSetting != SaltFissionVesselSetting.DEPLETED_OUT) break block8;
                    this.pushFuel(vessel);
                    break block8;
                }
                if (thisSetting != SaltFissionVesselSetting.DEPLETED_OUT || vesselSetting != SaltFissionVesselSetting.DEFAULT && vesselSetting != SaltFissionVesselSetting.FUEL_SPREAD) break block8;
                this.pushDepleted(vessel);
                break block8;
            }
            if (thisSetting == SaltFissionVesselSetting.DEPLETED_OUT) {
                IFluidHandler adjStorage;
                if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
                    return;
                }
                IFluidHandler iFluidHandler = adjStorage = tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                if (adjStorage == null) {
                    return;
                }
                for (int i = 0; i < this.getTanks().size(); ++i) {
                    if (this.getTanks().get(i).getFluid() == null || !this.getTankSorption(side, i).canDrain()) continue;
                    this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
                }
            }
        }
    }

    public void pushFuel(TileSaltFissionVessel other) {
        int diff = this.getTanks().get(0).getFluidAmount() - other.getTanks().get(0).getFluidAmount();
        if (diff > 1) {
            this.getTanks().get(0).drain(other.getTanks().get(0).fillInternal(this.getTanks().get(0).drain((int)((double)diff * NCConfig.salt_fission_vessel_spread_ratio), false), true), true);
        }
    }

    public void pushDepleted(TileSaltFissionVessel other) {
        this.getTanks().get(1).drain(other.getTanks().get(1).fillInternal(this.getTanks().get(1).drain(this.getTanks().get(1).getCapacity(), false), true), true);
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    public NBTTagCompound writeVesselSettings(NBTTagCompound nbt) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            settingsTag.func_74768_a("setting" + side.func_176745_a(), this.getVesselSetting(side).ordinal());
        }
        nbt.func_74782_a("vesselSettings", (NBTBase)settingsTag);
        return nbt;
    }

    public void readVesselSettings(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fluidConnections0")) {
            block6: for (EnumFacing side : EnumFacing.field_82609_l) {
                TankSorption sorption = TankSorption.values()[nbt.func_74762_e("fluidConnections" + side.func_176745_a())];
                switch (sorption) {
                    case NON: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setVesselSetting(side, SaltFissionVesselSetting.DISABLED);
                        continue block6;
                    }
                    case BOTH: {
                        this.setTankSorption(side, 0, TankSorption.IN);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setVesselSetting(side, SaltFissionVesselSetting.DEFAULT);
                        continue block6;
                    }
                    case IN: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.OUT);
                        this.setVesselSetting(side, SaltFissionVesselSetting.DEPLETED_OUT);
                        continue block6;
                    }
                    case OUT: {
                        this.setTankSorption(side, 0, TankSorption.OUT);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setVesselSetting(side, SaltFissionVesselSetting.FUEL_SPREAD);
                        continue block6;
                    }
                    default: {
                        this.setTankSorption(side, 0, TankSorption.NON);
                        this.setTankSorption(side, 1, TankSorption.NON);
                        this.setVesselSetting(side, SaltFissionVesselSetting.DISABLED);
                    }
                }
            }
        } else {
            NBTTagCompound settingsTag = nbt.func_74775_l("vesselSettings");
            for (EnumFacing side : EnumFacing.field_82609_l) {
                this.setVesselSetting(side, SaltFissionVesselSetting.values()[settingsTag.func_74762_e("setting" + side.func_176745_a())]);
                this.refreshFluidConnections(side);
            }
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeVesselSettings(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("baseProcessHeat", this.baseProcessHeat);
        nbt.func_74768_a("baseVesselEfficiency", this.baseVesselEfficiency);
        nbt.func_74768_a("baseVesselMaxEfficiency", this.baseVesselMaxEfficiency);
        nbt.func_74780_a("moderatorExtraEfficiency", this.moderatorExtraEfficiency);
        nbt.func_74780_a("moderatorMaxExtraEfficiency", this.moderatorMaxExtraEfficiency);
        nbt.func_74780_a("moderatorHeatFactor", this.moderatorHeatFactor);
        nbt.func_74780_a("moderatorMaxHeatFactor", this.moderatorMaxHeatFactor);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readVesselSettings(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.baseProcessHeat = nbt.func_74769_h("baseProcessHeat");
        this.baseVesselEfficiency = nbt.func_74762_e("baseVesselEfficiency");
        this.baseVesselMaxEfficiency = nbt.func_74762_e("baseVesselMaxEfficiency");
        this.moderatorExtraEfficiency = nbt.func_74769_h("moderatorExtraEfficiency");
        this.moderatorMaxExtraEfficiency = nbt.func_74769_h("moderatorMaxExtraEfficiency");
        this.moderatorHeatFactor = nbt.func_74769_h("moderatorHeatFactor");
        this.moderatorMaxHeatFactor = nbt.func_74769_h("moderatorMaxHeatFactor");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || ModCheck.mekanismLoaded() && NCConfig.enable_mek_gas && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == GasHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && !this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getGasWrapper();
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    private static class PartCheckInfo {
        final boolean partValid;
        final boolean partActive;

        PartCheckInfo(boolean partValid, boolean partActive) {
            this.partValid = partValid;
            this.partActive = partActive;
        }
    }
}

