/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualManager;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileAltar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@RitualRegister(value="well_of_suffering")
public class RitualWellOfSuffering
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String DAMAGE_RANGE = "damage";
    public static final int SACRIFICE_AMOUNT = 25;
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);

    public RitualWellOfSuffering() {
        super("ritualWellOfSuffering", 0, 40000, "ritual.bloodmagic.wellOfSufferingRitual");
        this.addBlockRange(ALTAR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(DAMAGE_RANGE, 0, 15, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        BlockPos altarPos = pos.func_177971_a((Vec3i)this.altarOffsetPos);
        TileEntity tile = world.func_175625_s(altarPos);
        AreaDescriptor altarRange = masterRitualStone.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof TileAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof TileAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.func_177973_b((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        if (tile instanceof TileAltar) {
            TileAltar tileAltar = (TileAltar)tile;
            AreaDescriptor damageRange = masterRitualStone.getBlockRange(DAMAGE_RANGE);
            AxisAlignedBB range = damageRange.getAABB(pos);
            List entities = world.func_72872_a(EntityLivingBase.class, range);
            for (EntityLivingBase entity : entities) {
                int lifeEssenceRatio;
                EntityEntry entityEntry = EntityRegistry.getEntry(entity.getClass());
                if (entityEntry == null || BloodMagicAPI.INSTANCE.getBlacklist().getSacrifice().contains(entityEntry.getRegistryName()) || (lifeEssenceRatio = BloodMagicAPI.INSTANCE.getValueManager().getSacrificial().getOrDefault(entityEntry.getRegistryName(), 25).intValue()) <= 0 || !entity.func_70089_S() || entity instanceof EntityPlayer || !entity.func_70097_a(RitualManager.RITUAL_DAMAGE, 1.0f)) continue;
                if (entity.func_70631_g_()) {
                    lifeEssenceRatio = (int)((float)lifeEssenceRatio * 0.5f);
                }
                tileAltar.sacrificialDaggerCall(lifeEssenceRatio, true);
                if (++totalEffects < maxEffects) continue;
                break;
            }
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, -3, -1, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 2, 4, -1, EnumRuneType.WATER);
        this.addOffsetRunes(components, 1, 4, 0, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 1, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualWellOfSuffering();
    }
}

