/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.proxy;

import com.sosnitzka.taiga.Blocks;
import com.sosnitzka.taiga.Fluids;
import com.sosnitzka.taiga.Items;
import com.sosnitzka.taiga.Keybindings;
import com.sosnitzka.taiga.MaterialTraits;
import com.sosnitzka.taiga.TAIGAConfiguration;
import com.sosnitzka.taiga.book.ContentOre;
import com.sosnitzka.taiga.proxy.CommonProxy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.tconstruct.library.book.TinkerBook;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.texture.MetalTextureTexture;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.utils.HarvestLevels;

public class ClientProxy
extends CommonProxy {
    private static void registerBlockModel(Block block) {
        ClientProxy.registerItemModel(Item.func_150898_a((Block)block));
    }

    private static void registerItemModel(Item item) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @Override
    public void regsiterKeyBindings() {
        ClientRegistry.registerKeyBinding((KeyBinding)Keybindings.altKey);
    }

    @Override
    public void registerModels() {
        Field[] blockFields;
        Field[] itemFields;
        for (Field field : itemFields = Items.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            Class<?> targetType = field.getType();
            try {
                Item item = (Item)field.get(targetType);
                ClientProxy.registerItemModel(item);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (Field field : blockFields = Blocks.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            Class<?> targetType = field.getType();
            try {
                Block block = (Block)field.get(targetType);
                ClientProxy.registerBlockModel(block);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setRenderInfo(Material material) {
        if (material.equals(MaterialTraits.adamant)) {
            this.metalRender(material, Fluids.adamantFluid.getColor(), 1.0f, 0.8f, 0.0f);
        } else if (material.equals(MaterialTraits.duranite)) {
            this.metalRender(material, Fluids.duraniteFluid.getColor(), 0.4f, 0.4f, 0.0f);
        } else if (material.equals(MaterialTraits.tiberium)) {
            this.metalRender(material, Fluids.tiberiumFluid.getColor(), 1.0f, 0.3f, 0.0f);
        } else if (material.equals(MaterialTraits.palladium)) {
            this.metalRender(material, Fluids.palladiumFluid.getColor(), 0.7f, 0.6f, 0.0f);
        } else if (material.equals(MaterialTraits.osram)) {
            this.metalRender(material, Fluids.osramFluid.getColor(), 0.7f, 0.6f, 0.0f);
        } else if (material.equals(MaterialTraits.tritonite)) {
            this.metalRender(material, Fluids.tritoniteFluid.getColor(), 0.3f, 0.3f, 0.0f);
        } else if (material.equals(MaterialTraits.nucleum)) {
            this.metalRender(material, Fluids.nucleumFluid.getColor(), 0.4f, 0.6f, 0.2f);
        } else if (material.equals(MaterialTraits.triberium)) {
            this.metalRender(material, Fluids.triberiumFluid.getColor(), 2.0f, 2.0f, 0.5f);
        } else if (material.equals(MaterialTraits.solarium)) {
            this.metalRender(material, Fluids.solariumFluid.getColor(), 1.5f, 1.5f, 0.5f);
        } else if (material.equals(MaterialTraits.uru)) {
            this.metalRender(material, Fluids.uruFluid.getColor(), 1.0f, 1.0f, 0.3f);
        } else if (material.equals(MaterialTraits.imperomite)) {
            this.metalRender(material, Fluids.imperomiteFluid.getColor(), 0.4f, 1.0f, 0.7f);
        } else if (material.equals(MaterialTraits.vibranium)) {
            this.metalRender(material, Fluids.vibraniumFluid.getColor(), 0.6f, 0.8f, 1.0f);
        } else if (material.equals(MaterialTraits.valyrium)) {
            this.metalRender(material, Fluids.valyriumFluid.getColor(), 0.8f, 1.5f, -0.1f);
        } else {
            material.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.BlockTexture(new ResourceLocation("taiga:blocks/block/" + material.getIdentifier())));
        }
    }

    private void metalRender(final Material material, final int f, final float shine, final float brightness, final float hueshift) {
        material.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            public TextureAtlasSprite getTexture(ResourceLocation baseTexture, String location) {
                return new MetalTextureTexture(new ResourceLocation("taiga:materials/" + material.getIdentifier()), baseTexture, location, f, shine, brightness, hueshift);
            }
        });
    }

    @Override
    public void registerFluidModels(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            FluidStateMapper mapper = new FluidStateMapper(fluid);
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    @Override
    public void initConfig() {
        super.initConfig();
        TAIGAConfiguration.clientPreInit();
    }

    @Override
    public void registerBookPages() {
        TinkerBook.INSTANCE.addRepository((BookRepository)new FileRepository("taiga:book"));
        BookLoader.registerPageType((String)"taigaore", ContentOre.class);
    }

    @Override
    public void registerHarvestLevels() {
        HarvestLevels.harvestLevelNames.put(5, I18n.func_135052_a((String)"harvestlevel.duranite", (Object[])new Object[]{TextFormatting.GREEN, TextFormatting.RESET}));
        HarvestLevels.harvestLevelNames.put(6, I18n.func_135052_a((String)"harvestlevel.valyrium", (Object[])new Object[]{TextFormatting.GOLD, TextFormatting.RESET}));
        HarvestLevels.harvestLevelNames.put(7, I18n.func_135052_a((String)"harvestlevel.vibranium", (Object[])new Object[]{TextFormatting.DARK_PURPLE, TextFormatting.RESET}));
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final Fluid fluid;
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.fluid = fluid;
            this.location = new ModelResourceLocation(new ResourceLocation("taiga", "fluid_block"), fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

