/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.sosnitzka.taiga.Keybindings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitCatcher
extends AbstractTrait {
    public static int chance = 3;
    public static float costMulti = 0.25f;

    public TraitCatcher() {
        super(TraitCatcher.class.getSimpleName().toLowerCase().substring(5), TextFormatting.RED);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void killEntity(LivingDeathEvent event) {
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer || event.getEntityLiving() instanceof EntityPlayerMP) {
            return;
        }
        World w = event.getSource().func_76346_g().func_130014_f_();
        EntityPlayer p = (EntityPlayer)event.getSource().func_76346_g();
        if (!TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)p.func_184614_ca()), (String)this.identifier)) {
            return;
        }
        EntityLivingBase target = event.getEntityLiving();
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)p.func_184614_ca());
        Data data = Data.read(tag);
        if (!data.mobClass.isEmpty()) {
            return;
        }
        if (!w.field_72995_K && random.nextInt((int)target.func_110138_aP()) <= chance && target instanceof EntityLiving) {
            event.setCanceled(true);
            target.func_184174_b(false);
            if (data.mobClass.isEmpty()) {
                data.mobClass = target.getClass().getName();
                data.mobName = target.func_70005_c_();
                data.write(tag);
                TagUtil.setExtraTag((ItemStack)p.func_184614_ca(), (NBTTagCompound)tag);
                p.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                target.func_184174_b(false);
                target.func_70106_y();
            }
        }
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Data data = Data.read(tag);
            if (data.mobClass.isEmpty()) {
                TagUtil.setEnchantEffect((ItemStack)tool, (boolean)false);
            } else {
                TagUtil.setEnchantEffect((ItemStack)tool, (boolean)true);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        World w = event.getWorld();
        BlockPos pos = event.getEntityPlayer().func_180425_c();
        ItemStack tool = event.getEntityPlayer().func_184614_ca();
        if (!w.field_72995_K && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier) && Keybindings.altKey.func_151470_d()) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Data data = Data.read(tag);
            if (!data.mobClass.isEmpty()) {
                Entity ent = null;
                try {
                    ent = (Entity)Class.forName(data.mobClass).getConstructor(World.class).newInstance(w);
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
                if (ent != null) {
                    ent.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    w.func_72838_d(ent);
                    event.getEntityPlayer().func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    data.mobClass = "";
                    data.mobName = "";
                    data.write(tag);
                    TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
                    ToolHelper.damageTool((ItemStack)tool, (int)random.nextInt((int)((float)ToolHelper.getCurrentDurability((ItemStack)tool) * costMulti)), (EntityLivingBase)event.getEntityPlayer());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        ItemStack tool = e.getItemStack();
        if (TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier)) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Data data = Data.read(tag);
            if (!data.mobClass.isEmpty()) {
                e.getToolTip().add(TextFormatting.DARK_PURPLE + "Captured: " + TextFormatting.LIGHT_PURPLE + data.mobName);
            }
        }
    }

    public static class Data {
        String mobClass;
        String mobName;

        public static Data read(NBTTagCompound tag) {
            Data data = new Data();
            data.mobName = tag.func_74779_i("mobName");
            data.mobClass = tag.func_74779_i("mobClass");
            return data;
        }

        public void write(NBTTagCompound tag) {
            tag.func_74778_a("mobClass", this.mobClass);
            tag.func_74778_a("mobName", this.mobName);
        }
    }
}

