/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.gui.screen;

import asmodeuscore.AsmodeusCore;
import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.space.ICelestialRegistry;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.SpaceData;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProviderSpace;
import asmodeuscore.core.astronomy.gui.screen.GuiCustomTeleporting;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.network.packet.ACPacketSimple;
import asmodeuscore.core.utils.ACCompatibilityManager;
import asmodeuscore.core.utils.Utils;
import asmodeuscore.core.utils.UtilsGC;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class NewGuiCelestialSelection
extends GuiCelestialSelection {
    protected EnumView viewState = EnumView.GS;
    private String galaxy = GalacticraftCore.planetOverworld.getParentSolarSystem().getUnlocalizedParentGalaxyName();
    private List<String> galaxylist = new ArrayList<String>();
    private List<SolarSystem> starlist = new ArrayList<SolarSystem>();
    private boolean showStarList = false;
    private boolean showGalaxyList = false;
    private boolean enableNewTierSystem = AsmodeusConfig.enableNewTierSystem;
    private double isometx = AsmodeusConfig.enable2DGalaxyMap ? 0.0 : 55.0;
    private double isometz = 45.0;
    private double mindistance = 900.0;
    private boolean hideInfo = false;
    private int currenttier = 0;
    private int tierneed = -1;
    private double timer;
    private double traveltime;
    private boolean enableTraveltime = false;
    private int coef;
    private boolean canTravel = true;
    private boolean small_mode;
    private int small_page;
    private SpaceData.Engine_Type engine;
    public SpaceData data;
    private int fuelSet;
    private int fuelRocketLevel;
    protected static final int LIGHTBLUE = ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255);
    protected static final int YELLOW = ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0);
    public static ResourceLocation guiMain2 = new ResourceLocation("asmodeuscore", "textures/gui/celestialselection2.png");
    public static ResourceLocation guiImg = new ResourceLocation("asmodeuscore", "textures/gui/galaxymap_1.png");
    public static ResourceLocation vortexTexture = new ResourceLocation("asmodeuscore", "textures/gui/celestialbodies/vortex.png");
    private double xImgOffset;
    private double yImgOffset;
    private int scroll;
    private int max_scroll;
    private Vec3d nebula_color;
    private int nebula_img;
    private boolean isSecondPassenger;

    public NewGuiCelestialSelection(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations, SpaceData data) {
        super(mapMode, possibleBodies, canCreateStations);
        this.small_mode = Minecraft.func_71410_x().field_71474_y.field_74335_Z == 0;
        this.small_page = 0;
        this.engine = SpaceData.Engine_Type.FUEL_ENGINE;
        this.fuelSet = 0;
        this.fuelRocketLevel = 0;
        this.xImgOffset = 0.0;
        this.yImgOffset = 0.0;
        this.scroll = 0;
        this.max_scroll = 8;
        this.nebula_color = new Vec3d(1.0, 1.0, 1.0);
        this.nebula_img = 0;
        this.data = data;
        int tier = 0;
        if (this.data != null) {
            tier = (Integer)this.data.getValue(data.rocket_tier);
            this.engine = (SpaceData.Engine_Type)((Object)this.data.getValue(data.rocket_engine));
            this.fuelRocketLevel = (Integer)this.data.getValue(data.rocket_count_fuel);
            this.isSecondPassenger = (Boolean)this.data.getValue(data.second_passenger);
        }
        this.currenttier = tier;
        this.coef = AsmodeusConfig.speedTimeTravel - 1 + tier;
        if (this.engine != null) {
            switch (this.engine) {
                case FUEL_ENGINE: {
                    break;
                }
                case ION_ENGINE: {
                    this.coef += 4;
                    break;
                }
                case PLASMA_ENGINE: {
                    this.coef += 8;
                    break;
                }
                case SUBLIGHT_ENGINE: {
                    this.coef += 100;
                    break;
                }
                case BLACKHOLE_ENGINE: {
                    this.coef += 1000;
                    break;
                }
            }
        }
        Random rand = new Random();
        this.nebula_img = rand.nextInt(2);
        this.nebula_color = new Vec3d((double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
    }

    public void func_73866_w_() {
        GuiCelestialSelection.BORDER_SIZE = this.field_146294_l / 65;
        GuiCelestialSelection.BORDER_EDGE_SIZE = GuiCelestialSelection.BORDER_SIZE / 4;
        this.refreshBodies();
    }

    public void func_73876_c() {
        ++this.ticksSinceMenuOpen;
        ++this.ticksTotal;
        if (this.ticksSinceMenuOpen < 20) {
            Mouse.setGrabbed((boolean)false);
        }
        if (this.selectedBody != null) {
            ++this.ticksSinceSelection;
        }
        if (this.selectedBody == null && this.ticksSinceUnselection >= 0) {
            ++this.ticksSinceUnselection;
        }
        if (!(this.renamingSpaceStation || this.selectedBody != null && this.isZoomed())) {
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.leftKey)) {
                this.translation.x += -2.0f;
                this.translation.y += -2.0f;
                if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                    this.xImgOffset += -1.0;
                }
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.rightKey)) {
                this.translation.x += 2.0f;
                this.translation.y += 2.0f;
                if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                    this.xImgOffset += 1.0;
                }
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.upKey)) {
                this.translation.x += 2.0f;
                this.translation.y += -2.0f;
                if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                    this.yImgOffset += -1.0;
                }
            }
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.downKey)) {
                this.translation.x += -2.0f;
                this.translation.y += 2.0f;
                if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                    this.yImgOffset += 1.0;
                }
            }
        }
        if (this.xImgOffset > 20.0) {
            this.xImgOffset = 20.0;
        }
        if (this.xImgOffset < -150.0) {
            this.xImgOffset = -150.0;
        }
        if (this.yImgOffset > 20.0) {
            this.yImgOffset = 20.0;
        }
        if (this.yImgOffset < -80.0) {
            this.yImgOffset = -80.0;
        }
    }

    private void refreshBodies() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.bodiesToRender.clear();
        this.galaxylist.clear();
        this.starlist.clear();
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            if (!this.galaxylist.contains(solarSystem.getUnlocalizedParentGalaxyName())) {
                this.galaxylist.add(solarSystem.getUnlocalizedParentGalaxyName());
            }
            if (!solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                if (!UtilsGC.hasUnlocks(player, solarSystem)) continue;
                if (solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) {
                    this.starlist.add(solarSystem);
                }
                this.bodiesToRender.add(solarSystem.getMainStar());
                continue;
            }
            if (solarSystem.getUnlocalizedParentGalaxyName().equals(this.galaxy)) {
                this.starlist.add(solarSystem);
            }
            this.bodiesToRender.add(solarSystem.getMainStar());
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (!planet.getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                if (!UtilsGC.isReasearched(player, (CelestialBody)planet)) continue;
                this.bodiesToRender.add(planet);
                continue;
            }
            this.bodiesToRender.add(planet);
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (!moon.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                if (!UtilsGC.isReasearched(player, (CelestialBody)moon.getParentPlanet()) || !UtilsGC.isReasearched(player, (CelestialBody)moon)) continue;
                this.bodiesToRender.add(moon);
                continue;
            }
            this.bodiesToRender.add(moon);
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (!satellite.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy)) continue;
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                if (!UtilsGC.isReasearched(player, (CelestialBody)satellite.getParentPlanet())) continue;
                this.bodiesToRender.add(satellite);
                continue;
            }
            this.bodiesToRender.add(satellite);
        }
        for (Map map : BodiesRegistry.getBodies()) {
            for (CelestialBody body : map.values()) {
                if (!(body instanceof ICelestialRegistry)) continue;
                if (body instanceof IChildBody) {
                    if (!((IChildBody)body).getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy) || !((ICelestialRegistry)body).canRegistry()) continue;
                    this.bodiesToRender.add(body);
                    continue;
                }
                if (!((ICelestialRegistry)body).getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(this.galaxy) || !((ICelestialRegistry)body).canRegistry()) continue;
                this.bodiesToRender.add(body);
            }
        }
        Collections.sort(this.starlist, new Comparator<SolarSystem>(){

            @Override
            public int compare(SolarSystem lhs, SolarSystem rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public void drawButtons(int mousePosX, int mousePosY) {
        block218: {
            block219: {
                block220: {
                    travel_modifier = 200;
                    if (this.coef < 1) {
                        this.coef = 1;
                    }
                    if (!this.mapMode && this.ticksSinceSelection % 1 == 0 && !this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && this.timer < this.traveltime && this.enableTraveltime) {
                        this.timer += (double)(1 * this.coef);
                    }
                    if (this.selectedBody != null) {
                        dist = 0.0;
                        idcel = 0.0f;
                        star = GalacticraftCore.solarSystemSol;
                        this.canTravel = true;
                        if (this.selectedBody instanceof Planet) {
                            if (!(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSurface) && this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
                                body = ((IGalacticraftWorldProvider)this.field_146297_k.field_71439_g.field_70170_p.field_73011_w).getCelestialBody();
                                if (body instanceof Planet) {
                                    star = ((Planet)body).getParentSolarSystem();
                                    idcel = body.getRelativeDistanceFromCenter().unScaledDistance;
                                    dist = Math.abs(Math.floor((idcel - this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0f)) / 100.0;
                                }
                                if (body instanceof IChildBody) {
                                    star = ((IChildBody)body).getParentPlanet().getParentSolarSystem();
                                    idcel = ((IChildBody)body).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
                                    dist = Math.abs(Math.floor((idcel - this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0f)) / 100.0 + (double)(body.getRelativeDistanceFromCenter().unScaledDistance / 100.0f);
                                }
                                if (this.selectedBody == body) {
                                    dist = 0.0;
                                }
                            } else {
                                idcel = GalacticraftCore.planetOverworld.getRelativeDistanceFromCenter().unScaledDistance;
                                star = GalacticraftCore.solarSystemSol;
                                dist = Math.abs(Math.floor((idcel - this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0f)) / 100.0;
                            }
                            test = ((Planet)this.selectedBody).getParentSolarSystem();
                            distothersystem = Math.floor(Vector3.distance((Vector3)star.getMapPosition(), (Vector3)test.getMapPosition()) / 100.0) * 100.0 - Math.abs(Math.floor((idcel + this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance) * 100.0f));
                            v0 = time = star == test ? (double)Math.round(dist * 70.0) : distothersystem;
                            if (!test.equals(star)) {
                                time *= 10.0;
                                if (this.engine.getID() < SpaceData.Engine_Type.SUBLIGHT_ENGINE.getID() && ACCompatibilityManager.isGalaxySpaceLoaded()) {
                                    this.canTravel = false;
                                }
                            }
                            if (!star.getUnlocalizedParentGalaxyName().equals(test.getUnlocalizedParentGalaxyName())) {
                                time *= 10.0;
                                if (this.engine.getID() < SpaceData.Engine_Type.SUBLIGHT_ENGINE.getID() && ACCompatibilityManager.isGalaxySpaceLoaded()) {
                                    this.canTravel = false;
                                }
                            }
                            this.traveltime = (time <= 0.0 ? 10 : (int)time) * travel_modifier;
                            for (i = 0; i <= BodiesRegistry.getMaxTier(); ++i) {
                                if (!(dist >= 0.2 * (double)i) || !star.getUnlocalizedParentGalaxyName().equals(test.getUnlocalizedParentGalaxyName()) || !this.selectedBody.getReachable()) continue;
                                this.tierneed = star == test ? (i == BodiesRegistry.getMaxTier() ? i : i + 1) : BodiesRegistry.getMaxTier();
                            }
                            this.fuelSet = fuelcount = (int)Math.round((double)this.fuelRocketLevel - (double)this.fuelRocketLevel * (dist / (double)this.currenttier));
                        }
                        if (this.selectedBody instanceof IChildBody) {
                            if (!(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSurface) && this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
                                body = ((IGalacticraftWorldProvider)this.field_146297_k.field_71439_g.field_70170_p.field_73011_w).getCelestialBody();
                                idcel = 0.0f;
                                if (body instanceof Planet) {
                                    star = ((Planet)body).getParentSolarSystem();
                                    idcel = body.getRelativeDistanceFromCenter().unScaledDistance;
                                    dist = Math.abs(Math.floor((idcel - ((IChildBody)this.selectedBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance) * 100.0f)) / 100.0 + (double)(this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance / 100.0f);
                                } else if (body instanceof IChildBody) {
                                    star = ((IChildBody)body).getParentPlanet().getParentSolarSystem();
                                    idcel = ((IChildBody)body).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance;
                                    dist = Math.abs(Math.floor((idcel - ((IChildBody)this.selectedBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance) * 100.0f)) / 100.0 + (double)(this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance / 100.0f);
                                }
                                if (this.selectedBody == body) {
                                    dist = 0.0;
                                }
                            } else {
                                idcel = GalacticraftCore.planetOverworld.getRelativeDistanceFromCenter().unScaledDistance;
                                star = GalacticraftCore.solarSystemSol;
                                dist = Math.abs(Math.floor((idcel - ((IChildBody)this.selectedBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance) * 100.0f)) / 100.0 + (double)(this.selectedBody.getRelativeDistanceFromCenter().unScaledDistance / 100.0f);
                            }
                            test = ((IChildBody)this.selectedBody).getParentPlanet().getParentSolarSystem();
                            v1 = time = star == test ? (double)Math.round(dist * 70.0) : Math.floor(Vector3.distance((Vector3)star.getMapPosition(), (Vector3)test.getMapPosition()) / 200.0) * Math.floor((((IChildBody)this.selectedBody).getParentPlanet().getRelativeDistanceFromCenter().unScaledDistance + idcel) * 100.0f);
                            if (!test.equals(star)) {
                                time *= 10.0;
                                if (this.engine.getID() < SpaceData.Engine_Type.SUBLIGHT_ENGINE.getID() && ACCompatibilityManager.isGalaxySpaceLoaded()) {
                                    this.canTravel = false;
                                }
                            }
                            if (!star.getUnlocalizedParentGalaxyName().equals(test.getUnlocalizedParentGalaxyName())) {
                                time *= 1000.0;
                                if (this.engine.getID() < SpaceData.Engine_Type.SUBLIGHT_ENGINE.getID() && ACCompatibilityManager.isGalaxySpaceLoaded()) {
                                    this.canTravel = false;
                                }
                            }
                            this.traveltime = (time <= 0.0 ? 10 : (int)time) * travel_modifier;
                            for (i = 0; i <= BodiesRegistry.getMaxTier(); ++i) {
                                if (!(dist >= 0.25 * (double)i) || !star.getUnlocalizedParentGalaxyName().equals(test.getUnlocalizedParentGalaxyName()) || !this.selectedBody.getReachable()) continue;
                                this.tierneed = star == test ? (i == BodiesRegistry.getMaxTier() ? i : i + 1) : BodiesRegistry.getMaxTier();
                            }
                            this.fuelSet = fuelcount = (int)Math.round((double)this.fuelRocketLevel - (double)this.fuelRocketLevel * (dist / (double)this.currenttier));
                        }
                        if (this.fuelSet < 0) {
                            this.canTravel = false;
                        }
                        if (this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                            this.canTravel = true;
                        }
                    }
                    this.field_73735_i = 0.0f;
                    handledSliderPos = false;
                    LHS = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
                    RHS = this.field_146294_l - LHS;
                    TOP = LHS;
                    BOT = this.field_146295_m - LHS;
                    if (this.viewState != EnumView.GS) break block218;
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.drawTexturedModalRect(LHS, TOP, 74, 11, 0, 392, 148, 22, false, false);
                    str = GCCoreUtil.translate((String)"gui.message.catalog.name").toUpperCase();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146289_q.func_78276_b(str, LHS + 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, NewGuiCelestialSelection.WHITE);
                    scale = (int)Math.min(95.0f, this.ticksSinceMenuOpenF * 12.0f);
                    planetZoomedNotMoon = this.isZoomed() != false && this.selectedParent instanceof Planet == false;
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(LHS - 95 + scale, TOP + 12, 95, 41, 0, 436, 95, 41, false, false);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    if (GalaxyRegistry.getRegisteredSolarSystems().size() > 1) {
                        this.drawTexturedModalRect(LHS + 2 - 13 + scale, TOP + 37, 5, 5, 110, 448, 5, 5, false, true);
                    }
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    str = planetZoomedNotMoon != false ? this.selectedBody.getLocalizedName() : this.getParentName();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146289_q.func_78276_b(str, LHS + 9 - 95 + scale, TOP + 34, NewGuiCelestialSelection.YELLOW);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(LHS + 2 - 95 + scale, TOP + 14, 93, 17, 95, 436, 93, 17, false, false);
                    if (this.galaxylist.size() > 1) {
                        this.drawTexturedModalRect(LHS + 2 - 13 + scale, TOP + 19, 5, 5, 110, 448, 5, 5, false, true);
                    }
                    str = planetZoomedNotMoon != false ? this.getParentName() : this.getGrandparentName();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146289_q.func_78276_b(str, LHS + 7 - 95 + scale, TOP + 16, NewGuiCelestialSelection.LIGHTBLUE);
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    if (this.showGalaxyList) {
                        y = 19;
                        for (i = 0; i < this.galaxylist.size(); ++i) {
                            galaxy = BodiesRegistry.getGalaxy(this.galaxylist.get(i).replace("galaxy.", "")) == null || BodiesRegistry.getGalaxy(this.galaxylist.get(i).replace("galaxy.", "")).getImage() == null ? new ResourceLocation("asmodeuscore:textures/gui/galaxy/" + this.galaxylist.get(i).toLowerCase() + ".png") : BodiesRegistry.getGalaxy(this.galaxylist.get(i).replace("galaxy.", "")).getImage();
                            if (galaxy != null) {
                                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                this.field_146297_k.field_71446_o.func_110577_a(galaxy);
                                this.drawTexturedModalRect(LHS + 18 + scale + 70 * i, TOP + 4, 37.0f, 40.0f, 0.0f, 0.0f, 100.0f, 100.0f, false, false, 100.0f, 100.0f);
                            }
                            this.field_146297_k.field_71446_o.func_110577_a(NewGuiCelestialSelection.guiMain2);
                            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                            this.drawTexturedModalRect(LHS + 15 + scale + 70 * i, TOP + 4, 43, 40, 270, 80, 85, 75, false, false);
                            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)((float)scale / 95.0f));
                            this.drawTexturedModalRect(LHS + 5 + scale + 70 * i, TOP + 14 + 35, 43, 12, 95, 464, 43, 12, false, false);
                            this.drawTexturedModalRect(LHS + 5 + scale + 43 + 70 * i, TOP + 14 + 35, 23, 12, 165, 464, 23, 12, false, false);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            str = GCCoreUtil.translate((String)this.galaxylist.get(i));
                            this.field_146289_q.func_78276_b(str, LHS + 10 + scale + 70 * i, TOP + 14 + 37, NewGuiCelestialSelection.YELLOW);
                        }
                    }
                    if (this.showStarList) {
                        l = 0;
                        posX = 0;
                        for (SolarSystem s : this.starlist) {
                            y = 33;
                            this.field_146297_k.field_71446_o.func_110577_a(NewGuiCelestialSelection.guiMain2);
                            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)((float)scale / 95.0f));
                            this.drawTexturedModalRect(LHS + posX * 150 + 3 + scale, TOP + 30 * l + 8, 140, 30, 275, 160, 140, 30, false, false);
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            star = s.getMainStar().getBodyIcon();
                            this.field_146297_k.field_71446_o.func_110577_a(star);
                            this.drawTexturedModalRect(LHS + posX * 150 + 14 + scale, TOP + 30 * l + 15, 16.0f, 16.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                            str = s.getLocalizedName();
                            this.field_146289_q.func_78276_b(str, LHS + posX * 150 + 43 + scale, TOP + 30 * l + 19, NewGuiCelestialSelection.YELLOW);
                            if (++l % 7 != 0) continue;
                            ++posX;
                            l = 0;
                        }
                    }
                    children = this.getChildren(planetZoomedNotMoon != false ? this.selectedBody : this.selectedParent, this.scroll, this.max_scroll);
                    this.drawChildren(children, 0, 0, true);
                    if (this.mapMode) {
                        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                        this.drawTexturedModalRect(RHS - 74, TOP, 74, 11, 0, 392, 148, 22, true, false);
                        str = GCCoreUtil.translate((String)"gui.message.exit.name").toUpperCase();
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.field_146289_q.func_78276_b(str, RHS - 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, NewGuiCelestialSelection.WHITE);
                    }
                    menuTopLeft1 = BOT - 22;
                    posX1 = LHS - 53;
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(posX1 + 53, menuTopLeft1 - 5, 40, 12, 0, 456, 40, 12, false, false);
                    this.drawTexturedModalRect(posX1 + 93, menuTopLeft1 - 5, 45, 12, 50, 456, 45, 12, false, false);
                    str = this.hideInfo != false ? "Enable Info" : "Disable Info";
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    this.field_146289_q.func_78276_b(str, LHS + 15, menuTopLeft1 - 3, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(posX1 + 53, menuTopLeft1 - 19, 40, 12, 0, 456, 40, 12, false, false);
                    this.drawTexturedModalRect(posX1 + 93, menuTopLeft1 - 19, 45, 12, 50, 456, 45, 12, false, false);
                    str = this.small_mode != false ? "Small Mode" : "Normal Mode";
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    this.field_146289_q.func_78276_b(str, LHS + 15, menuTopLeft1 - 17, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
                    if (this.selectedBody == null) break block219;
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    if (this.selectedBody instanceof Satellite) {
                        selectedSatellite = (Satellite)this.selectedBody;
                        stationListSize = ((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).size();
                        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                        max = Math.min(this.field_146295_m / 2 / 14, stationListSize);
                        this.drawTexturedModalRect(RHS - 95, TOP, 95, 53, this.selectedStationOwner.length() == 0 ? 95 : 0, 186, 95, 53, false, false);
                        if (this.spaceStationListOffset <= 0) {
                            GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                        }
                        this.drawTexturedModalRect(RHS - 85, TOP + 45, 61, 4, 0, 239, 61, 4, false, false);
                        if (max + this.spaceStationListOffset >= stationListSize) {
                            GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                        }
                        this.drawTexturedModalRect(RHS - 85, TOP + 49 + max * 14, 61, 4, 0, 239, 61, 4, false, true);
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                        if (((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(this.selectedStationOwner) == null) {
                            str = GCCoreUtil.translate((String)"gui.message.select_ss.name");
                            this.drawSplitString(str, RHS - 47, TOP + 20, 91, NewGuiCelestialSelection.WHITE, false, false);
                        } else {
                            str = GCCoreUtil.translate((String)"gui.message.ss_owner.name");
                            this.field_146289_q.func_78276_b(str, RHS - 85, TOP + 18, NewGuiCelestialSelection.WHITE);
                            str = this.selectedStationOwner;
                            this.field_146289_q.func_78276_b(str, RHS - 47 - this.field_146289_q.func_78256_a(str) / 2, TOP + 30, NewGuiCelestialSelection.WHITE);
                        }
                        it = ((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).entrySet().iterator();
                        i = 0;
                        j = 0;
                        while (it.hasNext() && i < max) {
                            e = it.next();
                            if (j >= this.spaceStationListOffset) {
                                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                                xOffset = 0;
                                if (((String)e.getKey()).equalsIgnoreCase(this.selectedStationOwner)) {
                                    xOffset -= 5;
                                }
                                this.drawTexturedModalRect(RHS - 95 + xOffset, TOP + 50 + i * 14, 93, 12, 95, 464, 93, 12, true, false);
                                str = "";
                                str0 = ((GuiCelestialSelection.StationDataGUI)e.getValue()).getStationName();
                                for (point = 0; this.field_146289_q.func_78256_a(str) < 80 && point < str0.length(); ++point) {
                                    str = str + str0.substring(point, point + 1);
                                }
                                if (this.field_146289_q.func_78256_a(str) >= 80) {
                                    str = str.substring(0, str.length() - 3);
                                    str = str + "...";
                                }
                                this.field_146289_q.func_78276_b(str, RHS - 88 + xOffset, TOP + 52 + i * 14, NewGuiCelestialSelection.WHITE);
                                ++i;
                            }
                            ++j;
                        }
                    } else if (!this.hideInfo) {
                        this.field_146297_k.field_71446_o.func_110577_a(NewGuiCelestialSelection.guiMain2);
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                        y = 100;
                        sliderPos = this.zoomTooltipPos;
                        if (this.zoomTooltipPos != 125) {
                            this.zoomTooltipPos = sliderPos = (int)Math.min(this.ticksSinceSelectionF * 8.0f, 125.0f);
                        }
                        menuTopLeft = LHS + y;
                        posX = RHS - sliderPos;
                        posX2 = RHS - 18;
                        if (!this.selectedBody.getReachable()) {
                            this.drawTexturedModalRect(posX - 7, menuTopLeft + 12, 133, 31, 0, 79, 266, 62, true, false);
                            this.drawTexturedModalRect(posX - 7, menuTopLeft + 43, 133, 37, 0, 442, 266, 70, true, false);
                        } else if (!this.small_mode) {
                            this.drawTexturedModalRect(posX - 7, menuTopLeft + 13, 133, 237, 0, 79, 266, 433, true, false);
                        } else {
                            this.drawTexturedModalRect(posX - 7, menuTopLeft + 13, 133, 80, 0, 79, 266, 142, true, false);
                            this.drawTexturedModalRect(posX - 7, menuTopLeft + 93, 133, 17, 0, 472, 266, 40, true, false);
                            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                            this.drawTexturedModalRect(posX + 5, menuTopLeft + 112, 30, 11, 0, 414, 60, 22, false, false);
                            this.drawTexturedModalRect(posX + 35, menuTopLeft + 112, 50, 11, 128, 414, 40, 22, false, false);
                            this.drawTexturedModalRect(posX + 85, menuTopLeft + 112, 30, 11, 128, 414, 60, 22, false, false);
                            this.field_146289_q.func_78276_b("<-", posX + 13, menuTopLeft + 114, NewGuiCelestialSelection.CYAN);
                            this.field_146289_q.func_78276_b("Page: " + (this.small_page + 1), posX + 45, menuTopLeft + 114, NewGuiCelestialSelection.CYAN);
                            this.field_146289_q.func_78276_b("->", posX + 100, menuTopLeft + 114, NewGuiCelestialSelection.CYAN);
                            this.field_146297_k.field_71446_o.func_110577_a(NewGuiCelestialSelection.guiMain2);
                        }
                        y += 15;
                        str = GCCoreUtil.translate((String)"gui.message.generalinformation");
                        if (!this.small_mode) {
                            this.field_146289_q.func_78276_b(str, posX, TOP + y, NewGuiCelestialSelection.CYAN);
                        } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
                            this.field_146289_q.func_78276_b(str, posX, TOP + y, NewGuiCelestialSelection.CYAN);
                        }
                        if (this.selectedBody.getReachable()) {
                            str = GCCoreUtil.translate((String)"gui.message.physicalparameters");
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 40, NewGuiCelestialSelection.CYAN);
                            } else if (this.small_page == 0) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 40, NewGuiCelestialSelection.CYAN);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.atmosphericparameters");
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 82, NewGuiCelestialSelection.CYAN);
                            } else if (this.small_page == 1) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y, NewGuiCelestialSelection.CYAN);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.atmosphericcomponents");
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 166, NewGuiCelestialSelection.CYAN);
                            } else if (this.small_page == 2) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y, NewGuiCelestialSelection.CYAN);
                            }
                        }
                        data = BodiesRegistry.getData(this.selectedBody);
                        if (this.selectedBody instanceof Star) {
                            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.info.star.name");
                        }
                        if (this.selectedBody instanceof Planet) {
                            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.info.planet.name");
                        }
                        if (this.selectedBody instanceof Moon) {
                            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.info.moon.name");
                        }
                        if (this.selectedBody instanceof Satellite) {
                            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.info.satellite.name");
                        }
                        if (this.selectedBody.getTierRequirement() == -2) {
                            str = GCCoreUtil.translate((String)"gui.message.type") + " " + GCCoreUtil.translate((String)"gui.info.blackhole.name");
                        }
                        if (data != null && data.getType() != null) {
                            str = GCCoreUtil.translate((String)"gui.message.type") + " " + BodiesRegistry.getLocale((Object)data.getType());
                        }
                        if (!this.small_mode) {
                            this.field_146289_q.func_78276_b(str, posX, TOP + y + 10, NewGuiCelestialSelection.WHITE);
                        } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
                            this.field_146289_q.func_78276_b(str, posX, TOP + y + 10, NewGuiCelestialSelection.WHITE);
                        }
                        if (this.selectedBody instanceof Planet) {
                            this.galaxy = ((Planet)this.selectedBody).getParentSolarSystem().getUnlocalizedParentGalaxyName();
                        } else if (this.selectedBody instanceof IChildBody) {
                            this.galaxy = ((IChildBody)this.selectedBody).getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName();
                        }
                        dim = WorldUtil.getProviderForDimensionClient((int)this.selectedBody.getDimensionID());
                        str = GCCoreUtil.translate((String)"gui.message.class") + " " + BodiesRegistry.classPlanet(this.selectedBody, dim);
                        if (!this.small_mode) {
                            this.field_146289_q.func_78276_b(str, posX, TOP + y + 20, NewGuiCelestialSelection.WHITE);
                        } else if (this.small_page == 0 || this.selectedBody instanceof Star) {
                            this.field_146289_q.func_78276_b(str, posX, TOP + y + 20, NewGuiCelestialSelection.WHITE);
                        }
                        if (this.selectedBody.getReachable()) {
                            str = GCCoreUtil.translate((String)"gui.message.hasdungeons") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.hasdungeons") + " " + Utils.localeBoolean(((IGalacticraftWorldProvider)dim).getDungeonSpacing() > 0);
                            }
                            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.hasdungeons") + " " + Utils.localeBoolean(true);
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 29, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 0) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 29, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.gravity") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                                grav = (0.1f - ((IGalacticraftWorldProvider)dim).getGravity()) * 1000.0f;
                                if (((IGalacticraftWorldProvider)dim).getGravity() == 0.0f) {
                                    grav = 0.0f;
                                }
                                str = GCCoreUtil.translate((String)"gui.message.gravity") + " " + (int)grav + "%";
                            } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.gravity") + " 100%";
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 38 + 12, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 0) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 38 + 12, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.daylength") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                                if (dim instanceof WorldProviderSpace) {
                                    str = GCCoreUtil.translate((String)"gui.message.daylength") + " " + ((WorldProviderSpace)dim).getDayLength() / 1000L + "h " + ((WorldProviderSpace)dim).getDayLength() % 100L + "m";
                                } else if (dim instanceof WE_WorldProviderSpace) {
                                    str = GCCoreUtil.translate((String)"gui.message.daylength") + " " + ((WE_WorldProviderSpace)dim).getDayLength() / 1000L + "h " + ((WE_WorldProviderSpace)dim).getDayLength() % 100L + "m";
                                } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                    str = GCCoreUtil.translate((String)"gui.message.daylength") + " 24h 0m";
                                }
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 38 + 22, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 0) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 38 + 22, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.atmopressure") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (this.selectedBody instanceof IExBody) {
                                str = GCCoreUtil.translate((String)"gui.message.atmopressure") + " " + ((IExBody)this.selectedBody).getAtmosphericPressure() + " P";
                            } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.atmopressure") + " P 1";
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 78 + 14, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 1) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 10, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.temperature") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            temp = 0.0f;
                            try {
                                temp = ((IGalacticraftWorldProvider)dim).getCelestialBody().atmosphere.thermalLevel();
                            }
                            catch (Exception str0) {
                                // empty catch block
                            }
                            v2 = temp = temp == 0.0f ? (float)BodiesRegistry.getDefaultDergrees : temp * (float)BodiesRegistry.getDefaultDergrees;
                            if (this.selectedBody.getReachable()) {
                                str = GCCoreUtil.translate((String)"gui.message.temperature") + " " + temp + " C";
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 78 + 24, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 1) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 20, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.windenergy") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld && dim instanceof IAdvancedSpace) {
                                str = GCCoreUtil.translate((String)"gui.message.windenergy") + " " + (float)Math.round(((IAdvancedSpace)dim).getSolarWindMultiplier() * 1000.0) / 1000.0f;
                            } else if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.windenergy") + " " + 1.0;
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 76 + 36, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 1) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 30, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.solarenergy") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (dim instanceof ISolarLevel) {
                                boost = (float)Math.round((((ISolarLevel)dim).getSolarEnergyMultiplier() - 1.0) * 1000.0) / 10.0f;
                                str = GCCoreUtil.translate((String)"gui.message.solarenergy") + " " + boost + "%";
                            }
                            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.solarenergy") + " 100%";
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 76 + 48, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 1) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 40, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.windspeed") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (dim instanceof IGalacticraftWorldProvider) {
                                str = GCCoreUtil.translate((String)"gui.message.windspeed") + " " + ((IGalacticraftWorldProvider)dim).getWindLevel() + " W/l";
                            }
                            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.windspeed") + " 1.0 W/l";
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 74 + 60, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 1) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 50, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.solarradiation") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (this.selectedBody instanceof IExBody) {
                                str = GCCoreUtil.translate((String)"gui.message.solarradiation") + " " + ((IExBody)this.selectedBody).isSolarRadiation();
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 78 + 66, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 1) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 60, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.breathableatmo") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.breathableatmo") + " " + Utils.localeBoolean(this.selectedBody.atmosphere.isBreathable());
                            }
                            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.breathableatmo") + " " + Utils.localeBoolean(true);
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 77 + 99, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 2) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 10, NewGuiCelestialSelection.WHITE);
                            }
                            str = GCCoreUtil.translate((String)"gui.message.corrosiveatmo") + " " + GCCoreUtil.translate((String)"gui.message.unknown");
                            if (this.selectedBody.getReachable() && this.selectedBody != GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.corrosiveatmo") + " " + Utils.localeBoolean(this.selectedBody.atmosphere.isCorrosive());
                            }
                            if (this.selectedBody == GalacticraftCore.planetOverworld) {
                                str = GCCoreUtil.translate((String)"gui.message.corrosiveatmo") + " " + Utils.localeBoolean(false);
                            }
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 76 + 110, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 2) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 20, NewGuiCelestialSelection.WHITE);
                            }
                            str = this.selectedBody.getReachable() != false && this.selectedBody.atmosphere.hasNoGases() == false ? this.selectedBody.atmosphere.composition.toString() : GCCoreUtil.translate((String)"gui.message.noatmosphere");
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 75 + 121, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 2) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 30, NewGuiCelestialSelection.WHITE);
                            }
                        }
                        travel = (int)(this.traveltime / 100.0) + "h " + (int)(this.traveltime % 100.0) + "m";
                        str = GCCoreUtil.translate((String)"gui.message.traveltime") + " " + travel;
                        if (this.selectedBody.getReachable()) {
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 74 + 143, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                            } else if (this.small_page == 2) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 80, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                            }
                        }
                        if (this.selectedBody instanceof Star) {
                            x = 0;
                            for (CelestialBody body : this.getChildren(this.selectedParent)) {
                                if (body.getTierRequirement() < 0) continue;
                                ++x;
                            }
                            str = GCCoreUtil.translate((String)"gui.message.planets") + " " + x;
                            this.field_146289_q.func_78276_b(str, posX, TOP + y + 29 + 11, NewGuiCelestialSelection.WHITE);
                        } else if (this.selectedBody instanceof Planet && data != null && data.getType() != IAdvancedSpace.TypeBody.STAR) {
                            str = GCCoreUtil.translate((String)"gui.message.moons") + " " + this.getChildren(this.selectedBody).size();
                            if (!this.selectedBody.getReachable()) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 29 + 11, NewGuiCelestialSelection.WHITE);
                            } else if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 76 + 132, NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 2) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 70, NewGuiCelestialSelection.WHITE);
                            }
                        }
                        str = GCCoreUtil.translate((String)"gui.message.fuelset") + " " + this.fuelSet;
                        if (this.selectedBody.getTierRequirement() != -1 && this.selectedBody.getReachable() && !this.mapMode) {
                            if (!this.small_mode) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 83 + 143, this.fuelSet < 0 ? NewGuiCelestialSelection.RED : NewGuiCelestialSelection.WHITE);
                            } else if (this.small_page == 2) {
                                this.field_146289_q.func_78276_b(str, posX, TOP + y + 40, this.fuelSet < 0 ? NewGuiCelestialSelection.RED : NewGuiCelestialSelection.WHITE);
                            }
                        }
                        if (this.zoomTooltipPos != 38) {
                            this.zoomTooltipPos = sliderPos = (int)Math.min(this.ticksSinceSelectionF * 2.0f, 38.0f);
                        }
                        if (!(this.selectedBody instanceof Star) && this.traveltime * (double)travel_modifier > this.mindistance * (double)travel_modifier * 70.0 && ACCompatibilityManager.isGalaxySpaceLoaded()) {
                            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                            this.drawTexturedModalRect(RHS - 230, GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + sliderPos - 39, 120, 38, 346, 436, 166, 76, false, true);
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            str = GCCoreUtil.translate((String)"gui.message.engine");
                            this.field_146289_q.func_78276_b(str, RHS - 200, GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + sliderPos - 35, NewGuiCelestialSelection.GREY4);
                            str = GCCoreUtil.translate((String)("gui.engine_type." + SpaceData.Engine_Type.SUBLIGHT_ENGINE.getName().toLowerCase()));
                            color = this.engine.getID() >= SpaceData.Engine_Type.SUBLIGHT_ENGINE.getID() || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d != false ? NewGuiCelestialSelection.GREEN : NewGuiCelestialSelection.RED;
                            this.field_146289_q.func_78276_b(str, RHS - 206, GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + sliderPos - 20, color);
                        }
                    }
                    data = BodiesRegistry.getData(this.selectedBody);
                    if (this.enableTraveltime) {
                        this.drawTransitBar(this.getScaledTravelTime(138));
                    }
                    if (this.canCreateSpaceStation(this.selectedBody) && !(this.selectedBody instanceof Satellite)) {
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                        canCreateLength = Math.max(0, this.drawSplitString(GCCoreUtil.translate((String)"gui.message.can_create_space_station.name"), 0, 0, 91, 0, true, true) - 2);
                        this.canCreateOffset = canCreateLength * this.field_146289_q.field_78288_b;
                        this.drawTexturedModalRect(RHS - 95, TOP + 16, 93, 4, 159, 102, 93, 4, false, false);
                        for (barY = 0; barY < canCreateLength; ++barY) {
                            this.drawTexturedModalRect(RHS - 95, TOP + 20 + barY * this.field_146289_q.field_78288_b, 93, this.field_146289_q.field_78288_b, 159, 106, 93, this.field_146289_q.field_78288_b, false, false);
                        }
                        this.drawTexturedModalRect(RHS - 69, TOP + 12, 61, 4, 0, 170, 61, 4, false, false);
                        recipe = WorldUtil.getSpaceStationRecipe((int)this.selectedBody.getDimensionID());
                        h = 1;
                        if (recipe != null) {
                            h = Math.round((float)Math.ceil((float)recipe.getRecipeSize() / 4.0f) - 1.0f) * 25;
                        }
                        this.drawTexturedModalRect(RHS - 95, TOP + 20 + this.canCreateOffset, 93, 43 + h, 159, 106, 93, 43, false, false);
                        if (recipe != null) {
                            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
                            validInputMaterials = true;
                            i = 0;
                            yOff = false;
                            for (Map.Entry<K, V> e : recipe.getInput().entrySet()) {
                                next = e.getKey();
                                xPos = RHS - 95 + i % 4 * 93 / 4 + 5;
                                yPos = TOP + 35 + this.canCreateOffset + 24 * (i >= 8 ? 2 : (i >= 4 ? 1 : 0));
                                if (next instanceof ItemStack) {
                                    amount = this.getAmountInInventory((ItemStack)next);
                                    RenderHelper.func_74520_c();
                                    toRender = ((ItemStack)next).func_77946_l();
                                    this.field_146296_j.func_180450_b(toRender, xPos, yPos);
                                    this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, toRender, xPos, yPos, null);
                                    RenderHelper.func_74518_a();
                                    GL11.glEnable((int)3042);
                                    if (mousePosX >= xPos && mousePosX <= xPos + 16 && mousePosY >= yPos && mousePosY <= yPos + 16) {
                                        GL11.glDepthMask((boolean)true);
                                        GL11.glEnable((int)2929);
                                        GL11.glPushMatrix();
                                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                                        k = this.field_146289_q.func_78256_a(((ItemStack)next).func_82833_r());
                                        j2 = mousePosX - k / 2;
                                        k2 = mousePosY - 12;
                                        i1 = 8;
                                        if (j2 + k > this.field_146294_l) {
                                            j2 -= j2 - this.field_146294_l + k;
                                        }
                                        if (k2 + i1 + 6 > this.field_146295_m) {
                                            k2 = this.field_146295_m - i1 - 6;
                                        }
                                        j1 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                                        this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
                                        this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
                                        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
                                        this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
                                        this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
                                        k1 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                                        l1 = (k1 & 0xFEFEFE) >> 1 | k1 & -16777216;
                                        this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
                                        this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
                                        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
                                        this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
                                        this.field_146289_q.func_78276_b(((ItemStack)next).func_82833_r(), j2, k2, NewGuiCelestialSelection.WHITE);
                                        GL11.glPopMatrix();
                                    }
                                    str = "" + e.getValue();
                                    v3 = valid = amount >= (Integer)e.getValue();
                                    if (!valid && validInputMaterials) {
                                        validInputMaterials = false;
                                    }
                                    color = (valid | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) != false ? NewGuiCelestialSelection.GREEN : NewGuiCelestialSelection.RED;
                                    this.field_146289_q.func_78276_b(str, xPos + 8 - this.field_146289_q.func_78256_a(str) / 2, yPos + 15, color);
                                } else if (next instanceof Collection) {
                                    items = (Collection)next;
                                    amount = 0;
                                    for (ItemStack stack : items) {
                                        amount += this.getAmountInInventory(stack);
                                    }
                                    RenderHelper.func_74520_c();
                                    it = items.iterator();
                                    count = 0;
                                    toRenderIndex = (int)(this.ticksSinceSelectionF / 20.0f % (float)items.size());
                                    toRender = null;
                                    while (it.hasNext()) {
                                        stack = (ItemStack)it.next();
                                        if (count == toRenderIndex) {
                                            toRender = stack;
                                            break;
                                        }
                                        ++count;
                                    }
                                    if (toRender == null) continue;
                                    this.field_146296_j.func_180450_b(toRender, xPos, yPos);
                                    this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, toRender, xPos, yPos, null);
                                    RenderHelper.func_74518_a();
                                    GL11.glEnable((int)3042);
                                    if (mousePosX >= xPos && mousePosX <= xPos + 16 && mousePosY >= yPos && mousePosY <= yPos + 16) {
                                        GL11.glDepthMask((boolean)true);
                                        GL11.glEnable((int)2929);
                                        GL11.glPushMatrix();
                                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                                        k = this.field_146289_q.func_78256_a(toRender.func_82833_r());
                                        j2 = mousePosX - k / 2;
                                        k2 = mousePosY - 12;
                                        i1 = 8;
                                        if (j2 + k > this.field_146294_l) {
                                            j2 -= j2 - this.field_146294_l + k;
                                        }
                                        if (k2 + i1 + 6 > this.field_146295_m) {
                                            k2 = this.field_146295_m - i1 - 6;
                                        }
                                        j1 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                                        this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
                                        this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
                                        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
                                        this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
                                        this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
                                        k1 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                                        l1 = (k1 & 0xFEFEFE) >> 1 | k1 & -16777216;
                                        this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
                                        this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
                                        this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
                                        this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
                                        this.field_146289_q.func_78276_b(toRender.func_82833_r(), j2, k2, NewGuiCelestialSelection.WHITE);
                                        GL11.glPopMatrix();
                                    }
                                    str = "" + e.getValue();
                                    v4 = valid = amount >= (Integer)e.getValue();
                                    if (!valid && validInputMaterials) {
                                        validInputMaterials = false;
                                    }
                                    color = (valid | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) != false ? NewGuiCelestialSelection.GREEN : NewGuiCelestialSelection.RED;
                                    this.field_146289_q.func_78276_b(str, xPos + 8 - this.field_146289_q.func_78256_a(str) / 2, yPos + 15, color);
                                }
                                ++i;
                            }
                            if (validInputMaterials || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
                            } else {
                                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            }
                            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                            this.canCreateOffset = (int)((long)this.canCreateOffset + (Math.round(Math.ceil((float)recipe.getRecipeSize() / 4.0f) - 1.0) * 25L + 1L));
                            if (!this.mapMode && mousePosX >= RHS - 95 && mousePosX <= RHS && mousePosY >= TOP + 62 + this.canCreateOffset && mousePosY <= TOP + 62 + 12 + this.canCreateOffset) {
                                this.drawTexturedModalRect(RHS - 95, TOP + 62 + this.canCreateOffset, 93, 12, 0, 174, 93, 12, false, false);
                            }
                            this.drawTexturedModalRect(RHS - 95, TOP + 62 + this.canCreateOffset, 93, 12, 0, 174, 93, 12, false, false);
                            color = (int)((Math.sin((double)this.ticksSinceSelectionF / 5.0) * 0.5 + 0.5) * 255.0);
                            this.drawSplitString(GCCoreUtil.translate((String)"gui.message.can_create_space_station.name"), RHS - 48, TOP + 18, 91, ColorUtil.to32BitColor((int)255, (int)color, (int)255, (int)color), true, false);
                            if (!this.mapMode) {
                                this.drawSplitString(GCCoreUtil.translate((String)"gui.message.create_ss.name").toUpperCase(), RHS - 48, TOP + 65 + this.canCreateOffset, 91, NewGuiCelestialSelection.WHITE, false, false);
                            }
                        } else {
                            this.drawSplitString(GCCoreUtil.translate((String)"gui.message.cannot_create_space_station.name"), RHS - 48, TOP + 65, 91, NewGuiCelestialSelection.WHITE, true, false);
                        }
                    }
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f - Math.min(0.3f, this.ticksSinceSelectionF / 50.0f)));
                    this.drawTexturedModalRect(LHS, TOP, 74, 11, 0, 392, 148, 22, false, false);
                    str = GCCoreUtil.translate((String)"gui.message.catalog.name").toUpperCase();
                    this.field_146289_q.func_78276_b(str, LHS + 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, NewGuiCelestialSelection.WHITE);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    if (this.selectedBody instanceof Satellite) {
                        if (this.selectedStationOwner.length() == 0 || !this.selectedStationOwner.equalsIgnoreCase(PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g))) {
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        }
                        this.drawTexturedModalRect(this.field_146294_l / 2 - 47, TOP, 94, 11, 0, 414, 188, 22, false, false);
                    } else {
                        this.drawTexturedModalRect(this.field_146294_l / 2 - 47, TOP, 94, 11, 0, 414, 188, 22, false, false);
                    }
                    if (this.selectedBody.getTierRequirement() >= 0 && !(this.selectedBody instanceof Satellite)) {
                        if (!this.selectedBody.getReachable() || (this.enableNewTierSystem != false ? this.currenttier < this.tierneed : this.possibleBodies != null && this.possibleBodies.contains(this.selectedBody) == false)) {
                            canReach = false;
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        } else {
                            canReach = true;
                            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        }
                        this.drawTexturedModalRect(this.field_146294_l / 2 - 30, TOP + 11, 30, 11, 0, 414, 60, 22, false, false);
                        this.drawTexturedModalRect(this.field_146294_l / 2, TOP + 11, 30, 11, 128, 414, 60, 22, false, false);
                        str = this.enableNewTierSystem != false ? GCCoreUtil.translateWithFormat((String)"gui.message.tier.name", (Object[])new Object[]{this.tierneed > 0 && this.selectedBody.getReachable() != false ? Integer.valueOf(this.tierneed) : "?"}) : GCCoreUtil.translateWithFormat((String)"gui.message.tier.name", (Object[])new Object[]{this.selectedBody.getTierRequirement() == 0 ? "?" : Integer.valueOf(this.selectedBody.getTierRequirement())});
                        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, TOP + 13, canReach != false ? NewGuiCelestialSelection.GREY4 : NewGuiCelestialSelection.RED3);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    str = this.selectedBody.getLocalizedName();
                    if (this.selectedBody instanceof Satellite) {
                        str = GCCoreUtil.translate((String)"gui.message.rename.name").toUpperCase();
                    }
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, TOP + 2, NewGuiCelestialSelection.WHITE);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.drawTexturedModalRect(LHS + 4, TOP, 83, 12, 0, 477, 83, 12, false, false);
                    if (this.mapMode) break block220;
                    if (!this.canTravel || !this.selectedBody.getReachable() || (this.enableNewTierSystem == false ? this.possibleBodies != null && this.possibleBodies.contains(this.selectedBody) == false : this.currenttier < this.tierneed)) ** GOTO lbl-1000
                    if (this.selectedBody instanceof Satellite && this.selectedStationOwner.equals("")) lbl-1000:
                    // 2 sources

                    {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    }
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(RHS - 74, TOP, 74, 11, 0, 392, 148, 22, true, false);
                    str = GCCoreUtil.translate((String)"gui.message.launch.name").toUpperCase();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146289_q.func_78276_b(str, RHS - 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 2, NewGuiCelestialSelection.WHITE);
                }
                if (this.selectionState == GuiCelestialSelection.EnumSelection.SELECTED && !(this.selectedBody instanceof Satellite)) {
                    handledSliderPos = true;
                    sliderPos = this.zoomTooltipPos;
                    if (this.zoomTooltipPos != 38) {
                        this.zoomTooltipPos = sliderPos = (int)Math.min(this.ticksSinceSelectionF * 2.0f, 38.0f);
                    }
                    xOffset = 222;
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(RHS - xOffset, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE - sliderPos, 83, 38, 346, 436, 166, 76, true, false);
                    flag0 = GalaxyRegistry.getSatellitesForCelestialBody((CelestialBody)this.selectedBody).size() > 0;
                    v5 = flag1 = this.selectedBody instanceof Planet != false && GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selectedBody)).size() > 0;
                    if (flag0 && flag1) {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.click_again.0.name"), RHS - xOffset + 41, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE + 2 - sliderPos, 79, NewGuiCelestialSelection.GREY5, false, false);
                    } else if (!flag0 && flag1) {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.click_again.1.name"), RHS - xOffset + 41, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE + 6 - sliderPos, 79, NewGuiCelestialSelection.GREY5, false, false);
                    } else if (flag0) {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.click_again.2.name"), RHS - xOffset + 41, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE + 6 - sliderPos, 79, NewGuiCelestialSelection.GREY5, false, false);
                    } else {
                        this.drawSplitString(GCCoreUtil.translate((String)"gui.message.click_again.3.name"), RHS - xOffset + 41, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE + 11 - sliderPos, 79, NewGuiCelestialSelection.GREY5, false, false);
                    }
                }
                if (this.selectedBody instanceof Satellite && this.renamingSpaceStation) {
                    this.func_146276_q_();
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90, this.field_146295_m / 2 - 38, 179, 67, 159, 0, 179, 67, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 4, this.field_146295_m / 2 - 38 + 2, 171, 10, 159, 92, 171, 10, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 8, this.field_146295_m / 2 - 38 + 18, 161, 13, 159, 67, 161, 13, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 17, this.field_146295_m / 2 - 38 + 59, 72, 12, 159, 80, 72, 12, true, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2, this.field_146295_m / 2 - 38 + 59, 72, 12, 159, 80, 72, 12, false, false);
                    str = GCCoreUtil.translate((String)"gui.message.assign_name.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 - 35, NewGuiCelestialSelection.WHITE);
                    str = GCCoreUtil.translate((String)"gui.message.apply.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2 - 36, this.field_146295_m / 2 + 23, NewGuiCelestialSelection.WHITE);
                    str = GCCoreUtil.translate((String)"gui.message.cancel.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 + 36 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 + 23, NewGuiCelestialSelection.WHITE);
                    if (this.renamingString == null) {
                        selectedSatellite = (Satellite)this.selectedBody;
                        playerName = PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g);
                        this.renamingString = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(playerName)).getStationName();
                        if (this.renamingString == null) {
                            this.renamingString = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(playerName.toLowerCase())).getStationName();
                        }
                        if (this.renamingString == null) {
                            this.renamingString = "";
                        }
                    }
                    str = this.renamingString;
                    str0 = this.renamingString;
                    if (this.ticksSinceSelectionF / 10.0f % 2.0f == 0.0f) {
                        str0 = str0 + "_";
                    }
                    this.field_146289_q.func_78276_b(str0, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 - 17, NewGuiCelestialSelection.WHITE);
                }
            }
            str = EnumColor.ORANGE + "AsmodeusCore Galaxy Map";
            this.field_146289_q.func_78276_b(str, LHS + 5, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE - 10, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
            if (!handledSliderPos) {
                this.zoomTooltipPos = 0;
            }
        }
    }

    protected int drawChildren(List<CelestialBody> children, int xOffsetBase, int yOffsetPrior, boolean recursive) {
        xOffsetBase += GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        int yOffsetBase = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 50 + yOffsetPrior;
        int yOffset = 0;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            List<CelestialBody> grandchildren;
            float brightness;
            CelestialBody child = children.get(i);
            int xOffset = xOffsetBase + (child.equals((Object)this.selectedBody) ? 5 : 0);
            int scale = (int)Math.min(95.0f, Math.max(0.0f, this.ticksSinceMenuOpenF * 25.0f - (float)(95 * i)));
            BodiesData data = BodiesRegistry.getData(child);
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            float f = brightness = child.equals((Object)this.selectedBody) ? 0.2f : 0.0f;
            if (child.getReachable()) {
                if (child.equals((Object)this.selectedBody)) {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)((float)scale / 95.0f));
                } else {
                    GL11.glColor4f((float)0.0f, (float)(0.6f + brightness), (float)0.0f, (float)((float)scale / 95.0f));
                }
            } else {
                boolean checked = false;
                if (child instanceof Planet) {
                    for (Moon moon : GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)child))) {
                        if (!moon.getReachable()) continue;
                        checked = true;
                        break;
                    }
                }
                if (data != null && data.getType() == IAdvancedSpace.TypeBody.STAR) {
                    GL11.glColor4f((float)0.0f, (float)0.4f, (float)(0.6f + brightness), (float)((float)scale / 95.0f));
                } else if (child instanceof Planet && checked) {
                    GL11.glColor4f((float)(0.6f + brightness), (float)0.6f, (float)0.0f, (float)((float)scale / 95.0f));
                } else {
                    GL11.glColor4f((float)(0.6f + brightness), (float)0.0f, (float)0.0f, (float)((float)scale / 95.0f));
                }
            }
            this.drawTexturedModalRect(3 + xOffset, yOffsetBase + yOffset + 1, 86, 10, 0, 489, 86, 10, false, false);
            GL11.glColor4f((float)(3.0f * brightness), (float)(0.6f + 2.0f * brightness), (float)1.0f, (float)((float)scale / 95.0f));
            this.drawTexturedModalRect(2 + xOffset, yOffsetBase + yOffset, 93, 12, 95, 464, 93, 12, false, false);
            if (scale > 0) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int color = 0xE0E0E0;
                GlStateManager.func_179094_E();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(child.getBodyIcon());
                this.drawTexturedModalRect(xOffset + 7, yOffsetBase + yOffset + 2, 8.0f, 8.0f, 0.0f, 0.0f, 32.0f, 32.0f, false, false, 32.0f, 32.0f);
                GlStateManager.func_179121_F();
                this.field_146289_q.func_78276_b(child.getLocalizedName(), 17 + xOffset, yOffsetBase + yOffset + 2, color);
            }
            yOffset += 14;
            if (!recursive || !child.equals((Object)this.selectedBody) || (grandchildren = this.getChildren(child, 0, this.max_scroll)).size() <= 0) continue;
            if (this.animateGrandchildren == 14 * grandchildren.size()) {
                yOffset += this.drawChildren(grandchildren, 10, yOffset, false);
                continue;
            }
            if (this.animateGrandchildren >= 14) {
                LinkedList<CelestialBody> partial = new LinkedList<CelestialBody>();
                for (int j = 0; j < this.animateGrandchildren / 14; ++j) {
                    partial.add(grandchildren.get(j));
                }
                this.drawChildren(partial, 10, yOffset, false);
            }
            yOffset += this.animateGrandchildren;
            this.animateGrandchildren += 2;
        }
        if (this.small_mode && recursive) {
            boolean planetZoomedNotMoon;
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
            this.drawTexturedModalRect(BORDER_SIZE + 18, yOffsetBase + yOffset - 1, 62, 4, 280, 74, 62, 4, false, true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            boolean bl = planetZoomedNotMoon = this.isZoomed() && !(this.selectedParent instanceof Planet);
            if (this.scroll != 0) {
                this.drawTexturedModalRect(BORDER_SIZE + 47, yOffsetBase - 4, 7, 3, 344, 74, 7, 3, false, false);
            }
            if (this.scroll != this.getChildren(planetZoomedNotMoon ? this.selectedBody : this.selectedParent).size() - this.max_scroll) {
                this.drawTexturedModalRect(BORDER_SIZE + 47, yOffsetBase + yOffset, 7, 3, 344, 74, 7, 3, false, true);
            }
        }
        return yOffset;
    }

    protected void func_73864_a(int x, int y, int button) {
        boolean planetZoomedMoon;
        SpaceStationRecipe recipe;
        boolean clickHandled = false;
        int LHS = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        int RHS = this.field_146294_l - LHS;
        int TOP = LHS;
        if (x > LHS && x < LHS + 84 && y > this.field_146295_m - LHS - 26 && y < this.field_146295_m - LHS - 16) {
            boolean bl = this.hideInfo = !this.hideInfo;
        }
        if (x > LHS && x < LHS + 84 && y > this.field_146295_m - LHS - 42 && y < this.field_146295_m - LHS - 30) {
            boolean bl = this.small_mode = !this.small_mode;
        }
        if (x > LHS + 6 && x < LHS + 93 && y > TOP + 12 && y < TOP + 26 && !this.enableTraveltime) {
            if (this.galaxylist.size() > 1) {
                boolean bl = this.showGalaxyList = !this.showGalaxyList;
            }
            if (this.showStarList) {
                this.showStarList = false;
            }
        }
        if (x > LHS + 6 && x < LHS + 93 && y > TOP + 32 && y < TOP + 43 && !this.enableTraveltime) {
            if (GalaxyRegistry.getRegisteredSolarSystems().size() > 1) {
                boolean bl = this.showStarList = !this.showStarList;
            }
            if (this.showGalaxyList) {
                this.showGalaxyList = false;
            }
        }
        if (this.showStarList) {
            int l = 0;
            int posX = 0;
            for (SolarSystem s : this.starlist) {
                if (x > LHS + posX * 150 + 100 && x < LHS + posX * 150 + 193 && y > TOP + 30 * l + 8 && y < TOP + 30 * l + 37) {
                    this.selectedParent = s;
                    this.showStarList = false;
                    this.selectedBody = s.getMainStar();
                    this.selectionState = GuiCelestialSelection.EnumSelection.SELECTED;
                    this.zoom = -0.2f;
                    if (this.small_mode) {
                        this.scroll = 0;
                    }
                    this.position = new Vector2f(this.getCelestialBodyPosition((CelestialBody)this.selectedBody).x, this.getCelestialBodyPosition((CelestialBody)this.selectedBody).y);
                    clickHandled = true;
                    if (this.selectedBody instanceof IChildBody) {
                        this.galaxy = ((IChildBody)this.selectedBody).getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName();
                    }
                    if (this.selectedBody instanceof Planet) {
                        this.galaxy = ((Planet)this.selectedBody).getParentSolarSystem().getUnlocalizedParentGalaxyName();
                    }
                    if (this.selectedBody instanceof Star) {
                        this.galaxy = ((Star)this.selectedBody).getParentSolarSystem().getUnlocalizedParentGalaxyName();
                    }
                }
                if (++l % 7 != 0) continue;
                ++posX;
                l = 0;
            }
        }
        if (this.showGalaxyList) {
            for (int i = 0; i < this.galaxylist.size(); ++i) {
                if (x <= LHS + 100 + 70 * i || x >= LHS + 193 + 70 * i || y <= TOP + 4 || y >= TOP + 60) continue;
                this.galaxy = this.galaxylist.get(i);
                this.zoom = -1.0f;
                this.showGalaxyList = false;
                System.out.println(this.galaxy);
                this.starlist.clear();
                this.refreshBodies();
                Iterator<SolarSystem> posX = this.starlist.iterator();
                if (!posX.hasNext()) continue;
                SolarSystem s = posX.next();
                this.selectedBody = s.getMainStar();
                this.selectionState = GuiCelestialSelection.EnumSelection.SELECTED;
                this.zoom = -0.2f;
                this.position = new Vector2f(this.getCelestialBodyPosition((CelestialBody)this.selectedBody).x, this.getCelestialBodyPosition((CelestialBody)this.selectedBody).y);
                clickHandled = true;
            }
        }
        if (!this.enableTraveltime && this.selectedBody != null && x > LHS && x < LHS + 88 && y > TOP && y < TOP + 13) {
            this.unselectCelestialBody();
            return;
        }
        if (!this.mapMode && x >= RHS - 95 && x < RHS && y > TOP + 62 + this.canCreateOffset && y < TOP + 62 + 12 + this.canCreateOffset && this.selectedBody != null && (recipe = WorldUtil.getSpaceStationRecipe((int)this.selectedBody.getDimensionID())) != null && this.canCreateSpaceStation(this.selectedBody)) {
            if (recipe.matches((EntityPlayer)this.field_146297_k.field_71439_g, false) || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_BIND_SPACE_STATION_ID, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.selectedBody.getDimensionID()}));
                if (!this.isZoomed()) {
                    this.selectionState = GuiCelestialSelection.EnumSelection.ZOOMED;
                    this.preSelectZoom = this.zoom;
                    this.preSelectPosition = this.position;
                    this.ticksSinceSelectionF = 0.0f;
                    this.ticksSinceSelection = 0;
                    this.doneZooming = false;
                }
                return;
            }
            clickHandled = true;
        }
        if (this.mapMode && x > RHS - 88 && x < RHS && y > TOP && y < TOP + 13) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
            clickHandled = true;
        }
        if (this.selectedBody != null && !this.mapMode && x > RHS - 88 && x < RHS && y > TOP && y < TOP + 13) {
            if (!(this.selectedBody instanceof Satellite) || !this.selectedStationOwner.equals("")) {
                if (!this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && this.currenttier >= this.tierneed && this.enableNewTierSystem) {
                    this.enableTraveltime = this.canTravel;
                } else {
                    this.teleportToSelectedBody();
                }
            }
            clickHandled = true;
        }
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY() * -1 + Minecraft.func_71410_x().field_71440_d - 1;
        if (this.selectedBody instanceof Satellite) {
            if (this.renamingSpaceStation) {
                if (x >= this.field_146294_l / 2 - 90 && x <= this.field_146294_l / 2 + 90 && y >= this.field_146295_m / 2 - 38 && y <= this.field_146295_m / 2 + 38) {
                    if (x >= this.field_146294_l / 2 - 90 + 17 && x <= this.field_146294_l / 2 - 90 + 17 + 72 && y >= this.field_146295_m / 2 - 38 + 59 && y <= this.field_146295_m / 2 - 38 + 59 + 12) {
                        String strName = PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g);
                        Satellite selectedSatellite = (Satellite)this.selectedBody;
                        Integer spacestationID = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(strName)).getStationDimensionID();
                        if (spacestationID == null) {
                            spacestationID = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(strName.toLowerCase())).getStationDimensionID();
                        }
                        if (spacestationID != null) {
                            ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(strName)).setStationName(this.renamingString);
                            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_RENAME_SPACE_STATION, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), new Object[]{this.renamingString, spacestationID}));
                        }
                        this.renamingSpaceStation = false;
                    }
                    if (x >= this.field_146294_l / 2 && x <= this.field_146294_l / 2 + 72 && y >= this.field_146295_m / 2 - 38 + 59 && y <= this.field_146295_m / 2 - 38 + 59 + 12) {
                        this.renamingSpaceStation = false;
                    }
                    clickHandled = true;
                }
            } else {
                this.drawTexturedModalRect(this.field_146294_l / 2 - 47, TOP, 94, 11, 0, 414, 188, 22, false, false);
                if (x >= this.field_146294_l / 2 - 47 && x <= this.field_146294_l / 2 - 47 + 94 && y >= TOP && y <= TOP + 11 && this.selectedStationOwner.length() != 0 && this.selectedStationOwner.equalsIgnoreCase(PlayerUtil.getName((EntityPlayer)this.field_146297_k.field_71439_g))) {
                    this.renamingSpaceStation = true;
                    this.renamingString = null;
                    clickHandled = true;
                }
                Satellite selectedSatellite = (Satellite)this.selectedBody;
                int stationListSize = ((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).size();
                int max = Math.min(this.field_146295_m / 2 / 14, stationListSize);
                int xPos = RHS - 85;
                int yPos2 = TOP + 45;
                if (x >= xPos && x <= xPos + 61 && y >= yPos2 && y <= yPos2 + 4) {
                    if (this.spaceStationListOffset > 0) {
                        --this.spaceStationListOffset;
                    }
                    clickHandled = true;
                }
                xPos = RHS - 85;
                yPos2 = TOP + 49 + max * 14;
                if (x >= xPos && x <= xPos + 61 && y >= yPos2 && y <= yPos2 + 4) {
                    if (max + this.spaceStationListOffset < stationListSize) {
                        ++this.spaceStationListOffset;
                    }
                    clickHandled = true;
                }
                Iterator it = ((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).entrySet().iterator();
                int i = 0;
                int j = 0;
                while (it.hasNext() && i < max) {
                    Map.Entry e = it.next();
                    if (j >= this.spaceStationListOffset) {
                        int xOffset = 0;
                        if (((String)e.getKey()).equalsIgnoreCase(this.selectedStationOwner)) {
                            xOffset -= 5;
                        }
                        xPos = RHS - 95 + xOffset;
                        yPos2 = TOP + 50 + i * 14;
                        if (x >= xPos && x <= xPos + 93 && y >= yPos2 && y <= yPos2 + 12) {
                            this.selectedStationOwner = (String)e.getKey();
                            clickHandled = true;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        int xPos = LHS + 2;
        int yPos = TOP + 10;
        boolean bl = planetZoomedMoon = this.isZoomed() && this.selectedParent instanceof Planet;
        if (x >= xPos && x <= xPos + 93 && y >= yPos && y <= yPos + 12 && this.selectedParent instanceof CelestialBody) {
            if (this.selectedBody == null) {
                this.preSelectZoom = this.zoom;
                this.preSelectPosition = this.position;
            }
            GuiCelestialSelection.EnumSelection selectionCountOld = this.selectionState;
            if (!this.enableTraveltime && this.isSelected()) {
                this.unselectCelestialBody();
            }
            if (selectionCountOld == GuiCelestialSelection.EnumSelection.ZOOMED) {
                this.selectionState = GuiCelestialSelection.EnumSelection.SELECTED;
            }
            this.selectedBody = (CelestialBody)this.selectedParent;
            this.ticksSinceSelectionF = 0.0f;
            this.ticksSinceSelection = 0;
            this.selectionState = GuiCelestialSelection.EnumSelection.values()[this.selectionState.ordinal() + 1];
            if (this.isZoomed() && !planetZoomedMoon) {
                this.ticksSinceMenuOpenF = 0.0f;
                this.ticksSinceMenuOpen = 0;
            }
            clickHandled = true;
        }
        if (x >= xPos && x <= xPos + 93 && y >= (yPos += 22) && y <= yPos + 12) {
            if (planetZoomedMoon) {
                if (this.selectedBody == null) {
                    this.preSelectZoom = this.zoom;
                    this.preSelectPosition = this.position;
                }
                GuiCelestialSelection.EnumSelection selectionCountOld = this.selectionState;
                if (!this.enableTraveltime && this.isSelected()) {
                    this.unselectCelestialBody();
                }
                if (selectionCountOld == GuiCelestialSelection.EnumSelection.ZOOMED) {
                    this.selectionState = GuiCelestialSelection.EnumSelection.SELECTED;
                }
                this.selectedBody = (CelestialBody)this.selectedParent;
                this.ticksSinceSelectionF = 0.0f;
                this.ticksSinceSelection = 0;
                this.selectionState = GuiCelestialSelection.EnumSelection.values()[this.selectionState.ordinal() + 1];
            }
            clickHandled = true;
        }
        if (!clickHandled) {
            List<CelestialBody> children = this.getChildren(this.isZoomed() ? this.selectedBody : this.selectedParent, this.scroll, this.max_scroll);
            yPos = TOP + 50;
            Iterator<CelestialBody> yPos2 = children.iterator();
            while (yPos2.hasNext()) {
                CelestialBody child;
                clickHandled = this.testClicked(child, (child = yPos2.next()).equals((Object)this.selectedBody) ? 5 : 0, yPos, x, y, false);
                yPos += 14;
                if (!clickHandled && !this.isZoomed() && child.equals((Object)this.selectedBody)) {
                    List<CelestialBody> grandchildren = this.getChildren(child, 0, this.max_scroll);
                    int gOffset = 0;
                    for (CelestialBody grandchild : grandchildren) {
                        if (gOffset + 14 > this.animateGrandchildren) break;
                        clickHandled = this.testClicked(grandchild, 10, yPos, x, y, true);
                        yPos += 14;
                        gOffset += 14;
                        if (!clickHandled) continue;
                        break;
                    }
                    yPos += this.animateGrandchildren - gOffset;
                }
                if (!clickHandled) continue;
                break;
            }
        }
        if (!clickHandled) {
            for (Map.Entry e : this.planetPosMap.entrySet()) {
                float iconSize;
                CelestialBody bodyClicked = (CelestialBody)e.getKey();
                if (this.selectedBody == null && bodyClicked instanceof IChildBody || !((float)mouseX >= ((Vector3f)e.getValue()).x - (iconSize = ((Vector3f)e.getValue()).z)) || !((float)mouseX <= ((Vector3f)e.getValue()).x + iconSize) || !((float)mouseY >= ((Vector3f)e.getValue()).y - iconSize) || !((float)mouseY <= ((Vector3f)e.getValue()).y + iconSize) || this.selectedBody == bodyClicked && this.isZoomed()) continue;
                if (this.isSelected() && this.selectedBody != bodyClicked) {
                    if (this.isZoomed()) {
                        this.selectionState = GuiCelestialSelection.EnumSelection.SELECTED;
                    }
                    if (this.small_mode) {
                        this.scroll = 0;
                    }
                }
                if (bodyClicked != this.selectedBody) {
                    this.lastSelectedBody = this.selectedBody;
                    this.animateGrandchildren = 0;
                    if (!(this.selectedBody instanceof IChildBody) || ((IChildBody)this.selectedBody).getParentPlanet() != bodyClicked) {
                        this.selectionState = GuiCelestialSelection.EnumSelection.UNSELECTED;
                    }
                } else {
                    this.doneZooming = false;
                    this.planetZoom = 0.0f;
                }
                if (!this.enableTraveltime) {
                    this.selectedBody = bodyClicked;
                    this.ticksSinceSelectionF = 0.0f;
                    this.ticksSinceSelection = 0;
                    this.selectionState = GuiCelestialSelection.EnumSelection.values()[this.selectionState.ordinal() + 1];
                }
                if (this.isZoomed()) {
                    this.ticksSinceMenuOpenF = 0.0f;
                    this.ticksSinceMenuOpen = 0;
                }
                if (this.selectedBody instanceof Satellite && ((Map)this.spaceStationMap.get(this.getSatelliteParentID((Satellite)this.selectedBody))).size() == 1) {
                    Iterator it = ((Map)this.spaceStationMap.get(this.getSatelliteParentID((Satellite)this.selectedBody))).entrySet().iterator();
                    this.selectedStationOwner = (String)it.next().getKey();
                }
                clickHandled = true;
                break;
            }
        }
        if (!clickHandled) {
            if (!this.enableTraveltime && this.selectedBody != null) {
                if (x > RHS - 35 && x < RHS - 10 && y > TOP + 210 && y < TOP + 220) {
                    BodiesData data = BodiesRegistry.getData(this.selectedBody);
                    int k = 2;
                    if (this.small_page < k) {
                        ++this.small_page;
                    }
                } else if (x > RHS - 120 && x < RHS - 90 && y > TOP + 210 && y < TOP + 220) {
                    if (this.small_page > 0) {
                        --this.small_page;
                    }
                } else {
                    this.unselectCelestialBody();
                }
                this.planetZoom = 0.0f;
            }
            this.mouseDragging = true;
        }
        Object selectedParent = this.selectedParent;
        if (this.selectedBody instanceof IChildBody) {
            selectedParent = ((IChildBody)this.selectedBody).getParentPlanet();
        } else if (this.selectedBody instanceof Planet) {
            selectedParent = ((Planet)this.selectedBody).getParentSolarSystem();
        } else if (this.selectedBody instanceof Star) {
            selectedParent = ((Star)this.selectedBody).getParentSolarSystem();
        } else if (this.selectedBody == null) {
            if (this.lastSelectedBody instanceof Planet) {
                selectedParent = ((Planet)this.lastSelectedBody).getParentSolarSystem();
            }
            if (this.lastSelectedBody instanceof IChildBody) {
                selectedParent = ((IChildBody)this.lastSelectedBody).getParentPlanet().getParentSolarSystem();
            }
        }
        if (this.selectedParent != selectedParent) {
            this.selectedParent = selectedParent;
            this.ticksSinceMenuOpenF = 0.0f;
            this.ticksSinceMenuOpen = 0;
        }
    }

    protected boolean testClicked(CelestialBody body, int xOffset, int yPos, int x, int y, boolean grandchild) {
        int xPos = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 2 + xOffset;
        if (!(x < xPos || x > xPos + 93 || y < yPos || y > yPos + 12 || this.selectedBody == body && this.isZoomed())) {
            GuiCelestialSelection.EnumSelection selectionCountOld;
            if (this.selectedBody == null) {
                this.preSelectZoom = this.zoom;
                this.preSelectPosition = this.position;
            }
            if ((selectionCountOld = this.selectionState) == GuiCelestialSelection.EnumSelection.ZOOMED) {
                this.selectionState = GuiCelestialSelection.EnumSelection.SELECTED;
            }
            this.doneZooming = false;
            this.planetZoom = 0.0f;
            if (body != this.selectedBody) {
                this.lastSelectedBody = this.selectedBody;
                this.selectionState = GuiCelestialSelection.EnumSelection.SELECTED;
                if (this.small_mode) {
                    this.scroll = 0;
                }
            } else if (!this.enableTraveltime) {
                this.selectionState = GuiCelestialSelection.EnumSelection.values()[this.selectionState.ordinal() + 1];
            }
            if (!this.enableTraveltime) {
                this.selectedBody = body;
                this.ticksSinceSelectionF = 0.0f;
                this.ticksSinceSelection = 0;
                this.small_page = 0;
                if (grandchild) {
                    this.selectionState = GuiCelestialSelection.EnumSelection.ZOOMED;
                }
            }
            if (this.isZoomed()) {
                this.ticksSinceMenuOpenF = 0.0f;
                this.ticksSinceMenuOpen = 0;
            }
            this.animateGrandchildren = 0;
            return true;
        }
        return false;
    }

    public void func_73863_a(int mousePosX, int mousePosY, float partialTicks) {
        block16: {
            float wheel;
            this.ticksSinceMenuOpenF += partialTicks;
            this.ticksTotalF += partialTicks;
            if (this.selectedBody != null) {
                this.ticksSinceSelectionF += partialTicks;
            }
            if (this.selectedBody == null && this.ticksSinceUnselectionF >= 0.0f) {
                this.ticksSinceUnselectionF += partialTicks;
            }
            if (Mouse.hasWheel() && (wheel = (float)Mouse.getDWheel() / (this.selectedBody == null ? 500.0f : 250.0f)) != 0.0f) {
                if (mousePosX < 105 && this.small_mode) {
                    boolean planetZoomedNotMoon;
                    boolean bl = planetZoomedNotMoon = this.isZoomed() && !(this.selectedParent instanceof Planet);
                    if (wheel > 0.0f && this.scroll > 0) {
                        --this.scroll;
                    } else if (wheel < 0.0f && this.scroll < this.getChildren(planetZoomedNotMoon ? this.selectedBody : this.selectedParent).size() - this.max_scroll) {
                        ++this.scroll;
                    }
                } else if (this.selectedBody == null || !this.isZoomed()) {
                    this.zoom = Math.min(Math.max(this.zoom + wheel * (this.zoom + 2.0f) / 10.0f, -1.095f), 3.0f);
                } else {
                    this.planetZoom = Math.min(Math.max(this.planetZoom + wheel, -4.9f), 5.0f);
                }
            }
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            Matrix4f camMatrix = new Matrix4f();
            Matrix4f.translate((Vector3f)new Vector3f(0.0f, 0.0f, -9000.0f), (Matrix4f)camMatrix, (Matrix4f)camMatrix);
            Matrix4f viewMatrix = new Matrix4f();
            viewMatrix.m00 = 2.0f / (float)this.field_146294_l;
            viewMatrix.m11 = 2.0f / (float)(-this.field_146295_m);
            viewMatrix.m22 = -2.2222222E-4f;
            viewMatrix.m30 = -1.0f;
            viewMatrix.m31 = 1.0f;
            viewMatrix.m32 = -2.0f;
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
            fb.rewind();
            viewMatrix.store(fb);
            fb.flip();
            GL11.glMultMatrix((FloatBuffer)fb);
            fb.clear();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            fb.rewind();
            camMatrix.store(fb);
            fb.flip();
            fb.clear();
            GL11.glMultMatrix((FloatBuffer)fb);
            this.setBlackBackground();
            boolean drawGrid = true;
            if (AsmodeusConfig.enableImgOnGalaxyMap) {
                GL11.glPushMatrix();
                this.setImgBackground(guiImg);
                drawGrid = false;
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            Matrix4f worldMatrix = this.setIsometric(partialTicks);
            float gridSize = 14000.0f;
            if (drawGrid) {
                this.drawGrid(gridSize, (float)(this.field_146295_m / 3) / 3.5f);
            }
            if (this.selectedBody instanceof Star) {
                this.drawAgeCircle(worldMatrix);
            }
            this.drawCircles();
            this.drawVortex();
            GL11.glPopMatrix();
            HashMap<CelestialBody, Matrix4f> matrixMap = this.drawCelestialBodies(worldMatrix);
            this.planetPosMap.clear();
            for (Map.Entry<CelestialBody, Matrix4f> e : matrixMap.entrySet()) {
                Matrix4f planetMatrix = e.getValue();
                Matrix4f matrix0 = Matrix4f.mul((Matrix4f)viewMatrix, (Matrix4f)planetMatrix, (Matrix4f)planetMatrix);
                int x = (int)Math.floor(((double)matrix0.m30 * 0.5 + 0.5) * (double)Minecraft.func_71410_x().field_71443_c);
                int y = (int)Math.floor((double)Minecraft.func_71410_x().field_71440_d - ((double)matrix0.m31 * 0.5 + 0.5) * (double)Minecraft.func_71410_x().field_71440_d);
                Vector2f vec = new Vector2f((float)x, (float)y);
                Matrix4f scaleVec = new Matrix4f();
                scaleVec.m00 = matrix0.m00;
                scaleVec.m11 = matrix0.m11;
                scaleVec.m22 = matrix0.m22;
                Vector4f newVec = Matrix4f.transform((Matrix4f)scaleVec, (Vector4f)new Vector4f(2.0f, -2.0f, 0.0f, 0.0f), null);
                float iconSize = newVec.y * ((float)Minecraft.func_71410_x().field_71440_d / 2.0f) * (float)(e.getKey() instanceof Star ? 2 : 1) * (e.getKey() == this.selectedBody ? 1.5f : 1.0f);
                this.planetPosMap.put(e.getKey(), new Vector3f(vec.x, vec.y, iconSize));
            }
            this.drawSelectionCursor(fb, worldMatrix);
            try {
                this.drawButtons(mousePosX, mousePosY);
            }
            catch (Exception e) {
                if (this.errorLogged) break block16;
                this.errorLogged = true;
                GCLog.severe((String)"Problem identifying planet or dimension in an add on for Galacticraft!");
                GCLog.severe((String)"(The problem is likely caused by a dimension ID conflict.  Check configs for dimension clashes.  You can also try disabling Mars space station in configs.)");
                e.printStackTrace();
            }
        }
        this.drawBorder();
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    protected void drawSelectionCursor(FloatBuffer fb, Matrix4f worldMatrix) {
        GL11.glPushMatrix();
        switch (this.selectionState) {
            case SELECTED: {
                if (this.selectedBody == null) break;
                this.setupMatrix(this.selectedBody, worldMatrix, fb);
                fb.clear();
                GL11.glScalef((float)0.06666667f, (float)0.06666667f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                float colMod = this.getZoomAdvanced() < 4.9f ? (float)(Math.sin(this.ticksSinceSelectionF / 2.0f) * 0.5 + 0.5) : 1.0f;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)(1.0f * colMod));
                int width = (int)Math.floor((double)this.getWidthForCelestialBody(this.selectedBody) / 2.0 * (this.selectedBody instanceof IChildBody ? 9.0 : 30.0));
                this.drawTexturedModalRect(-width, -width, width * 2, width * 2, 266, 29, 100, 100, false, false);
                GL11.glPushMatrix();
                float size = this.selectedBody instanceof IChildBody ? 2.0f : 12.0f;
                GL11.glScalef((float)size, (float)size, (float)size);
                String name = this.selectedBody.getLocalizedName();
                int white = Utils.getIntColor(255, 255, 255, 255);
                int yellow = Utils.getIntColor(255, 255, 0, 255);
                this.func_73731_b(this.field_146289_q, name, 4 + this.getWidthForCelestialBody(this.selectedBody), -5, this.selectedBody instanceof Star ? yellow : white);
                GL11.glPopMatrix();
                break;
            }
            case ZOOMED: {
                if (this.selectedBody == null) break;
                this.setupMatrix(this.selectedBody, worldMatrix, fb);
                fb.clear();
                float div = this.zoom + 1.0f - this.planetZoom;
                float scale = Math.max(0.3f, 1.5f / (this.ticksSinceSelectionF / 5.0f)) * 2.0f / div;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                float colMod = this.getZoomAdvanced() < 4.9f ? (float)(Math.sin(this.ticksSinceSelectionF / 1.0f) * 0.5 + 0.5) : 1.0f;
                GL11.glColor4f((float)0.4f, (float)0.8f, (float)1.0f, (float)(1.0f * colMod));
                int width = this.getWidthForCelestialBody(this.selectedBody) * 13;
                this.drawTexturedModalRect(-width, -width, width * 2, width * 2, 266, 29, 100, 100, false, false);
                break;
            }
        }
        GL11.glPopMatrix();
    }

    public int getWidthForCelestialBody(CelestialBody celestialBody) {
        boolean zoomed = celestialBody == this.selectedBody && this.selectionState == GuiCelestialSelection.EnumSelection.SELECTED;
        float size = celestialBody.getRelativeSize();
        if ((double)size < 0.9 && celestialBody instanceof IChildBody) {
            size = 1.0f;
        }
        if (size > 5.0f) {
            size = 5.0f;
        }
        if (size < 0.3f) {
            size = 0.3f;
        }
        return (int)(celestialBody instanceof Star ? (zoomed ? 12.0f * size : 8.0f * size) : (celestialBody instanceof Planet ? (zoomed ? 6.0f * size : 4.0f * size) : (celestialBody instanceof IChildBody ? (zoomed ? 6.0f * size : 4.0f * size) : 2.0f)));
    }

    public HashMap<CelestialBody, Matrix4f> drawCelestialBodies(Matrix4f worldMatrix) {
        Matrix4f worldMatrixLocal;
        float alpha;
        boolean hasParent;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
        HashMap matrixMap = Maps.newHashMap();
        for (CelestialBody body : this.bodiesToRender) {
            hasParent = body instanceof IChildBody;
            alpha = this.getAlpha(body);
            if (!(body instanceof Satellite && alpha > 0.0f) && (body instanceof Satellite || !(alpha >= 0.0f))) continue;
            GlStateManager.func_179094_E();
            worldMatrixLocal = this.setupMatrix(body, worldMatrix, fb, hasParent ? 0.25f : 1.0f);
            CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre(body, body.getBodyIcon(), 16);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (preEvent.celestialBodyTexture != null) {
                this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
            }
            if (!preEvent.isCanceled()) {
                int size = this.getWidthForCelestialBody(body);
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                if (size % 2 != 0) {
                    xOffset = body.getRelativeSize() < 1.0f ? -0.5f : 0.0f;
                    yOffset = body.getRelativeSize() < 1.0f ? -0.5f : 0.0f;
                }
                BodiesData data = BodiesRegistry.getData(body);
                if (body instanceof Star || data != null && data.getType() == IAdvancedSpace.TypeBody.STAR && data.getStarColor() != null) {
                    GL11.glPushMatrix();
                    GL11.glShadeModel((int)7425);
                    GL11.glDisable((int)3553);
                    GL11.glEnable((int)3008);
                    GL11.glAlphaFunc((int)516, (float)0.0f);
                    float r = 1.0f;
                    float g = 1.0f;
                    float b = 0.8f;
                    float a = 0.7f;
                    float f10 = size * 4;
                    if (data != null && data.getType() == IAdvancedSpace.TypeBody.STAR) {
                        if (data.getStarColor() != null) {
                            r = data.getStarColor().getColor().floatX() / 255.0f;
                            g = data.getStarColor().getColor().floatY() / 255.0f;
                            b = data.getStarColor().getColor().floatZ() / 255.0f;
                            a = 0.7f;
                        }
                        if (data.getStarClass() == IAdvancedSpace.StarClass.BLACKHOLE) {
                            a = 0.0f;
                            b = 0.0f;
                            g = 0.0f;
                            r = 0.0f;
                        }
                    }
                    float xSize = 0.0f;
                    float ySize = 0.0f;
                    GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
                    GL11.glDisable((int)2884);
                    GL11.glBegin((int)6);
                    GL11.glVertex2d((double)(xSize /= 4.0f), (double)(ySize /= 4.0f));
                    for (int angle = 0; angle <= 360; angle += 60) {
                        if (angle % 120 == 0) {
                            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                        }
                        double x = (double)f10 * Math.cos((double)angle * Math.PI / 180.0);
                        double y = (double)f10 * Math.sin((double)angle * Math.PI / 180.0);
                        GL11.glVertex2d((double)(x + (double)xSize), (double)(y + (double)ySize));
                    }
                    GL11.glEnd();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3008);
                    GL11.glPopMatrix();
                }
                this.drawTexturedModalRect(xOffset + (float)(-size / 2), yOffset + (float)(-size / 2), size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                matrixMap.put(body, worldMatrixLocal);
            }
            CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post(body);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
            GlStateManager.func_179121_F();
        }
        for (CelestialBody body : this.bodiesToRender) {
            hasParent = body instanceof IChildBody;
            alpha = this.getAlpha(body);
            if (!(body instanceof Satellite && alpha > 0.0f) && (body instanceof Satellite || !(alpha >= 0.0f))) continue;
            GlStateManager.func_179094_E();
            worldMatrixLocal = this.setupMatrix(body, worldMatrix, fb, hasParent ? 0.25f : 1.0f);
            if (this.selectionState == GuiCelestialSelection.EnumSelection.UNSELECTED && !hasParent || this.selectionState == GuiCelestialSelection.EnumSelection.ZOOMED && hasParent) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                String name = body.getLocalizedName();
                int white = Utils.getIntColor(255, 255, 255, 255);
                int yellow = Utils.getIntColor(255, 255, 0, 255);
                this.func_73731_b(this.field_146289_q, name, 4 + this.getWidthForCelestialBody(body), -5, body instanceof Star ? yellow : white);
                if (ClientProxyCore.playerHead != null) {
                    if (this.selectionState == GuiCelestialSelection.EnumSelection.UNSELECTED && this.field_146297_k.field_71441_e.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody() instanceof IChildBody) {
                        if (body == ((IChildBody)((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody()).getParentPlanet()) {
                            GlStateManager.func_179147_l();
                            GlStateManager.func_179112_b((int)770, (int)771);
                            GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                            this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                            this.func_73729_b(20 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                        }
                    } else if (this.field_146297_k.field_71441_e.field_73011_w instanceof IGalacticraftWorldProvider && body != GalacticraftCore.planetOverworld && ((IGalacticraftWorldProvider)this.field_146297_k.field_71441_e.field_73011_w).getCelestialBody() == body) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179112_b((int)770, (int)771);
                        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                        this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                        this.func_73729_b(20 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                    } else if (this.field_146297_k.field_71441_e.field_73011_w instanceof WorldProviderSurface && body == GalacticraftCore.planetOverworld) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179112_b((int)770, (int)771);
                        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
                        this.field_146297_k.field_71446_o.func_110577_a(ClientProxyCore.playerHead);
                        this.func_73729_b(20 + this.field_146289_q.func_78256_a(name) * 5, -18, 32, 32, 32, 32);
                    }
                }
            }
            GlStateManager.func_179121_F();
        }
        return matrixMap;
    }

    protected Matrix4f setupMatrix(CelestialBody body, Matrix4f worldMatrix, FloatBuffer fb, float scaleXZ) {
        Matrix4f worldMatrix0 = new Matrix4f(worldMatrix);
        Matrix4f.translate((Vector3f)this.getCelestialBodyPosition(body), (Matrix4f)worldMatrix0, (Matrix4f)worldMatrix0);
        Matrix4f worldMatrix1 = new Matrix4f();
        Matrix4f.rotate((float)((float)Math.toRadians(this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        Matrix4f.rotate((float)((float)Math.toRadians(-this.isometx)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        if (scaleXZ != 1.0f) {
            Matrix4f.scale((Vector3f)new Vector3f(scaleXZ, scaleXZ, 1.0f), (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        }
        worldMatrix1 = Matrix4f.mul((Matrix4f)worldMatrix0, (Matrix4f)worldMatrix1, (Matrix4f)worldMatrix1);
        fb.rewind();
        worldMatrix1.store(fb);
        fb.flip();
        GL11.glMultMatrix((FloatBuffer)fb);
        return worldMatrix1;
    }

    protected void func_146273_a(int x, int y, int lastButtonClicked, long timeSinceMouseClick) {
        if (this.mouseDragging && this.lastMovePosX != -1 && lastButtonClicked == 0) {
            int deltaX = x - this.lastMovePosX;
            int deltaY = y - this.lastMovePosY;
            float scollMultiplier = -Math.abs(this.zoom);
            if (this.zoom == -1.0f) {
                scollMultiplier = -10.5f;
            } else if (this.zoom >= -0.25f && this.zoom <= 0.15f) {
                scollMultiplier = -0.2f;
            }
            if (this.zoom >= 0.15f) {
                scollMultiplier = -0.25f;
            }
            this.translation.x = this.translation.x + (float)(deltaX - deltaY) * scollMultiplier * (ConfigManagerCore.invertMapMouseScroll ? -1.0f : 1.0f) * ConfigManagerCore.mapMouseScrollSensitivity * 0.2f;
            this.translation.y = this.translation.y + (float)(deltaY + deltaX) * scollMultiplier * (ConfigManagerCore.invertMapMouseScroll ? -1.0f : 1.0f) * ConfigManagerCore.mapMouseScrollSensitivity * 0.2f;
            if (AsmodeusConfig.enableDynamicImgOnGalaxyMap) {
                this.xImgOffset += (double)((float)deltaX * (scollMultiplier / 4.0f));
                this.yImgOffset += (double)((float)deltaY * (scollMultiplier / 4.0f));
            }
        }
        this.lastMovePosX = x;
        this.lastMovePosY = y;
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.mouseDragging = false;
        this.lastMovePosX = -1;
        this.lastMovePosY = -1;
    }

    public void setImgBackground(ResourceLocation galaxy) {
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glTranslated((double)-40.0, (double)-40.0, (double)0.0);
        GL11.glTranslated((double)this.xImgOffset, (double)this.yImgOffset, (double)0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(galaxy);
        int width = Display.getWidth();
        int height = Display.getHeight();
        this.drawTexturedModalRect(0.0f, 0.0f, width, height, 0.0f, 0.0f, width * 2, height * 2, false, false, 1024.0f, 1024.0f);
        ResourceLocation guiImg_2 = new ResourceLocation("asmodeuscore", "textures/gui/galaxymap_nebula_" + this.nebula_img + ".png");
        this.field_146297_k.field_71446_o.func_110577_a(guiImg_2);
        GL11.glTranslated((double)(this.xImgOffset * 1.5), (double)(this.yImgOffset * 1.5), (double)0.0);
        GL11.glColor4f((float)0.5f, (float)0.4f, (float)((float)this.nebula_color.field_72449_c), (float)0.5f);
        this.drawTexturedModalRect(0.0f, 0.0f, width, height, 0.0f, 0.0f, 1024.0f, 1024.0f, false, false, 1024.0f, 1024.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public Matrix4f setIsometric(float partialTicks) {
        float zoomLocal;
        Matrix4f mat0 = new Matrix4f();
        Matrix4f.translate((Vector3f)new Vector3f((float)this.field_146294_l / 2.0f, (float)(this.field_146295_m / 2), 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        Matrix4f.rotate((float)((float)Math.toRadians(this.isometx)), (Vector3f)new Vector3f(1.0f, 0.0f, 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        Matrix4f.rotate((float)((float)Math.toRadians(-this.isometz)), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        this.zoom = zoomLocal = this.getZoomAdvanced();
        Matrix4f.scale((Vector3f)new Vector3f(1.1f + zoomLocal, 1.1f + zoomLocal, 1.1f + zoomLocal), (Matrix4f)mat0, (Matrix4f)mat0);
        Vector2f cBodyPos = this.getTranslationAdvanced(partialTicks);
        this.position = this.getTranslationAdvanced(partialTicks);
        Matrix4f.translate((Vector3f)new Vector3f(-cBodyPos.x, -cBodyPos.y, 0.0f), (Matrix4f)mat0, (Matrix4f)mat0);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)16);
        fb.rewind();
        mat0.store(fb);
        fb.flip();
        GL11.glMultMatrix((FloatBuffer)fb);
        return mat0;
    }

    public float getAlpha(CelestialBody body) {
        float alpha = 1.0f;
        if (body instanceof IChildBody) {
            boolean isPossible;
            boolean selected = body == this.selectedBody || ((IChildBody)body).getParentPlanet() == this.selectedBody && this.selectionState != GuiCelestialSelection.EnumSelection.SELECTED;
            boolean ready = this.lastSelectedBody != null || this.ticksSinceSelection > 35;
            boolean isSibling = this.getSiblings(this.selectedBody).contains(body);
            boolean bl = isPossible = !(body instanceof Satellite) || this.possibleBodies != null && this.possibleBodies.contains(body);
            if (!selected && !isSibling || !isPossible) {
                alpha = 0.0f;
            } else if (!(!this.isZoomed() || selected && ready || isSibling)) {
                alpha = Math.min(Math.max((float)(this.ticksSinceSelection - 30) / 15.0f, 0.0f), 1.0f);
            }
        } else {
            boolean isOwnChildSelected;
            boolean isSelected = this.selectedBody == body;
            boolean isChildSelected = this.selectedBody instanceof IChildBody;
            boolean bl = isOwnChildSelected = isChildSelected && ((IChildBody)this.selectedBody).getParentPlanet() == body;
            if (!isSelected && !isOwnChildSelected && (this.isZoomed() || isChildSelected)) {
                alpha = this.lastSelectedBody != null || this.selectedBody instanceof IChildBody ? 0.0f : 0.4f - Math.min((float)this.ticksSinceSelection / 25.0f, 0.4f);
            }
        }
        return alpha;
    }

    public void drawCircles() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        int count = 0;
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        for (CelestialBody body : this.bodiesToRender) {
            Vector3f systemOffset = new Vector3f(0.0f, 0.0f, 0.0f);
            if (body instanceof IChildBody) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((IChildBody)body).getParentPlanet());
            } else if (body instanceof Planet) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Planet)body).getParentSolarSystem().getMainStar());
            } else if (body instanceof Star) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
            } else if (body instanceof ICelestialRegistry && !(body instanceof IChildBody)) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((ICelestialRegistry)body).getParentSolarSystem().getMainStar());
            }
            float orbit_ext_x = body instanceof IExBody ? ((IExBody)body).getXOrbitEccentricity() : 1.0f;
            float orbit_ext_y = body instanceof IExBody ? ((IExBody)body).getYOrbitEccentricity() : 1.0f;
            float orbit_offset_x = body instanceof IExBody ? ((IExBody)body).getXOrbitOffset() : 0.0f;
            float orbit_offset_y = body instanceof IExBody ? ((IExBody)body).getYOrbitOffset() : 0.0f;
            float x = this.getScale(body);
            float y = 0.0f;
            float alpha = this.getAlpha(body);
            if (!(alpha > 0.0f)) continue;
            switch (count % 2) {
                case 0: {
                    GL11.glColor4f((float)0.0f, (float)0.2857143f, (float)0.64285713f, (float)(alpha / 2.4f));
                    break;
                }
                case 1: {
                    GL11.glColor4f((float)0.0f, (float)0.4f, (float)0.9f, (float)(alpha / 2.4f));
                }
            }
            if (body.equals((Object)this.selectedBody)) {
                GL11.glColor4f((float)0.0f, (float)0.4f, (float)0.9f, (float)1.0f);
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre(body, systemOffset);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            if (!preEvent.isCanceled()) {
                GL11.glTranslatef((float)systemOffset.x, (float)systemOffset.y, (float)systemOffset.z);
                GL11.glBegin((int)2);
                for (int i = 0; i < 90; ++i) {
                    GL11.glVertex2f((float)((x + orbit_offset_x) * (orbit_ext_x > 0.0f ? orbit_ext_x : 1.0f)), (float)((y + orbit_offset_y) * (orbit_ext_y > 0.0f ? orbit_ext_y : 1.0f)));
                    float temp = x;
                    x = cos * x - sin * y;
                    y = sin * temp + cos * y;
                }
                GL11.glEnd();
                GL11.glTranslatef((float)(-systemOffset.x), (float)(-systemOffset.y), (float)(-systemOffset.z));
                ++count;
            }
            CelestialBodyRenderEvent.CelestialRingRenderEvent.Post postEvent = new CelestialBodyRenderEvent.CelestialRingRenderEvent.Post(body);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
        }
        GL11.glLineWidth((float)1.0f);
    }

    private void drawAgeCircle(Matrix4f worldMatrix) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glLineWidth((float)2.0f);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        CelestialBody body = this.selectedBody;
        Vector3f systemOffset = new Vector3f(0.0f, 0.0f, 0.0f);
        if (body instanceof Star) {
            systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
        }
        float x = 1000.0f;
        float y = 0.0f;
        GL11.glTranslatef((float)systemOffset.x, (float)systemOffset.y, (float)systemOffset.z);
        for (int count_rings = 1; count_rings <= 8; ++count_rings) {
            x = 1000 * count_rings;
            GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.5f);
            GL11.glBegin((int)2);
            for (int i = 0; i < 90; ++i) {
                GL11.glVertex2f((float)(x * 1.0f), (float)(y * 1.0f));
                float temp = x;
                x = cos * x - sin * y;
                y = sin * temp + cos * y;
            }
            GL11.glEnd();
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3553);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b((int)(x / 1000.0f) * 5 + " l.y.", (int)x, (int)y, 0xFFFFFF);
            GL11.glDisable((int)3553);
            GlStateManager.func_179121_F();
        }
        GL11.glTranslatef((float)(-systemOffset.x), (float)(-systemOffset.y), (float)(-systemOffset.z));
        GL11.glLineWidth((float)1.0f);
    }

    private void drawVortex() {
        for (CelestialBody body : this.bodiesToRender) {
            GlStateManager.func_179094_E();
            Vector3f systemOffset = new Vector3f(0.0f, 0.0f, 0.0f);
            BodiesData data = BodiesRegistry.getData(body);
            if (body instanceof Star && data != null && data.getStarClass() == IAdvancedSpace.StarClass.BLACKHOLE) {
                systemOffset = this.getCelestialBodyPosition((CelestialBody)((Star)body));
                float size = (float)this.getWidthForCelestialBody(body) * 4.0f;
                float xOffset = systemOffset.x;
                float yOffset = systemOffset.y;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float n = size / 2.0f;
                GlStateManager.func_179109_b((float)(xOffset + -size / 2.0f + n), (float)(yOffset + -size / 2.0f + n), (float)0.0f);
                GlStateManager.func_179114_b((float)(this.ticksTotalF % 360.0f * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)(-(xOffset + -size / 2.0f) - n), (float)(-(yOffset + -size / 2.0f) - n), (float)0.0f);
                this.field_146297_k.field_71446_o.func_110577_a(vortexTexture);
                this.drawTexturedModalRect(xOffset + -size / 2.0f, yOffset + -size / 2.0f, size, size, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
            }
            GlStateManager.func_179121_F();
        }
    }

    protected Vector3f getCelestialBodyPosition(CelestialBody cBody) {
        if (cBody == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if (cBody instanceof Star) {
            if (cBody.getUnlocalizedName().equalsIgnoreCase("star.sol")) {
                return new Vector3f();
            }
            return ((Star)cBody).getParentSolarSystem().getMapPosition().toVector3f();
        }
        float timeScale = cBody instanceof Planet ? 200.0f : 2.0f;
        float orbit_ext_x = cBody instanceof IExBody ? ((IExBody)cBody).getXOrbitEccentricity() : 1.0f;
        float orbit_ext_y = cBody instanceof IExBody ? ((IExBody)cBody).getYOrbitEccentricity() : 1.0f;
        float orbit_offset_x = cBody instanceof IExBody ? ((IExBody)cBody).getXOrbitOffset() : 0.0f;
        float orbit_offset_y = cBody instanceof IExBody ? ((IExBody)cBody).getYOrbitOffset() : 0.0f;
        float distanceFromCenter = this.getScale(cBody);
        float x = (float)Math.sin(this.ticksTotalF / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter;
        float y = (float)Math.cos(this.ticksTotalF / (timeScale * cBody.getRelativeOrbitTime()) + cBody.getPhaseShift()) * distanceFromCenter;
        Vector3f cBodyPos = new Vector3f((x + orbit_offset_x) * (orbit_ext_x > 0.0f ? orbit_ext_x : 1.0f), (y + orbit_offset_y) * (orbit_ext_y > 0.0f ? orbit_ext_y : 1.0f), 0.0f);
        if (cBody instanceof Planet) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((Planet)cBody).getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        if (cBody instanceof IChildBody) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((IChildBody)cBody).getParentPlanet());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        if (cBody instanceof ICelestialRegistry) {
            Vector3f parentVec = this.getCelestialBodyPosition((CelestialBody)((ICelestialRegistry)cBody).getParentSolarSystem().getMainStar());
            return Vector3f.add((Vector3f)cBodyPos, (Vector3f)parentVec, null);
        }
        return cBodyPos;
    }

    protected float getScale(CelestialBody celestialBody) {
        float scale = 0.2f;
        if (celestialBody instanceof Planet) {
            scale = 25.0f;
        }
        if (celestialBody instanceof ICelestialRegistry && !((ICelestialRegistry)celestialBody instanceof IChildBody)) {
            scale = 25.0f;
        }
        return 3.0f * celestialBody.getRelativeDistanceFromCenter().unScaledDistance * scale;
    }

    protected void func_73869_a(char keyChar, int keyID) throws IOException {
        if (this.mapMode) {
            super.func_73869_a(keyChar, keyID);
        }
        if (keyID == 1 && !this.enableTraveltime && this.selectedBody != null) {
            this.unselectCelestialBody();
        }
        if (this.renamingSpaceStation) {
            if (keyID == 14) {
                if (this.renamingString != null && this.renamingString.length() > 0) {
                    String toBeParsed = this.renamingString.substring(0, this.renamingString.length() - 1);
                    this.renamingString = this.isValid(toBeParsed) ? toBeParsed : "";
                }
            } else if (keyChar == '\u0016') {
                String pastestring = GuiScreen.func_146277_j();
                if (pastestring == null) {
                    pastestring = "";
                }
                if (this.isValid(this.renamingString + pastestring)) {
                    this.renamingString = this.renamingString + pastestring;
                    this.renamingString = this.renamingString.substring(0, Math.min(String.valueOf(this.renamingString).length(), 32));
                }
            } else if (this.isValid(this.renamingString + keyChar)) {
                this.renamingString = this.renamingString + keyChar;
                this.renamingString = this.renamingString.substring(0, Math.min(this.renamingString.length(), 32));
            }
            return;
        }
        if (keyID == 28 && !this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d && this.currenttier >= this.tierneed && this.enableNewTierSystem) {
            if (this.canTravel) {
                this.enableTraveltime = true;
            } else {
                this.teleportToSelectedBody();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void teleportToSelectedBody() {
        if (this.selectedBody == null) return;
        if (!this.selectedBody.getReachable()) return;
        if (this.enableNewTierSystem) {
            if (this.currenttier < this.tierneed) return;
        } else {
            if (this.possibleBodies == null) return;
            if (!this.possibleBodies.contains(this.selectedBody)) return;
        }
        try {
            String dimension;
            int dimensionID;
            if (this.selectedBody instanceof Satellite) {
                if (this.spaceStationMap == null) {
                    GCLog.severe((String)"Please report as a BUG: spaceStationIDs was null.");
                    return;
                }
                Satellite selectedSatellite = (Satellite)this.selectedBody;
                Integer mapping = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(this.selectedStationOwner)).getStationDimensionID();
                if (mapping == null) {
                    GCLog.severe((String)("Problem matching player name in space station check: " + this.selectedStationOwner));
                    return;
                }
                dimensionID = mapping;
                WorldProvider spacestation = WorldUtil.getProviderForDimensionClient((int)dimensionID);
                if (spacestation == null) {
                    GCLog.severe((String)("Failed to find a spacestation with dimension " + dimensionID));
                    return;
                }
                dimension = "Space Station " + mapping;
            } else {
                dimensionID = this.selectedBody.getDimensionID();
                dimension = WorldUtil.getDimensionName((WorldProvider)WorldUtil.getProviderForDimensionClient((int)dimensionID));
            }
            if (dimension.contains("$")) {
                this.field_146297_k.field_71474_y.field_74320_O = 0;
            }
            AsmodeusCore.packetPipeline.sendToServer(new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.S_TELEPORT_ENTITY, GCCoreUtil.getDimensionID((World)this.field_146297_k.field_71441_e), dimensionID, this.fuelSet));
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCustomTeleporting(dimensionID));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void drawTransitBar(int length) {
        String str;
        int menuTopLeft = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        this.field_146297_k.field_71446_o.func_110577_a(guiMain2);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 113, menuTopLeft + 15, 225, 67, 0, 0, 225, 67, false, false);
        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 50, menuTopLeft + 57, 0 + length, 10, 269, 0, 138, 10, false, false);
        if (!(this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSurface) && this.field_146297_k.field_71439_g.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            CelestialBody body = ((IGalacticraftWorldProvider)this.field_146297_k.field_71439_g.field_70170_p.field_73011_w).getCelestialBody();
            this.drawBodyOnGUI(body, this.field_146294_l / 2 - 76, menuTopLeft + 54, 16, 16);
            str = GCCoreUtil.translate((String)body.getUnlocalizedName());
        } else {
            this.drawBodyOnGUI((CelestialBody)GalacticraftCore.planetOverworld, this.field_146294_l / 2 - 76, menuTopLeft + 54, 16, 16);
            str = GCCoreUtil.translate((String)GalacticraftCore.planetOverworld.getUnlocalizedName());
        }
        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - 105, GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 35, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        this.drawBodyOnGUI(this.selectedBody, this.field_146294_l / 2 + 59, menuTopLeft + 54, 16, 16);
        str = GCCoreUtil.translate((String)this.selectedBody.getUnlocalizedName());
        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 + 50, GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 35, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        str = "Boost: x" + this.coef;
        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - (this.field_146289_q.func_78256_a(str) - 25), GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 48, ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255));
        double time = this.traveltime - this.timer;
        str = (int)(time / 100.0) + "h " + (int)(time % 59.0) + "m";
        this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - (this.field_146289_q.func_78256_a(str) - 25), GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE + 59, ColorUtil.to32BitColor((int)255, (int)0, (int)255, (int)255));
        if (this.timer >= this.traveltime) {
            this.teleportToSelectedBody();
            this.enableTraveltime = false;
        }
    }

    protected int getScaledTravelTime(int barLength) {
        double relative = this.timer / this.traveltime;
        return (int)(relative * (double)barLength);
    }

    protected void drawBodyOnGUI(CelestialBody body, int x, int y, int w, int h) {
        if (body == null) {
            return;
        }
        this.field_146297_k.field_71446_o.func_110577_a(body.getBodyIcon());
        this.drawFullSizedTexturedRect(x, y, w, h);
    }

    public void drawFullSizedTexturedRect(int x, int y, int width, int height) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    protected boolean canCreateSpaceStation(CelestialBody atBody) {
        if (this.mapMode || ConfigManagerCore.disableSpaceStationCreation || !this.canCreateStations) {
            return false;
        }
        if (!atBody.getReachable() || (this.enableNewTierSystem ? this.currenttier < this.tierneed : this.possibleBodies != null && !this.possibleBodies.contains(atBody))) {
            return false;
        }
        boolean foundRecipe = false;
        for (SpaceStationType type : GalacticraftRegistry.getSpaceStationData()) {
            if (type.getWorldToOrbitID() != atBody.getDimensionID()) continue;
            foundRecipe = true;
        }
        if (!foundRecipe) {
            return false;
        }
        if (!ClientProxyCore.clientSpaceStationID.containsKey(atBody.getDimensionID())) {
            return true;
        }
        int resultID = (Integer)ClientProxyCore.clientSpaceStationID.get(atBody.getDimensionID());
        return resultID == 0 || resultID == -1;
    }

    protected List<CelestialBody> getChildren(Object object, int start, int size) {
        List<CelestialBody> bodies;
        ArrayList bodyList = Lists.newArrayList();
        SpaceData.refreshGalaxies();
        if (object instanceof Planet) {
            List moons = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                for (Object moon : moons) {
                    if (!UtilsGC.isReasearched(this.field_146297_k.field_71439_g, (CelestialBody)moon)) continue;
                    bodyList.add(moon);
                }
            } else {
                bodyList.addAll(moons);
            }
            bodies = SpaceData.getMoonsForPlanet((Planet)object);
            for (CelestialBody body : bodies) {
                if (!(body instanceof ICelestialRegistry) || !(body instanceof IChildBody)) continue;
                bodyList.add(body);
            }
        } else if (object instanceof SolarSystem) {
            List planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
            if (ACCompatibilityManager.isPlanetProgressionLoaded()) {
                for (Object planet : planets) {
                    if (!UtilsGC.isReasearched(this.field_146297_k.field_71439_g, (CelestialBody)planet)) continue;
                    bodyList.add(planet);
                }
            } else {
                bodyList.addAll(planets);
            }
            bodies = SpaceData.getBodiesForSolarSystem((SolarSystem)object);
            for (CelestialBody body : bodies) {
                if (!(body instanceof ICelestialRegistry) || body instanceof IChildBody) continue;
                bodyList.add(body);
            }
        }
        Collections.sort(bodyList);
        if (this.small_mode) {
            ArrayList doneList = Lists.newArrayList();
            int startPos = start;
            int getSize = size;
            if (startPos >= bodyList.size()) {
                startPos = 0;
            }
            if (getSize >= bodyList.size()) {
                getSize = bodyList.size();
            }
            for (int i = 0; i < getSize; ++i) {
                doneList.add(i, bodyList.get(i + startPos));
            }
            return doneList;
        }
        return bodyList;
    }

    protected static enum EnumView {
        PREVIEW,
        PROFILE,
        GS;

    }
}

