/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import nc.util.NCMath;
import net.minecraft.util.math.MathHelper;

public class UnitHelper {
    public static final String[] SI_PREFIX = new String[]{" y", " z", " a", " f", " p", " n", " u", " m", " ", " k", " M", " G", " T", " P", " E", " Z", " Y"};
    public static final String[] TIME_UNIT = new String[]{" ticks", " seconds", " minutes", " hours", " days", " weeks", " years"};
    public static final String[] TIME_UNIT_SHORT = new String[]{" t", " s", " min", " hr", " d", " wk", " y"};
    public static final double[] TIME_MULT = new double[]{1.0, 20.0, 1200.0, 72000.0, 1728000.0, 1.2096E7, 6.3072E8};

    public static String prefix(long value, long maxValue, int maxLength, String unit, int startingPrefixNo, int lowestPrefixNo) {
        double newMaxDouble;
        String sign;
        int minPrefixNumber = Math.max(lowestPrefixNo + 8, 0);
        int prefixNumber = MathHelper.func_76125_a((int)(startingPrefixNo + 8), (int)minPrefixNumber, (int)16);
        String maxVal = maxValue == -1L ? "" : " / " + maxValue;
        String string = sign = value > 0L ? "" : "-";
        if (value == 0L) {
            return value + maxVal + SI_PREFIX[prefixNumber] + unit;
        }
        double newDouble = (value > 0L ? 1.0 : -1.0) * (double)value;
        double d = newMaxDouble = maxValue == -1L ? newDouble : 1.0 * (double)maxValue;
        while (prefixNumber > minPrefixNumber) {
            newDouble = NCMath.magnitudeMult(newDouble, 3);
            newMaxDouble = NCMath.magnitudeMult(newMaxDouble, 3);
            if (!NCMath.atLongLimit((long)newDouble, 1000L) && !NCMath.atLongLimit((long)newMaxDouble, 1000L) && --prefixNumber != minPrefixNumber) continue;
        }
        int maxLengthFixed = Math.max(maxLength, 3);
        long newValue = (long)newDouble;
        long newMaxValue = (long)newMaxDouble;
        int length = NCMath.numberLength(newValue);
        while (prefixNumber < SI_PREFIX.length - 1) {
            length = NCMath.numberLength(newValue);
            if (length <= maxLengthFixed) {
                maxVal = maxValue == -1L ? "" : " / " + newMaxValue;
                return sign + newValue + maxVal + SI_PREFIX[prefixNumber] + unit;
            }
            newValue = NCMath.magnitudeMult(newValue, -3);
            newMaxValue = NCMath.magnitudeMult(newMaxValue, -3);
            ++prefixNumber;
        }
        maxVal = maxValue == -1L ? "" : " / " + NCMath.magnitudeMult(newMaxValue, -3);
        return sign + NCMath.magnitudeMult(newValue, -3) + maxVal + SI_PREFIX[SI_PREFIX.length - 1] + unit;
    }

    public static String prefix(long value, int maxLength, String unit, int startingPrefixNo, int lowestPrefixNo) {
        return UnitHelper.prefix(value, -1L, maxLength, unit, startingPrefixNo, lowestPrefixNo);
    }

    public static String prefix(long value, long maxValue, int maxLength, String unit, int startingPrefixNo) {
        return UnitHelper.prefix(value, maxValue, maxLength, unit, startingPrefixNo, startingPrefixNo);
    }

    public static String prefix(long value, int maxLength, String unit, int startingPrefixNo) {
        return UnitHelper.prefix(value, maxLength, unit, startingPrefixNo, startingPrefixNo);
    }

    public static String prefix(long value, long maxValue, int maxLength, String unit) {
        return UnitHelper.prefix(value, maxValue, maxLength, unit, 0);
    }

    public static String prefix(long value, int maxLength, String unit) {
        return UnitHelper.prefix(value, maxLength, unit, 0);
    }

    public static String ratePrefix(long perSecond, int maxLength, String unit, int startingPrefixNo) {
        boolean useTicks = perSecond % 20L == 0L;
        return UnitHelper.prefix(useTicks ? perSecond / 20L : perSecond, maxLength, unit + (useTicks ? "/t" : "/s"), startingPrefixNo);
    }

    public static String ratePrefix(long perSecond, int maxLength, String unit) {
        return UnitHelper.ratePrefix(perSecond, maxLength, unit, 0);
    }

    public static String prefix(double value, double maxValue, int maxLength, String unit, int startingPrefixNo, int lowestPrefixNo) {
        double newMax;
        String sign;
        int minPrefixNumber = Math.max(lowestPrefixNo + 8, 0);
        int prefixNumber = MathHelper.func_76125_a((int)(startingPrefixNo + 8), (int)minPrefixNumber, (int)16);
        String maxVal = maxValue == -1.0 ? "" : " / " + (long)maxValue;
        String string = sign = value > 0.0 ? "" : "-";
        if (value == 0.0) {
            return (long)value + maxVal + SI_PREFIX[prefixNumber] + unit;
        }
        value = (value > 0.0 ? 1.0 : -1.0) * value;
        double d = newMax = maxValue == -1.0 ? value : maxValue;
        while (prefixNumber > minPrefixNumber) {
            value = NCMath.magnitudeMult(value, 3);
            newMax = NCMath.magnitudeMult(newMax, 3);
            if (!NCMath.atDoubleLimit(value, 1000.0) && !NCMath.atDoubleLimit(newMax, 1000.0) && --prefixNumber != minPrefixNumber) continue;
        }
        int maxLengthFixed = Math.max(maxLength, 3);
        int length = NCMath.numberLength((long)value);
        while (prefixNumber < SI_PREFIX.length - 1) {
            length = NCMath.numberLength((long)value);
            if (length <= maxLengthFixed) {
                maxVal = maxValue == -1.0 ? "" : " / " + (long)newMax;
                return sign + (long)value + maxVal + SI_PREFIX[prefixNumber] + unit;
            }
            value = NCMath.magnitudeMult(value, -3);
            newMax = NCMath.magnitudeMult(newMax, -3);
            ++prefixNumber;
        }
        maxVal = maxValue == -1.0 ? "" : " / " + (long)NCMath.magnitudeMult(newMax, -3);
        return sign + (long)NCMath.magnitudeMult(value, -3) + maxVal + SI_PREFIX[SI_PREFIX.length - 1] + unit;
    }

    public static String prefix(double value, int maxLength, String unit, int startingPrefixNo, int lowestPrefixNo) {
        return UnitHelper.prefix(value, -1.0, maxLength, unit, startingPrefixNo, lowestPrefixNo);
    }

    public static String prefix(double value, double maxValue, int maxLength, String unit, int startingPrefixNo) {
        return UnitHelper.prefix(value, maxValue, maxLength, unit, startingPrefixNo, startingPrefixNo);
    }

    public static String prefix(double value, int maxLength, String unit, int startingPrefixNo) {
        return UnitHelper.prefix(value, maxLength, unit, startingPrefixNo, startingPrefixNo);
    }

    public static String prefix(double value, double maxValue, int maxLength, String unit) {
        return UnitHelper.prefix(value, maxValue, maxLength, unit, 0);
    }

    public static String prefix(double value, int maxLength, String unit) {
        return UnitHelper.prefix(value, maxLength, unit, 0);
    }

    public static String applyTimeUnit(long ticks, int maxLength) {
        return UnitHelper.applyTimeUnit(ticks, maxLength, 0);
    }

    public static String applyTimeUnit(double ticks, int maxLength) {
        return UnitHelper.applyTimeUnit(ticks, maxLength, 0);
    }

    public static String applyTimeUnit(long ticks, int maxLength, int startUnit) {
        int i = startUnit;
        while ((Math.round((double)ticks / TIME_MULT[i]) + "").length() > maxLength) {
            ++i;
        }
        return Math.round((double)ticks / TIME_MULT[i]) + TIME_UNIT[i];
    }

    public static String applyTimeUnit(double ticks, int maxLength, int startUnit) {
        int i = startUnit;
        while ((Math.round(ticks / TIME_MULT[i]) + "").length() > maxLength) {
            ++i;
        }
        return Math.round(ticks / TIME_MULT[i]) + TIME_UNIT[i];
    }

    public static String applyTimeUnitShort(long ticks, int maxLength) {
        return UnitHelper.applyTimeUnitShort(ticks, maxLength, 0);
    }

    public static String applyTimeUnitShort(double ticks, int maxLength) {
        return UnitHelper.applyTimeUnitShort(ticks, maxLength, 0);
    }

    public static String applyTimeUnitShort(long ticks, int maxLength, int startUnit) {
        int i = startUnit;
        while ((Math.round((double)ticks / TIME_MULT[i]) + "").length() > maxLength) {
            ++i;
        }
        return Math.round((double)ticks / TIME_MULT[i]) + TIME_UNIT_SHORT[i];
    }

    public static String applyTimeUnitShort(double ticks, int maxLength, int startUnit) {
        int i = startUnit;
        while ((Math.round(ticks / TIME_MULT[i]) + "").length() > maxLength) {
            ++i;
        }
        return Math.round(ticks / TIME_MULT[i]) + TIME_UNIT_SHORT[i];
    }
}

