/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.util.List;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.item.block.ItemBlockSpectreCoil;
import lumien.randomthings.lib.ILuminousBlock;
import lumien.randomthings.lib.IRTBlockColor;
import lumien.randomthings.tileentity.TileEntitySpectreCoil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpectreCoil
extends BlockContainerBase
implements ILuminousBlock,
IRTBlockColor {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.90625, 0.6875, 0.6875, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.09375);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.90625, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.09375, 0.6875, 0.6875);
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.09375, 0.6875);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.3125, 0.90625, 0.3125, 0.6875, 1.0, 0.6875);
    CoilType coilType;

    protected BlockSpectreCoil(CoilType type) {
        super("spectreCoil_" + type.name, Material.field_151576_e, ItemBlockSpectreCoil.class);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149711_c(0.3f);
        this.coilType = type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        String display;
        switch (this.coilType) {
            case NORMAL: {
                display = I18n.func_135052_a((String)"tile.spectrecoil.transfer", (Object[])new Object[]{"1024"});
                break;
            }
            case REDSTONE: {
                display = I18n.func_135052_a((String)"tile.spectrecoil.transfer", (Object[])new Object[]{"4096"});
                break;
            }
            case ENDER: {
                display = I18n.func_135052_a((String)"tile.spectrecoil.transfer", (Object[])new Object[]{"20480"});
                break;
            }
            case GENESIS: {
                display = I18n.func_135052_a((String)"tile.spectrecoil.generate", (Object[])new Object[]{"Infinite"});
                break;
            }
            case NUMBER: {
                display = I18n.func_135052_a((String)"tile.spectrecoil.generate", (Object[])new Object[]{Numbers.NUMBERED_SPECTRECOIL_ENERGY + ""});
                break;
            }
            default: {
                display = I18n.func_135052_a((String)"tile.spectrecoil.transfer", (Object[])new Object[]{"???"});
            }
        }
        tooltip.add(display);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySpectreCoil(this.coilType);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockSpectreCoil.func_181088_a(worldIn, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockSpectreCoil.func_181088_a(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean func_181088_a(World p_181088_0_, BlockPos p_181088_1_, EnumFacing p_181088_2_) {
        return p_181088_2_ == EnumFacing.DOWN && BlockSpectreCoil.isBlockEnergyStorage(p_181088_0_, p_181088_1_.func_177977_b(), p_181088_2_) ? true : BlockSpectreCoil.isBlockEnergyStorage(p_181088_0_, p_181088_1_.func_177972_a(p_181088_2_), p_181088_2_);
    }

    private static boolean isBlockEnergyStorage(World worldObj, BlockPos pos, EnumFacing facing) {
        TileEntity te = worldObj.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        return te.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || te.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return BlockSpectreCoil.func_181088_a(worldIn, pos, facing.func_176734_d()) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        if (this.checkForDrop(worldIn, pos, state) && !BlockSpectreCoil.func_181088_a(worldIn, pos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EntityPlayer player;
        GameProfile profile;
        if (!worldIn.field_72995_K && placer instanceof EntityPlayer && (profile = (player = (EntityPlayer)placer).func_146103_bH()) != null) {
            TileEntitySpectreCoil coil = (TileEntitySpectreCoil)worldIn.func_175625_s(pos);
            coil.setOwner(profile.getId());
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (enumfacing) {
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return UP_AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public boolean shouldGlow(IBlockState state, int tintIndex) {
        return true;
    }

    @Override
    public int colorMultiplier(IBlockState state, IBlockAccess p_186720_2_, BlockPos pos, int tintIndex) {
        return this.coilType.color;
    }

    public static enum CoilType {
        NORMAL("normal", Color.CYAN.getRGB()),
        REDSTONE("redstone", Color.RED.getRGB()),
        ENDER("ender", new Color(200, 0, 210).getRGB()),
        NUMBER("number", Color.GREEN.getRGB()),
        GENESIS("genesis", Color.ORANGE.getRGB());

        int color;
        String name;

        private CoilType(String name, int color) {
            this.name = name;
            this.color = color;
        }
    }
}

