/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.ModuleCore;
import forestry.core.fluids.Fluids;
import forestry.farming.FarmRegistry;
import forestry.modules.ModuleHelper;
import forestry.plugins.CompatPlugin;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry_compat", moduleID="biomes.o.plenty", name="BiomesOPlenty", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.biomesoplenty.description")
public class PluginBiomesOPlenty
extends CompatPlugin {
    public PluginBiomesOPlenty() {
        super("BiomesOPlenty", "biomesoplenty");
    }

    @Override
    public void doInit() {
        if (ModuleHelper.isEnabled("apiculture")) {
            this.addFlowers();
        }
        if (ModuleHelper.isEnabled("farming")) {
            this.addFarmCrops();
        }
    }

    @Override
    public void registerRecipes() {
        int amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        if (ModuleHelper.isEnabled("factory")) {
            this.addSqueezerRecipes();
        }
    }

    private void addFarmCrops() {
        FarmRegistry registry = FarmRegistry.getInstance();
    }

    private void addSqueezerRecipes() {
        String[] fruits;
        ItemStack mulch = new ItemStack((Item)ModuleCore.getItems().mulch);
        FluidStack juice = Fluids.JUICE.getFluid(200);
        if (juice == null) {
            return;
        }
        for (String fruit : fruits = new String[]{"persommon", "berries", "peach", "pear"}) {
            ItemStack fruitStack = this.getItemStack(fruit);
            if (fruitStack == null) continue;
            RecipeManagers.squeezerManager.addRecipe(10, fruitStack, juice, mulch, 20);
        }
    }

    private void addFlowers() {
        Block plant_1;
        Block mushroom;
        Block flower_1;
        Block flower_0 = this.getBlock("flower_0");
        IFlowerRegistry registry = FlowerManager.flowerRegistry;
        if (flower_0 != null) {
            registry.registerPlantableFlower(flower_0.func_176203_a(0), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(1), 1.0, "flowersVanilla", "flowersSnow", "flowersMushrooms");
            registry.registerPlantableFlower(flower_0.func_176203_a(2), 1.0, "flowersNether");
            registry.registerPlantableFlower(flower_0.func_176203_a(3), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(4), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(5), 1.0, "flowersVanilla", "flowersSnow", "flowersJungle");
            registry.registerPlantableFlower(flower_0.func_176203_a(6), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(7), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(8), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(9), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(10), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(11), 1.0, "flowersCacti");
            registry.registerPlantableFlower(flower_0.func_176203_a(12), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(13), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(14), 1.0, "flowersVanilla", "flowersSnow");
            registry.registerPlantableFlower(flower_0.func_176203_a(15), 1.0, "flowersNether");
        }
        if ((flower_1 = this.getBlock("flower_1")) != null) {
            for (int i = 0; i < 6; ++i) {
                registry.registerPlantableFlower(flower_1.func_176203_a(i), 1.0, "flowersVanilla", "flowersSnow");
            }
        }
        if ((mushroom = this.getBlock("mushroom")) != null) {
            for (int i = 0; i < 6; ++i) {
                registry.registerPlantableFlower(mushroom.func_176203_a(i), 1.0, "flowersMushrooms");
            }
            registry.registerPlantableFlower(mushroom.func_176203_a(3), 1.0, "flowersNether");
        }
        if ((plant_1 = this.getBlock("plant_1")) != null) {
            registry.registerPlantableFlower(plant_1.func_176203_a(6), 1.0, "flowersCacti");
        }
    }

    @Override
    public void registerBackpackItems() {
        this.addBlocksToBackpack("forestry.digger", "grass", "dirt", "sandstone", "dried_sand", "mud", "ash_block");
    }
}

