/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.lang.reflect.Type;

public class ColorTypeAdapter
implements JsonDeserializer<Color>,
JsonSerializer<Color> {
    public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        String value = json.getAsString();
        if (!value.startsWith("#")) {
            value = "#" + value;
        }
        return Color.decode(value);
    }

    public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(String.format("#%02x%02x%02x", src.getRed(), src.getGreen(), src.getBlue()));
    }
}

