/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.OpenBlocks;

@Mod.EventBusSubscriber
public class LootHandler {
    private static final Map<ResourceLocation, LootInjection> injections = ImmutableMap.of((Object)LootHandler.mc("chests/abandoned_mineshaft"), (Object)new TechnicolorGlassesLootInjection(), (Object)LootHandler.mc("chests/simple_dungeon"), (Object)new TechnicolorGlassesLootInjection());

    private static ResourceLocation mc(String location) {
        return new ResourceLocation("minecraft", location);
    }

    public static void register() {
        HashSet alreadyRegistered = Sets.newHashSet();
        for (LootInjection injection : injections.values()) {
            if (!injection.canInject() || !alreadyRegistered.add(injection.location)) continue;
            LootTableList.func_186375_a((ResourceLocation)injection.location);
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent evt) {
        LootInjection injection = injections.get(evt.getName());
        if (injection != null && injection.canInject()) {
            evt.getTable().addPool(LootHandler.createPool(injection.location));
        }
    }

    private static LootPool createPool(ResourceLocation injectionEntry) {
        return new LootPool(new LootEntry[]{LootHandler.loadEntry(injectionEntry)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "openmods_inject_pool");
    }

    private static LootEntry loadEntry(ResourceLocation injectionEntry) {
        return new LootEntryTable(injectionEntry, 1, 0, new LootCondition[0], "openmods_inject_entry");
    }

    private static class TechnicolorGlassesLootInjection
    extends LootInjection {
        public TechnicolorGlassesLootInjection() {
            super(OpenBlocks.location("inject/technicolor_glasses"));
        }

        @Override
        public boolean canInject() {
            return Config.technicolorGlassesLoot && OpenBlocks.Items.technicolorGlasses != null;
        }
    }

    private static class LootInjection {
        private final ResourceLocation location;

        public LootInjection(ResourceLocation location) {
            this.location = location;
        }

        public boolean canInject() {
            return true;
        }
    }
}

