/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.core.gc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import net.romvoid95.api.config.def.ValidDimIDs;
import net.romvoid95.galactic.GalacticTweaks;
import net.romvoid95.galactic.modules.galacticraft.GalacticraftModuleConfig;

public class IOWriter {
    private final List<CelestialBody> planets = GalaxyRegistry.getRegisteredPlanets().values().stream().filter(CelestialBody::getReachable).sorted().collect(Collectors.toList());
    private final List<CelestialBody> moons = GalaxyRegistry.getRegisteredMoons().values().stream().filter(CelestialBody::getReachable).sorted().collect(Collectors.toList());
    public static List<CelestialBody> allBodies = new ArrayList<CelestialBody>();
    public static Map<String, CelestialBody> bodies = new HashMap<String, CelestialBody>();
    private PrintWriter writer;

    public IOWriter() {
        ArrayList<String> all = new ArrayList<String>();
        this.planets.forEach(p -> {
            allBodies.add((CelestialBody)p);
            all.add(p.getName().replace(" ", "_"));
        });
        this.moons.forEach(m -> {
            allBodies.add((CelestialBody)m);
            all.add(m.getName().replace(" ", "_"));
        });
        for (CelestialBody body : allBodies) {
            bodies.put(body.getName(), body);
        }
        GalacticraftModuleConfig.validSPawnDims = new ValidDimIDs(all);
    }

    public void handleFile(String name) {
        File dims = new File(GalacticTweaks.modFolder, name);
        try {
            if (dims.exists()) {
                dims.delete();
            }
            dims.createNewFile();
            this.writer = new PrintWriter(new FileWriter(dims));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(String string) {
        this.writer.println(string);
    }

    public void nl() {
        this.writer.println("");
    }

    public void spacer() {
        this.writer.println("|------------------");
    }

    public void NOTICE() {
        this.writer.println("### NOTICE ###");
    }

    public void title(String title) {
        this.nl();
        this.nl();
        this.writer.println("| ### " + title + " ###");
        this.writer.println("|------------------");
    }

    public void writePlanets() {
        Collections.sort(this.planets);
        this.planets.forEach(planet -> this.writer.println(this.formatted((CelestialBody)planet)));
    }

    public void writeMoons() {
        Collections.sort(this.moons);
        this.moons.forEach(moon -> this.writer.println(this.formatted((CelestialBody)moon)));
    }

    public void finalize() {
        this.writer.flush();
        this.writer.close();
    }

    private String formatted(CelestialBody body) {
        return String.format("| %-15s %15s", body.getName(), body.getDimensionID());
    }
}

