/*
 * Decompiled with CFR 0.152.
 */
package openmods.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import openmods.utils.CollectionUtils;

public class EnchantingRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final IRecipe source;
    private final List<EnchantmentData> enchantments;

    public EnchantingRecipe(IRecipe source, List<EnchantmentData> enchantments) {
        this.source = source;
        this.enchantments = ImmutableList.copyOf(enchantments);
    }

    private ItemStack enchantItem(ItemStack output) {
        if (output == null) {
            return null;
        }
        if (output.func_77973_b() == Items.field_151122_aG) {
            NBTTagCompound originalTag = output.func_77978_p();
            output = new ItemStack(Items.field_151134_bR);
            output.func_77982_d(originalTag != null ? originalTag.func_74737_b() : null);
            for (EnchantmentData e : this.enchantments) {
                ItemEnchantedBook.func_92115_a((ItemStack)output, (EnchantmentData)e);
            }
        } else if (output.func_77973_b() == Items.field_151134_bR) {
            for (EnchantmentData e : this.enchantments) {
                ItemEnchantedBook.func_92115_a((ItemStack)output, (EnchantmentData)e);
            }
        } else {
            for (EnchantmentData e : this.enchantments) {
                output.func_77966_a(e.field_76302_b, e.field_76303_c);
            }
        }
        return output;
    }

    public ItemStack func_77571_b() {
        return this.enchantItem(this.source.func_77571_b());
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.enchantItem(this.source.func_77572_b(inv));
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.source.func_77569_a(inv, worldIn);
    }

    public boolean func_194133_a(int width, int height) {
        return this.source.func_194133_a(width, height);
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return this.source.func_179532_b(inv);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.source.func_192400_c();
    }

    public boolean func_192399_d() {
        return this.source.func_192399_d();
    }

    public String func_193358_e() {
        return this.source.func_193358_e();
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            JsonObject sourceData = JsonUtils.func_152754_s((JsonObject)json, (String)"source");
            IRecipe source = CraftingHelper.getRecipe((JsonObject)sourceData, (JsonContext)context);
            HashMap enchantmentMap = Maps.newHashMap();
            JsonObject enchData = JsonUtils.func_152754_s((JsonObject)json, (String)"enchantments");
            for (Map.Entry e : enchData.entrySet()) {
                ResourceLocation enchId = new ResourceLocation((String)e.getKey());
                int enchLevel = ((JsonElement)e.getValue()).getAsInt();
                CollectionUtils.putOnce(enchantmentMap, enchId, enchLevel);
            }
            ArrayList enchantments = Lists.newArrayList();
            for (Map.Entry e : enchantmentMap.entrySet()) {
                ResourceLocation enchId = (ResourceLocation)e.getKey();
                Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)enchId);
                Preconditions.checkNotNull((Object)ench, (String)"Unknown enchantment: %s", (Object)enchId);
                enchantments.add(new EnchantmentData(ench, ((Integer)e.getValue()).intValue()));
            }
            return new EnchantingRecipe(source, enchantments);
        }
    }

    public static class Condition
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            String enchId = JsonUtils.func_151200_h((JsonObject)json, (String)"id");
            return () -> Enchantment.field_185264_b.func_148741_d((Object)new ResourceLocation(enchId));
        }
    }
}

