/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.handler;

import asmodeuscore.api.dimension.IProviderFog;
import asmodeuscore.core.event.AsmodeusClientEvent;
import asmodeuscore.core.utils.Utils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProviderFogHandler {
    private static double fogX;
    private static double fogZ;
    private static boolean fogInit;
    private static float fogFarPlaneDistance;
    private static float newFogDensity;
    private static float fogDensity;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGetFogColour(EntityViewRenderEvent.FogColors event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            World world = player.field_70170_p;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            IBlockState blockAtEyes = ActiveRenderInfo.func_186703_a((World)world, (Entity)event.getEntity(), (float)((float)event.getRenderPartialTicks()));
            if (blockAtEyes.func_185904_a() == Material.field_151587_i) {
                return;
            }
            Vec3d mixedColor = blockAtEyes.func_185904_a() == Material.field_151586_h ? ProviderFogHandler.getFogBlendColorWater(world, (EntityLivingBase)player, x, y, z, event.getRenderPartialTicks()) : ProviderFogHandler.getFogBlendColour(world, (EntityLivingBase)player, x, y, z, event.getRed(), event.getGreen(), event.getBlue(), event.getRenderPartialTicks());
            float temp = (float)(player.field_70163_u / 700.0) % 255.0f;
            float r = (float)(mixedColor.field_72450_a - (double)temp < 0.0 ? 0.0 : mixedColor.field_72450_a - (double)temp);
            float g = (float)(mixedColor.field_72448_b - (double)temp < 0.0 ? 0.0 : mixedColor.field_72448_b - (double)temp);
            float b = (float)(mixedColor.field_72449_c - (double)temp < 0.0 ? 0.0 : mixedColor.field_72449_c - (double)temp);
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
        }
    }

    @SubscribeEvent
    public void renderFog(EntityViewRenderEvent.RenderFogEvent event) {
        World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
        WorldProvider provider = world.field_73011_w;
        if (provider instanceof IProviderFog) {
            float sandstormFog = 1.0f;
            IProviderFog providerAtum = (IProviderFog)provider;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
            int playerY = MathHelper.func_76128_c((double)player.field_70163_u);
            int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
            float fogDensity = 1.0f - providerAtum.getFogDensity(playerX, playerY, playerZ);
            if (event.getEntity() instanceof EntityPlayer) {
                if (fogDensity == 0.0f) {
                    GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
                } else {
                    GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                }
                ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
                fogDensity *= sandstormFog - (sandstormFog - sandstormFog * 1.0f);
                int light = player.field_70170_p.func_175642_b(EnumSkyBlock.SKY, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
                if (light < 12) {
                    fogDensity = light <= 0 ? 0.001f : (fogDensity /= (float)((12 - light) * 2));
                }
                fogDensity = (float)((double)fogDensity / (player.field_70163_u / 30.0));
                if (AsmodeusClientEvent.inOxygenBlock) {
                    fogDensity = 0.05f;
                }
                GlStateManager.func_179095_a((float)fogDensity);
            }
        }
    }

    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode < 0) {
            GlStateManager.func_179102_b((float)0.0f);
            GlStateManager.func_179153_c((float)farPlaneDistance);
        } else {
            GlStateManager.func_179102_b((float)(farPlaneDistance * farPlaneDistanceScale));
            GlStateManager.func_179153_c((float)farPlaneDistance);
        }
    }

    private static Vec3d postProcessColor(World world, EntityLivingBase player, float r, float g, float b, double renderPartialTicks) {
        int duration;
        double darkScale = (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * renderPartialTicks) * world.field_73011_w.func_76565_k();
        if (player.func_70644_a(MobEffects.field_76440_q)) {
            duration = player.func_70660_b(MobEffects.field_76440_q).func_76459_b();
            darkScale *= duration < 20 ? (double)(1.0f - (float)duration / 20.0f) : 0.0;
        }
        if (darkScale < 1.0) {
            darkScale = darkScale < 0.0 ? 0.0 : darkScale * darkScale;
            r = (float)((double)r * darkScale);
            g = (float)((double)g * darkScale);
            b = (float)((double)b * darkScale);
        }
        if (player.func_70644_a(MobEffects.field_76439_r)) {
            duration = player.func_70660_b(MobEffects.field_76439_r).func_76459_b();
            float brightness = duration > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)((float)(((double)duration - renderPartialTicks) * Math.PI * (double)0.2f))) * 0.3f;
            float scale = 1.0f / r;
            scale = Math.min(scale, 1.0f / g);
            scale = Math.min(scale, 1.0f / b);
            r = r * (1.0f - brightness) + r * scale * brightness;
            g = g * (1.0f - brightness) + g * scale * brightness;
            b = b * (1.0f - brightness) + b * scale * brightness;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            float aR = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float aG = (r * 30.0f + g * 70.0f) / 100.0f;
            float aB = (r * 30.0f + b * 70.0f) / 100.0f;
            r = aR;
            g = aG;
            b = aB;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    private static Vec3d getFogBlendColorWater(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, double renderPartialTicks) {
        int distance = 2;
        float rBiomeFog = 0.0f;
        float gBiomeFog = 0.0f;
        float bBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                Biome biome = world.getBiomeForCoordsBody(new BlockPos((double)(playerX + x), playerEntity.field_70163_u, (double)(playerZ + z)));
                int waterColorMult = biome.getWaterColorMultiplier();
                float rPart = (waterColorMult & 0xFF0000) >> 16;
                float gPart = (waterColorMult & 0xFF00) >> 8;
                float bPart = waterColorMult & 0xFF;
                if (x == -distance) {
                    xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                } else if (x == distance) {
                    xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                }
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
            }
        }
        float weight = distance * 2 * distance * 2;
        float respirationLevel = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)playerEntity) * 0.2f;
        float rMixed = ((rBiomeFog /= 255.0f) * 0.02f + respirationLevel) / weight;
        float gMixed = ((gBiomeFog /= 255.0f) * 0.02f + respirationLevel) / weight;
        float bMixed = ((bBiomeFog /= 255.0f) * 0.2f + respirationLevel) / weight;
        return ProviderFogHandler.postProcessColor(world, playerEntity, rMixed, gMixed, bMixed, renderPartialTicks);
    }

    private static Vec3d getFogBlendColour(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, float defR, float defG, float defB, double renderPartialTicks) {
        float thunderStrength;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 6;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        float rBiomeFog = 0.0f;
        float gBiomeFog = 0.0f;
        float bBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                WorldProvider provider = world.field_73011_w;
                if (!(provider instanceof IProviderFog)) continue;
                IProviderFog biomeFog = (IProviderFog)provider;
                Vec3d fogColor = provider.func_76562_b((float)renderPartialTicks, 0.0f);
                int fogColour = Utils.getIntColor(Math.round((float)fogColor.field_72450_a * 255.0f), Math.round((float)fogColor.field_72448_b * 255.0f), Math.round((float)fogColor.field_72449_c * 255.0f));
                float rPart = (fogColour & 0xFF0000) >> 16;
                float gPart = (fogColour & 0xFF00) >> 8;
                float bPart = fogColour & 0xFF;
                float weightPart = 1.0f;
                if (x == -distance) {
                    double xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    double xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                float temp = (float)(playerEntity.field_70163_u / 1000.0);
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
                weightBiomeFog += weightPart;
            }
        }
        if (weightBiomeFog == 0.0f || distance == 0) {
            return new Vec3d((double)defR, (double)defG, (double)defB);
        }
        rBiomeFog /= 255.0f;
        gBiomeFog /= 255.0f;
        bBiomeFog /= 255.0f;
        float celestialAngle = world.func_72826_c((float)renderPartialTicks);
        float baseScale = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float rScale = baseScale * 0.94f + 0.06f;
        float gScale = baseScale * 0.94f + 0.06f;
        float bScale = baseScale * 0.91f + 0.09f;
        float rainStrength = world.func_72867_j((float)renderPartialTicks);
        if (rainStrength > 0.0f) {
            rScale *= 1.0f - rainStrength * 0.5f;
            gScale *= 1.0f - rainStrength * 0.5f;
            bScale *= 1.0f - rainStrength * 0.4f;
        }
        if ((thunderStrength = world.func_72819_i((float)renderPartialTicks)) > 0.0f) {
            rScale *= 1.0f - thunderStrength * 0.5f;
            gScale *= 1.0f - thunderStrength * 0.5f;
            bScale *= 1.0f - thunderStrength * 0.5f;
        }
        Vec3d processedColor = ProviderFogHandler.postProcessColor(world, playerEntity, rBiomeFog *= rScale / weightBiomeFog, gBiomeFog *= gScale / weightBiomeFog, bBiomeFog *= bScale / weightBiomeFog, renderPartialTicks);
        rBiomeFog = (float)processedColor.field_72450_a;
        gBiomeFog = (float)processedColor.field_72448_b;
        bBiomeFog = (float)processedColor.field_72449_c;
        float weightMixed = distance * 2 * distance * 2;
        float weightDefault = weightMixed - weightBiomeFog;
        double x = (rBiomeFog * weightBiomeFog + defR * weightDefault) / weightMixed;
        double y = (gBiomeFog * weightBiomeFog + defG * weightDefault) / weightMixed;
        double z = (bBiomeFog * weightBiomeFog + defB * weightDefault) / weightMixed;
        return new Vec3d(x, y, z);
    }

    static {
        fogDensity = 1.0f;
    }
}

