/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine2.world.gen;

import asmodeuscore.core.utils.Utils;
import asmodeuscore.core.utils.worldengine2.world.biome.WE_Biome;
import asmodeuscore.core.utils.worldengine2.world.biome.WE_BiomeProvider;
import asmodeuscore.core.utils.worldengine2.world.gen.custom.abstracts.WE_GenData;
import asmodeuscore.core.utils.worldengine2.world.properties.WE_IWorldProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WE_ChunkProvider
implements IChunkGenerator {
    private WE_IWorldProperties properties;
    private World world;

    public WE_ChunkProvider(World w, WE_IWorldProperties p) {
        this.world = w;
        this.properties = p;
    }

    public WE_IWorldProperties getProperties() {
        return this.properties;
    }

    public World getWorld() {
        return this.world;
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(chunkX, chunkZ, primer);
        WE_BiomeProvider p = (WE_BiomeProvider)this.world.func_72959_q();
        WE_Biome[][] biomes = new WE_Biome[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                biomes[x][z] = WE_BiomeProvider.smart.get((long)chunkX | (long)x, (long)chunkZ | (long)z);
            }
        }
        int[][][] rData = new int[16][16][p.properties.sizeofReliefLayers() + 1];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int i = 0; i < p.properties.sizeofCreateChunkGenInXZ(); ++i) {
                    p.properties.getCreateChunkGenInXZ(i).generate(new WE_GenData(this, this.world, primer, chunkX, chunkZ, biomes, rData, x, 0, z));
                }
            }
        }
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] arraybiome = new byte[256];
        Arrays.fill(arraybiome, (byte)Biome.func_185362_a((Biome)Utils.WE_Biome_2));
        chunk.func_76616_a(arraybiome);
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        for (int i = 0; i < 4; ++i) {
            for (int l = 0; l < 4; ++l) {
                for (int i2 = 0; i2 < 32; ++i2) {
                    for (int j2 = 0; j2 < 8; ++j2) {
                        for (int k2 = 0; k2 < 4; ++k2) {
                            for (int l2 = 0; l2 < 4; ++l2) {
                                if (i2 * 8 + j2 >= 64) continue;
                            }
                        }
                    }
                }
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int x = chunkX << 4;
        int z = chunkZ << 4;
        boolean flag = false;
        this.world.field_73012_v.setSeed((long)chunkX * 434673L * this.world.field_73012_v.nextLong() + (long)chunkZ * 585694L * this.world.field_73012_v.nextLong() + 745849494845L);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.world, this.world.field_73012_v, chunkX, chunkZ, flag));
        WE_BiomeProvider p = (WE_BiomeProvider)this.world.func_72959_q();
        WE_Biome[][] biomes = new WE_Biome[16][16];
        for (int xX = 0; xX < 16; ++xX) {
            for (int zZ = 0; zZ < 16; ++zZ) {
                biomes[xX][zZ] = WE_BiomeProvider.smart.get((long)chunkX | (long)xX, (long)chunkZ | (long)zZ);
            }
        }
        for (int i = 0; i < p.properties.sizeofDecorateChunkGen(); ++i) {
            p.properties.getDecorateChunkGen(i).generate(this.world.field_73012_v, x, z, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        }
        WE_Biome r = biomes[this.world.field_73012_v.nextInt(16)][this.world.field_73012_v.nextInt(16)];
        for (int i = 0; i < r.properties.sizeofDecorateChunkGen(); ++i) {
            r.properties.getDecorateChunkGen(i).generate(this.world.field_73012_v, x, z, this.world, (IChunkGenerator)this, this.world.func_72863_F());
        }
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)r, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.world.field_73012_v);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.world, this.world.field_73012_v, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        WE_Biome biome = (WE_Biome)this.world.func_72959_q().func_180631_a(pos);
        if (biome != null) {
            return biome.func_76747_a(creatureType);
        }
        return null;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }
}

