/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.model;

import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.phantamanta44.libnine.client.model.L9Models;
import io.github.phantamanta44.libnine.client.model.ParameterizedItemModel;
import io.github.phantamanta44.libnine.util.helper.ResourceUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;

public class ParameterizedItemModelLoader
implements ICustomModelLoader {
    private final ResourceInjector resourceInjector = new ResourceInjector();

    public ParameterizedItemModelLoader() {
        Minecraft.func_71410_x().field_110449_ao.add(this.resourceInjector);
    }

    public boolean accepts(ResourceLocation resource) {
        return L9Models.isOfType(L9Models.getRealModelLocation(resource), "pi");
    }

    public IModel loadModel(ResourceLocation resource) throws Exception {
        JsonObject model = ResourceUtils.getAsJson(L9Models.getRealModelLocation(resource)).getAsJsonObject();
        JsonObject archetype = model.getAsJsonObject("archetype");
        if (archetype == null) {
            throw new NoSuchElementException("No archetype for PI model: " + resource);
        }
        JsonObject mutations = model.getAsJsonObject("mutations");
        Table mutationTable = null;
        if (mutations != null) {
            mutationTable = Tables.newCustomTable(new HashMap(), HashMap::new);
            for (Map.Entry mKey : mutations.entrySet()) {
                for (Map.Entry mValue : ((JsonElement)mKey.getValue()).getAsJsonObject().entrySet()) {
                    mutationTable.put(mKey.getKey(), mValue.getKey(), mValue.getValue());
                }
            }
        }
        return new ParameterizedItemModel(this.resourceInjector, archetype, (Table<String, String, JsonElement>)mutationTable);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceInjector.flush();
    }

    static class ResourceInjector
    implements IResourcePack {
        private static final String RESOURCE_DOMAIN = "libnine_pi";
        private static final Set<String> RESOURCE_DOMAINS = Sets.newHashSet((Object[])new String[]{"libnine_pi"});
        private final Map<String, String> resources = new HashMap<String, String>();
        private long resourceIndex = 0L;

        ResourceInjector() {
        }

        public InputStream func_110590_a(ResourceLocation location) throws IOException {
            String resource = this.resources.get(location.func_110623_a());
            if (resource == null) {
                throw new FileNotFoundException("Unknown PI resource: " + location.func_110623_a());
            }
            return new ByteArrayInputStream(resource.getBytes(StandardCharsets.UTF_8));
        }

        public boolean func_110589_b(ResourceLocation location) {
            return this.resources.containsKey(location.func_110623_a());
        }

        public Set<String> func_110587_b() {
            return RESOURCE_DOMAINS;
        }

        @Nullable
        public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) {
            return null;
        }

        public BufferedImage func_110586_a() throws IOException {
            return TextureUtil.func_177053_a((InputStream)this.func_110590_a(new ResourceLocation("textures/misc/unknown_pack.png")));
        }

        public String func_130077_b() {
            return "libnine magic pi pack";
        }

        ResourceLocation injectResource(String resource) {
            this.resources.put("models/" + this.resourceIndex + ".json", resource);
            return new ResourceLocation(RESOURCE_DOMAIN, Long.toString(this.resourceIndex++));
        }

        void flush() {
            this.resources.clear();
        }
    }
}

