/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.machine;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.machine.JSGMachineBlock;
import tauri.dev.jsg.gui.GuiIdEnum;
import tauri.dev.jsg.item.machine.MachineItemBlock;
import tauri.dev.jsg.renderer.machine.OreWashingRenderer;
import tauri.dev.jsg.tileentity.machine.OreWashingTile;

public class OreWashingBlock
extends JSGMachineBlock {
    public static final String BLOCK_NAME = "ore_washing_machine_block";
    public static final int MAX_ENERGY = 9000000;
    public static final int MAX_ENERGY_TRANSFER = 20000;
    public static final int FLUID_CAPACITY = 15000;

    public OreWashingBlock() {
        super(BLOCK_NAME);
    }

    @Override
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new OreWashingTile();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return OreWashingTile.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntitySpecialRenderer<? extends TileEntity> getTESR() {
        return new OreWashingRenderer();
    }

    @Override
    protected void showGui(EntityPlayer player, EnumHand hand, World world, BlockPos pos) {
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, null)) {
            return;
        }
        player.openGui((Object)JSG.instance, GuiIdEnum.GUI_ORE_WASHING.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        OreWashingTile tile;
        if (!world.field_72995_K && (tile = (OreWashingTile)world.func_175625_s(pos)) != null) {
            tile.onBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public ItemBlock getItemBlock() {
        return new MachineItemBlock(this, BLOCK_NAME, 9000000);
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean renderHighlight(IBlockState state) {
        return false;
    }
}

