/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block.props;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.block.JSGBlock;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.gui.GuiIdEnum;
import tauri.dev.jsg.renderer.props.DestinyCountDownRenderer;
import tauri.dev.jsg.tileentity.props.DestinyCountDownTile;
import tauri.dev.jsg.tileentity.stargate.StargateUniverseBaseTile;
import tauri.dev.jsg.util.main.JSGProps;

public class DestinyCountDownBlock
extends JSGBlock {
    private static final String BLOCK_NAME = "destiny_countdown_block";

    public DestinyCountDownBlock() {
        super(Material.field_151573_f);
        this.setRegistryName("jsg:destiny_countdown_block");
        this.func_149663_c("jsg.destiny_countdown_block");
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(JSGCreativeTabsHandler.JSG_PROPS_CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.NORTH));
        this.func_149715_a(0.33333334f);
        this.func_149711_c(2.5f);
        this.func_149752_b(15.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public boolean func_180639_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            player.openGui((Object)JSG.instance, GuiIdEnum.GUI_COUNTDOWN.id, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return !player.func_70093_af();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{JSGProps.FACING_HORIZONTAL});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public void func_180633_a(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        state = state.func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing);
        world.func_175656_a(pos, state);
        DestinyCountDownTile tile = (DestinyCountDownTile)world.func_175625_s(pos);
        if (tile != null) {
            tile.updateLinkStatus();
        }
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        StargateUniverseBaseTile gateTile;
        DestinyCountDownTile tile = (DestinyCountDownTile)world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && (gateTile = tile.getLinkedGate(world)) != null) {
            gateTile.setLinkedCountdown(null, -1);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_176198_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return super.func_176198_a(worldIn, pos, side) && JSGProps.FACING_HORIZONTAL.func_177700_c().contains(side);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)JSGProps.FACING_HORIZONTAL, (Comparable)facing);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos) {
        EnumFacing backFacing = ((EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)).func_176734_d();
        if (world.func_175623_d(pos.func_177972_a(backFacing))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new DestinyCountDownTile();
    }

    @Override
    public Class<? extends TileEntity> getTileEntityClass() {
        return DestinyCountDownTile.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TileEntitySpecialRenderer<? extends TileEntity> getTESR() {
        return new DestinyCountDownRenderer();
    }

    @Override
    public boolean renderHighlight(IBlockState blockState) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149730_j(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)) {
            case NORTH: {
                return new AxisAlignedBB(-0.1, 0.2, 0.9, 1.1, 0.8, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(-0.1, 0.2, 0.0, 1.1, 0.8, 0.1);
            }
            case WEST: {
                return new AxisAlignedBB(0.9, 0.2, -0.1, 1.0, 0.8, 1.1);
            }
        }
        return new AxisAlignedBB(0.0, 0.2, -0.1, 0.1, 0.8, 1.1);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        switch ((EnumFacing)blockState.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL)) {
            case NORTH: {
                return new AxisAlignedBB(-0.1, 0.2, 0.9, 1.1, 0.8, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(-0.1, 0.2, 0.0, 1.1, 0.8, 0.1);
            }
            case WEST: {
                return new AxisAlignedBB(0.9, 0.2, -0.1, 1.0, 0.8, 1.1);
            }
        }
        return new AxisAlignedBB(0.0, 0.2, -0.1, 0.1, 0.8, 1.1);
    }
}

