/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tauri.dev.jsg.capability.CapabilityEnergyZPM;
import tauri.dev.jsg.power.zpm.ZPMItemEnergyStorage;

public class ZPMItemCapabilityProvider
implements ICapabilityProvider {
    protected ZPMItemEnergyStorage energyStorage;

    public ZPMItemCapabilityProvider(ItemStack stack, @Nullable NBTTagCompound nbt, long maxEnergy, final boolean creative) {
        this.energyStorage = new ZPMItemEnergyStorage(stack, maxEnergy){

            @Override
            public void setEnergyStored(long energy) {
                super.setEnergyStored(creative ? this.maxEnergyStored : energy);
            }

            @Override
            public long getEnergyStored() {
                if (creative) {
                    return this.maxEnergyStored;
                }
                return super.getEnergyStored();
            }

            @Override
            public int extractEnergy(int max, boolean simulate) {
                if (creative) {
                    return max;
                }
                return super.extractEnergy(max, simulate);
            }
        };
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            this.backwardsCompat(nbt.func_74775_l("Parent"));
        }
    }

    private void backwardsCompat(NBTTagCompound nbt) {
        if (nbt.func_150297_b("energy", 3)) {
            this.energyStorage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergyZPM.ENERGY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (this.energyStorage == null) {
            throw new RuntimeException("energyStorage was null!!!");
        }
        return (T)(capability == CapabilityEnergyZPM.ENERGY ? CapabilityEnergyZPM.ENERGY.cast((Object)this.energyStorage) : null);
    }
}

