/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.chunkloader;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tauri.dev.jsg.JSG;

@Mod.EventBusSubscriber
public class ChunkManager {
    private static final Map<World, ForgeChunkManager.Ticket> worldTicketMap = new HashMap<World, ForgeChunkManager.Ticket>();

    public static ForgeChunkManager.Ticket requestTicket(World world) {
        if (!worldTicketMap.containsKey(world)) {
            worldTicketMap.put(world, ForgeChunkManager.requestTicket((Object)JSG.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL));
        }
        return worldTicketMap.get(world);
    }

    public static void forceChunk(World world, ChunkPos chunk) {
        JSG.debug("Forcing chunk " + chunk + ", in world: " + world.field_73011_w);
        ForgeChunkManager.Ticket ticket = ChunkManager.requestTicket(world);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
        NBTTagList forcedChunks = ticket.getModData().func_150295_c("forcedChunks", 10);
        forcedChunks.func_74742_a((NBTBase)ChunkManager.serializeChunk(chunk));
        ticket.getModData().func_74782_a("forcedChunks", (NBTBase)forcedChunks);
    }

    public static void unforceChunk(World world, ChunkPos chunk) {
        ForgeChunkManager.Ticket ticket = ChunkManager.requestTicket(world);
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
        NBTTagList forcedChunks = ticket.getModData().func_150295_c("forcedChunks", 10);
        int found = -1;
        for (int i = 0; i < forcedChunks.func_74745_c(); ++i) {
            if (!ChunkManager.serializedChunkEquals(chunk, forcedChunks.func_150305_b(i))) continue;
            found = i;
            break;
        }
        if (found != -1) {
            forcedChunks.func_74744_a(found);
            ticket.getModData().func_74782_a("forcedChunks", (NBTBase)forcedChunks);
        }
    }

    private static NBTTagCompound serializeChunk(ChunkPos chunk) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("x", chunk.field_77276_a);
        compound.func_74768_a("z", chunk.field_77275_b);
        return compound;
    }

    public static ChunkPos deserializeChunk(NBTTagCompound compound) {
        return new ChunkPos(compound.func_74762_e("x"), compound.func_74762_e("z"));
    }

    private static boolean serializedChunkEquals(ChunkPos chunk, NBTTagCompound compound) {
        return compound.func_74762_e("x") == chunk.field_77276_a && compound.func_74762_e("z") == chunk.field_77275_b;
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        worldTicketMap.remove(event.getWorld());
    }
}

