/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.stargate;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.state.State;

public class StargateContainerGuiState
extends State {
    public Map<SymbolTypeEnum, StargateAddress> gateAdddressMap;
    public JSGTileEntityConfig config;

    public StargateContainerGuiState() {
    }

    public StargateContainerGuiState(Map<SymbolTypeEnum, StargateAddress> gateAdddressMap, JSGTileEntityConfig config) {
        this.gateAdddressMap = gateAdddressMap;
        this.config = config;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        for (SymbolTypeEnum symbolType : SymbolTypeEnum.values()) {
            this.gateAdddressMap.get(symbolType).toBytes(buf);
        }
        this.config.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.gateAdddressMap = new HashMap<SymbolTypeEnum, StargateAddress>(3);
        for (SymbolTypeEnum symbolType : SymbolTypeEnum.values()) {
            StargateAddress address = new StargateAddress(symbolType);
            address.fromBytes(buf);
            this.gateAdddressMap.put(symbolType, address);
        }
        this.config = new JSGTileEntityConfig(buf);
    }
}

