/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.element.tabs;

import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.items.SlotItemHandler;
import tauri.dev.jsg.gui.element.GuiHelper;
import tauri.dev.jsg.gui.element.tabs.Tab;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;

public class TabAddress
extends Tab {
    private final StargateClassicBaseTile gateTile;
    private final SymbolTypeEnum symbolType;
    private final int progressColor;
    private int maxSymbols;

    protected TabAddress(TabAddressBuilder builder) {
        super(builder);
        this.gateTile = builder.gateTile;
        this.symbolType = builder.symbolType;
        this.progressColor = builder.progressColor;
        this.maxSymbols = 6;
    }

    public static TabAddressBuilder builder() {
        return new TabAddressBuilder();
    }

    public void setMaxSymbols(int maxSymbols) {
        this.maxSymbols = maxSymbols;
    }

    @Override
    public void render(FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.render(fontRenderer, mouseX, mouseY);
        if (this.isVisible() && this.gateTile.getStargateAddress(this.symbolType) != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bgTexLocation);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX + 105), (int)(this.guiTop + this.defaultY + 86), (float)6.0f, (float)179.0f, (int)18, (int)18, (float)this.textureSize, (float)this.textureSize);
            int shadow = 2;
            float color = 1.0f;
            if (this.symbolType == SymbolTypeEnum.UNIVERSE) {
                color = 0.0f;
            }
            for (int i = 0; i < this.maxSymbols; ++i) {
                int originId = StargateClassicBaseTile.getOriginId(this.gateTile.getBiomeOverlayWithOverride(true), this.gateTile.func_145831_w().field_73011_w.getDimension(), this.gateTile.getConfig().getOption(StargateClassicBaseTile.ConfigOptions.ORIGIN_MODEL.id).getEnumValue().getIntValue());
                SymbolInterface symbol = Objects.requireNonNull(this.gateTile.getStargateAddress(this.symbolType)).get(i);
                if (symbol.renderIconByMinecraft(originId)) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(symbol.getIconResource(originId));
                } else {
                    TextureLoader.getTexture(symbol.getIconResource(originId)).bindTexture();
                }
                SymbolCoords symbolCoords = this.getSymbolCoords(i);
                GuiHelper.drawTexturedRectWithShadow(symbolCoords.x, symbolCoords.y, shadow, shadow, this.symbolType.iconWidht, this.symbolType.iconHeight, color);
            }
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.bgTexLocation);
            short progress = this.gateTile.getPageProgress();
            Color c = new Color(this.progressColor);
            float red = c.getRed();
            float green = c.getGreen();
            float blue = c.getBlue();
            GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
            Gui.func_146110_a((int)(this.guiLeft + this.currentOffsetX + 97), (int)(this.guiTop + this.defaultY + 86 + (18 - progress)), (float)0.0f, (float)(179 + (18 - progress)), (int)6, (int)progress, (float)this.textureSize, (float)this.textureSize);
            GlStateManager.func_179084_k();
        }
    }

    @Override
    public void renderFg(GuiScreen screen, FontRenderer fontRenderer, int mouseX, int mouseY) {
        super.renderFg(screen, fontRenderer, mouseX, mouseY);
        if (this.isVisible() && this.isOpen() && this.gateTile.getStargateAddress(this.symbolType) != null) {
            for (int i = 0; i < this.maxSymbols; ++i) {
                SymbolCoords symbolCoords = this.getSymbolCoords(i);
                if (!GuiHelper.isPointInRegion(symbolCoords.x, symbolCoords.y, this.symbolType.iconWidht, this.symbolType.iconHeight, mouseX, mouseY)) continue;
                screen.func_146279_a(Objects.requireNonNull(this.gateTile.getStargateAddress(this.symbolType)).get(i).localize(), mouseX - this.guiLeft, mouseY - this.guiTop);
            }
        }
    }

    public Tab.SlotTab createSlot(SlotItemHandler slot) {
        return new Tab.SlotTab(slot, slotTab -> {
            slotTab.field_75223_e = this.currentOffsetX + 106;
            slotTab.field_75221_f = this.defaultY + 87;
        });
    }

    public SymbolCoords getSymbolCoords(int symbol) {
        switch (this.symbolType) {
            case UNIVERSE: {
                return new SymbolCoords(this.guiLeft + this.currentOffsetX + 24 + 16 * (symbol % 6), this.guiTop + this.defaultY + 20 + 45 * (symbol / 6));
            }
            case PEGASUS: {
                return new SymbolCoords(this.guiLeft + this.currentOffsetX + 29 + 34 * (symbol % 3), this.guiTop + this.defaultY + 20 + 28 * (symbol / 3));
            }
        }
        return new SymbolCoords(this.guiLeft + this.currentOffsetX + 29 + 31 * (symbol % 3), this.guiTop + this.defaultY + 20 + 28 * (symbol / 3));
    }

    public static class TabAddressBuilder
    extends Tab.TabBuilder {
        private StargateClassicBaseTile gateTile;
        private SymbolTypeEnum symbolType;
        private int progressColor;

        public TabAddressBuilder setGateTile(StargateClassicBaseTile gateTile) {
            this.gateTile = gateTile;
            return this;
        }

        public TabAddressBuilder setSymbolType(SymbolTypeEnum symbolType) {
            this.symbolType = symbolType;
            return this;
        }

        public TabAddressBuilder setProgressColor(int color) {
            this.progressColor = color;
            return this;
        }

        @Override
        public TabAddress build() {
            return new TabAddress(this);
        }
    }

    public static class SymbolCoords {
        public final int x;
        public final int y;

        public SymbolCoords(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

