/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.entry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tauri.dev.jsg.gui.base.JSGButton;
import tauri.dev.jsg.gui.base.JSGTextField;
import tauri.dev.jsg.gui.element.ArrowButton;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.gui.entry.EntryActionEnum;
import tauri.dev.jsg.packet.gui.entry.EntryActionToServer;
import tauri.dev.jsg.packet.gui.entry.EntryDataTypeEnum;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.stargate.network.SymbolInterface;

public abstract class AbstractEntry {
    protected Minecraft mc;
    protected int index;
    protected int maxIndex;
    protected EnumHand hand;
    protected String name;
    private ActionListener actionListener;
    protected GuiTextField nameField;
    protected JSGButton upButton;
    protected JSGButton downButton;
    protected JSGButton removeButton;
    protected List<JSGButton> buttons = new ArrayList<JSGButton>();
    protected List<GuiTextField> textFields = new ArrayList<GuiTextField>();
    public int entryX;
    public int entryY;

    public AbstractEntry(Minecraft mc, int index, int maxIndex, EnumHand hand, String name, ActionListener actionListener) {
        this.mc = mc;
        this.index = index;
        this.maxIndex = maxIndex;
        this.hand = hand;
        this.name = name;
        this.actionListener = actionListener;
        int tId = 0;
        this.nameField = new JSGTextField(tId++, mc.field_71466_p, 0, 0, 100, 20, name).setActionCallback(() -> this.action(EntryActionEnum.RENAME));
        this.nameField.func_146180_a(name);
        this.nameField.func_146203_f(this.getMaxNameLength());
        this.textFields.add(this.nameField);
        int bId = 0;
        this.upButton = new ArrowButton(bId++, 0, 0, ArrowButton.ArrowType.UP).setFgColor(GuiUtils.getColorCode((char)'f', (boolean)true)).setActionCallback(() -> this.action(EntryActionEnum.MOVE_UP));
        this.downButton = new ArrowButton(bId++, 0, 0, ArrowButton.ArrowType.DOWN).setFgColor(GuiUtils.getColorCode((char)'f', (boolean)true)).setActionCallback(() -> this.action(EntryActionEnum.MOVE_DOWN));
        this.removeButton = new ArrowButton(bId++, 0, 0, ArrowButton.ArrowType.CROSS).setFgColor(GuiUtils.getColorCode((char)'c', (boolean)true)).setActionCallback(() -> this.action(EntryActionEnum.REMOVE));
        this.buttons.add(this.upButton);
        this.buttons.add(this.downButton);
        this.buttons.add(this.removeButton);
    }

    public void renderAt(int dx, int dy, int mouseX, int mouseY, float partialTicks) {
        this.entryX = dx;
        this.entryY = dy;
        for (GuiTextField tf : this.textFields) {
            tf.field_146209_f = dx;
            tf.field_146210_g = dy;
            tf.func_146194_f();
            dx += tf.field_146218_h + 10;
        }
        boolean first = this.index == 0;
        boolean last = this.index == this.maxIndex - 1;
        this.upButton.field_146124_l = !first;
        this.downButton.field_146124_l = !last;
        for (GuiButton guiButton : this.buttons) {
            guiButton.field_146128_h = dx;
            guiButton.field_146129_i = dy;
            guiButton.func_191745_a(this.mc, mouseX, mouseY, partialTicks);
            dx += 25;
        }
    }

    public void setLocation(int dx, int dy) {
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.field_146209_f = dx;
            guiTextField.field_146210_g = dy;
            dx += guiTextField.field_146218_h + 10;
        }
        for (GuiButton guiButton : this.buttons) {
            guiButton.field_146128_h = dx;
            guiButton.field_146129_i = dy;
            dx += 25;
        }
    }

    protected void action(EntryActionEnum action) {
        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new EntryActionToServer(this.hand, this.getEntryDataType(), action, this.index, this.nameField.func_146179_b()));
        this.actionListener.action(action, this.index);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return false;
        }
        for (JSGButton btn : this.buttons) {
            if (!btn.func_146116_c(this.mc, mouseX, mouseY)) continue;
            btn.func_146113_a(this.mc.func_147118_V());
            btn.performAction();
            return true;
        }
        for (GuiTextField tf : this.textFields) {
            tf.func_146192_a(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    protected void keyTyped(char typedChar, int keyCode) {
        for (GuiTextField tf : this.textFields) {
            tf.func_146201_a(typedChar, keyCode);
        }
    }

    public void updateScreen() {
        for (GuiTextField tf : this.textFields) {
            tf.func_146178_a();
        }
    }

    protected abstract int getHeight();

    protected abstract int getMaxNameLength();

    protected abstract EntryDataTypeEnum getEntryDataType();

    protected void renderSymbol(int x, int y, int sizeX, int sizeY, int mouseX, int mouseY, SymbolInterface symbol) {
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)260);
        GlStateManager.func_179131_c((float)0.77f, (float)0.77f, (float)0.77f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(symbol.getIconResource(BiomeOverlayEnum.NORMAL, 0));
        Gui.func_152125_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)sizeX, (int)sizeY, (float)256.0f, (float)256.0f);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
    }

    static interface ActionListener {
        public void action(EntryActionEnum var1, int var2);
    }
}

