/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.integration.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.integration.jei.AbstractJEIRecipe;
import tauri.dev.jsg.integration.jei.JEIAdvancedGuiHandler;
import tauri.dev.jsg.integration.jei.category.JEIAssemblerRecipeCategory;
import tauri.dev.jsg.integration.jei.category.JEIChamberRecipeCategory;
import tauri.dev.jsg.integration.jei.category.JEIOreWashingRecipeCategory;
import tauri.dev.jsg.integration.jei.category.JEIPCBFabricatorRecipeCategory;
import tauri.dev.jsg.integration.jei.recipe.JEINotebookCloneRecipe;
import tauri.dev.jsg.integration.jei.recipe.JEINotebookRecipe;
import tauri.dev.jsg.integration.jei.recipe.JEIUniverseDialerCloneRecipe;
import tauri.dev.jsg.integration.jei.recipe.JEIUniverseDialerRepairRecipe;
import tauri.dev.jsg.item.JSGIconItem;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.machine.AbstractMachineRecipe;
import tauri.dev.jsg.machine.assembler.AssemblerRecipe;
import tauri.dev.jsg.machine.assembler.AssemblerRecipes;
import tauri.dev.jsg.machine.chamber.CrystalChamberRecipe;
import tauri.dev.jsg.machine.chamber.CrystalChamberRecipes;
import tauri.dev.jsg.machine.orewashing.OreWashingRecipe;
import tauri.dev.jsg.machine.orewashing.OreWashingRecipes;
import tauri.dev.jsg.machine.pcbfabricator.PCBFabricatorRecipe;
import tauri.dev.jsg.machine.pcbfabricator.PCBFabricatorRecipes;

@JEIPlugin
public final class JEIIntegration
implements IModPlugin {
    public void register(IModRegistry registry) {
        AbstractJEIRecipe newRecipe;
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)JSGBlocks.INVISIBLE_BLOCK, 1, Short.MAX_VALUE));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)JSGBlocks.IRIS_BLOCK, 1, Short.MAX_VALUE));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)JSGItems.NOTEBOOK_ITEM, 1));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Block)JSGBlocks.ORE_NAQUADAH_BLOCK_STONE, 1));
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new JEIAdvancedGuiHandler()});
        for (Item i : JSGItems.ITEMS) {
            if (!(i instanceof JSGIconItem)) continue;
            registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(i, 1));
        }
        ArrayList<JEINotebookRecipe> recipes = new ArrayList<JEINotebookRecipe>(JEINotebookRecipe.genAll());
        recipes.add((JEINotebookRecipe)((Object)new JEIUniverseDialerCloneRecipe()));
        recipes.add((JEINotebookRecipe)((Object)new JEINotebookCloneRecipe()));
        recipes.add((JEINotebookRecipe)((Object)new JEIUniverseDialerRepairRecipe()));
        registry.addRecipes(recipes, "minecraft.crafting");
        recipes.clear();
        for (final AssemblerRecipe assemblerRecipe : AssemblerRecipes.RECIPES) {
            if (assemblerRecipe.isDisabled()) continue;
            newRecipe = new AbstractJEIRecipe(){

                public void getIngredients(@Nonnull IIngredients iIngredients) {
                    ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
                    list.add(Collections.singletonList(new ItemStack(assemblerRecipe.getSchematic(), 1)));
                    for (ItemStack s : assemblerRecipe.getPattern()) {
                        list.add(Collections.singletonList(s));
                    }
                    list.add(Collections.singletonList(assemblerRecipe.getSubItemStack()));
                    iIngredients.setInputLists(VanillaTypes.ITEM, list);
                    iIngredients.setOutput(VanillaTypes.ITEM, (Object)assemblerRecipe.getResult());
                }
            };
            recipes.add((JEINotebookRecipe)((Object)newRecipe));
        }
        registry.addRecipes(recipes, "jsg_assembler");
        recipes.clear();
        for (AbstractMachineRecipe abstractMachineRecipe : CrystalChamberRecipes.RECIPES) {
            if (((CrystalChamberRecipe)abstractMachineRecipe).isDisabled()) continue;
            newRecipe = new AbstractJEIRecipe((CrystalChamberRecipe)abstractMachineRecipe){
                final /* synthetic */ CrystalChamberRecipe val$recipe;
                {
                    this.val$recipe = crystalChamberRecipe;
                }

                @Override
                public FluidStack getSubFluidStack() {
                    return this.val$recipe.getSubFluidStack();
                }

                public void getIngredients(@Nonnull IIngredients iIngredients) {
                    iIngredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack(JSGItems.CRYSTAL_SEED, this.val$recipe.getNeededSeeds()));
                    iIngredients.setInput(VanillaTypes.FLUID, (Object)this.getSubFluidStack());
                    iIngredients.setOutput(VanillaTypes.ITEM, (Object)this.val$recipe.getResult());
                }
            };
            recipes.add((JEINotebookRecipe)((Object)newRecipe));
        }
        registry.addRecipes(recipes, "jsg_chamber");
        recipes.clear();
        for (AbstractMachineRecipe abstractMachineRecipe : PCBFabricatorRecipes.RECIPES) {
            if (((PCBFabricatorRecipe)abstractMachineRecipe).isDisabled()) continue;
            newRecipe = new AbstractJEIRecipe((PCBFabricatorRecipe)abstractMachineRecipe){
                final /* synthetic */ PCBFabricatorRecipe val$recipe;
                {
                    this.val$recipe = pCBFabricatorRecipe;
                }

                @Override
                public FluidStack getSubFluidStack() {
                    return this.val$recipe.getSubFluidStack();
                }

                public void getIngredients(@Nonnull IIngredients iIngredients) {
                    ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
                    for (ItemStack s : this.val$recipe.getPattern()) {
                        list.add(Collections.singletonList(s));
                    }
                    iIngredients.setInputLists(VanillaTypes.ITEM, list);
                    iIngredients.setInput(VanillaTypes.FLUID, (Object)this.getSubFluidStack());
                    iIngredients.setOutput(VanillaTypes.ITEM, (Object)this.val$recipe.getResult());
                }
            };
            recipes.add((JEINotebookRecipe)((Object)newRecipe));
        }
        registry.addRecipes(recipes, "jsg_pcb_fabricator");
        recipes.clear();
        for (AbstractMachineRecipe abstractMachineRecipe : OreWashingRecipes.RECIPES) {
            if (((OreWashingRecipe)abstractMachineRecipe).isDisabled()) continue;
            newRecipe = new AbstractJEIRecipe((OreWashingRecipe)abstractMachineRecipe){
                final /* synthetic */ OreWashingRecipe val$recipe;
                {
                    this.val$recipe = oreWashingRecipe;
                }

                @Override
                public FluidStack getSubFluidStack() {
                    return this.val$recipe.getSubFluidStack();
                }

                public void getIngredients(@Nonnull IIngredients iIngredients) {
                    iIngredients.setInput(VanillaTypes.ITEM, (Object)this.val$recipe.getItemNeeded());
                    iIngredients.setInput(VanillaTypes.FLUID, (Object)this.getSubFluidStack());
                    iIngredients.setOutput(VanillaTypes.ITEM, (Object)this.val$recipe.getResult());
                }
            };
            recipes.add((JEINotebookRecipe)((Object)newRecipe));
        }
        registry.addRecipes(recipes, "jsg_ore_washing");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIAssemblerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIChamberRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIPCBFabricatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new JEIOreWashingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

