/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.linkable.dialer;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerItem;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerMode;
import tauri.dev.jsg.item.oc.ItemOCMessage;
import tauri.dev.jsg.item.renderer.ItemRenderHelper;
import tauri.dev.jsg.item.renderer.JSGFontRenderer;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.renderer.AncientRenderer;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolMilkyWayEnum;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;
import tauri.dev.jsg.transportrings.TransportRings;
import tauri.dev.jsg.util.JSGMinecraftHelper;
import tauri.dev.jsg.util.JSGTextureLightningHelper;

public class UniverseDialerTEISR
extends TileEntityItemStackRenderer {
    private final ArrayList<Integer> switchStates = new ArrayList();

    private static StargateAddressDynamic addrFromBytes(NBTTagCompound compound, String baseName) {
        if (compound == null || baseName == null) {
            return null;
        }
        SymbolTypeEnum symbolType = SymbolTypeEnum.valueOf(compound.func_74771_c(baseName + "_symbolType"));
        StargateAddressDynamic newAddress = new StargateAddressDynamic(symbolType);
        int addressLength = compound.func_74771_c(baseName + "_addressLength");
        block5: for (int i = 0; i < addressLength; ++i) {
            byte symbolId = compound.func_74771_c(baseName + "_" + i);
            switch (symbolType) {
                case MILKYWAY: {
                    newAddress.addSymbol(SymbolMilkyWayEnum.valueOf(symbolId));
                    continue block5;
                }
                case PEGASUS: {
                    newAddress.addSymbol(SymbolPegasusEnum.valueOf(symbolId));
                    continue block5;
                }
                case UNIVERSE: {
                    newAddress.addSymbol(SymbolUniverseEnum.valueOf(symbolId));
                    continue block5;
                }
            }
        }
        return newAddress;
    }

    private static void drawStringWithShadow(float x, float y, String text, boolean active, boolean red) {
        UniverseDialerTEISR.drawStringWithShadow(x, y, text, active, red, false, false, EnumStargateState.IDLE);
    }

    private static void drawStringWithShadow(float x, float y, String text, boolean isActive, boolean redDef, boolean isAddress, boolean dialing, EnumStargateState stargateState) {
        boolean isEngaged = stargateState.engaged() || stargateState.initiating();
        boolean isEngagedInitiating = stargateState.initiating();
        boolean isIncoming = stargateState.incoming();
        boolean isFailing = stargateState.failing();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.015f, (float)0.015f, (float)0.015f);
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        if (!isActive || isIncoming || !isEngagedInitiating && isEngaged) {
            alpha = 0.3f;
        }
        if (dialing) {
            red = 0.5f;
            green = 0.7f;
            blue = 1.0f;
        }
        if (isEngaged && dialing) {
            red = 0.0f;
            green = 1.0f;
            blue = 0.5f;
        }
        if (isFailing && dialing) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.3f;
        }
        if (isIncoming || !isEngagedInitiating && isEngaged) {
            red = 1.0f;
            green = 0.7f;
            blue = 0.0f;
        }
        int color = !isAddress ? (isActive ? 0xFFFFFF : 24831) : new Color(red, green, blue, alpha).getRGB();
        JSGFontRenderer.getFontRenderer().func_175065_a(text, -6.0f, 19.0f, color, false);
        if (isActive) {
            GlStateManager.func_179137_b((double)-0.4, (double)0.6, (double)-0.1);
            JSGFontRenderer.getFontRenderer().func_175065_a(text, -6.0f, 19.0f, color, false);
        }
        GlStateManager.func_179121_F();
    }

    private static void renderSymbol(int row, int col, SymbolInterface symbol, boolean dialing, boolean isActive, boolean is9Chevron, boolean engage, EnumStargateState stargateState) {
        boolean isEngaged = stargateState.engaged() || stargateState.initiating();
        boolean isEngagedInitiating = stargateState.initiating();
        boolean isIncoming = stargateState.incoming();
        boolean isFailing = stargateState.failing();
        float x = (float)col * 0.09f - 0.05f;
        float y = (float)(-row) * 0.32f - 0.16f;
        float scale = 0.7f;
        float w = 0.19f * scale;
        float h = 0.4f * scale;
        if (!is9Chevron) {
            x += 0.09f;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(symbol.getIconResource(BiomeOverlayEnum.NORMAL, 0));
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        if (!isActive || isIncoming || !isEngagedInitiating && isEngaged) {
            alpha = 0.3f;
        }
        if (dialing && !isEngaged && !engage) {
            red = 0.5f;
            green = 0.7f;
            blue = 1.0f;
        }
        if (isEngaged && engage) {
            red = 0.0f;
            green = 1.0f;
            blue = 0.5f;
        }
        if (isFailing && engage) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.3f;
        }
        if (isIncoming || !isEngagedInitiating && isEngaged) {
            red = 1.0f;
            green = 0.7f;
            blue = 0.0f;
        }
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        UniverseDialerTEISR.drawTexturedRect(x, y, 0.0f, w, h);
        float shadow = 0.008f;
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.15f);
        UniverseDialerTEISR.drawTexturedRect(x + shadow, y - shadow, -0.01f, w, h);
    }

    private static void drawTexturedRect(float x, float y, float z, float w, float h) {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(x + w), (float)y, (float)z);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(x + w), (float)(y + h), (float)z);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)(y + h), (float)z);
        GL11.glEnd();
    }

    private static void renderArms(EnumHandSide handSide, float angle, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)20.0f, (float)20.0f, (float)20.0f);
        ItemRenderHelper.applyBobbing(partialTicks);
        if (handSide == EnumHandSide.RIGHT) {
            GlStateManager.func_179137_b((double)-0.3, (double)-0.4, (double)0.0);
            GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-0.15 * (double)angle), (double)(-0.5 * (double)angle), (double)0.0);
            GlStateManager.func_179114_b((float)(10.0f * angle), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179137_b((double)0.3, (double)-0.4, (double)0.0);
            GlStateManager.func_179114_b((float)-25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(0.15 * (double)angle), (double)(-0.5 * (double)angle), (double)0.0);
            GlStateManager.func_179114_b((float)(-10.0f * angle), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        ItemRenderHelper.renderArmFirstPersonSide(0.0f, handSide, 0.0f, null);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_179022_a(ItemStack stack) {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        ItemCameraTransforms.TransformType transformType = JSGItems.UNIVERSE_DIALER.getLastTransform();
        boolean isBroken = stack.func_77952_i() == UniverseDialerItem.UniverseDialerVariants.BROKEN.meta;
        GlStateManager.func_179094_E();
        if (transformType == ItemCameraTransforms.TransformType.FIXED) {
            GlStateManager.func_179137_b((double)0.53, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
        } else {
            boolean mainhand = JSGItems.UNIVERSE_DIALER.getLastTransform() == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            EnumHandSide handSide = mainhand ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            float angle = ItemRenderHelper.getMapAngleFromPitch(pitch);
            UniverseDialerTEISR.renderArms(handSide, angle, partialTicks);
            angle = 1.0f - angle;
            if (handSide == EnumHandSide.RIGHT) {
                GlStateManager.func_179137_b((double)0.8, (double)0.0, (double)-0.5);
                GlStateManager.func_179114_b((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)0.0, (double)(0.3 * (double)angle), (double)(-0.1 * (double)angle));
                GlStateManager.func_179114_b((float)(25.0f * angle), (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179137_b((double)-0.2, (double)0.0, (double)-0.55);
                GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)(0.3 * (double)angle), (double)(-0.0 * (double)angle));
                GlStateManager.func_179114_b((float)(25.0f * angle), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        }
        if (!isBroken) {
            ElementEnum.UNIVERSE_DIALER.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        } else {
            ElementEnum.UNIVERSE_DIALER_BROKEN.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.1f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        JSGTextureLightningHelper.lightUpTexture(1.0f);
        if (stack.func_77942_o() && !isBroken) {
            long time;
            NBTTagCompound compound = stack.func_77978_p();
            UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
            UniverseDialerTEISR.drawStringWithShadow(-0.47f, 0.916f, mode.localize(), true, false);
            UniverseDialerTEISR.drawStringWithShadow(0.22f, 0.916f, mode.next().localize(), false, false);
            boolean notLinked = mode.linkable && !compound.func_74764_b(mode.tagPosName);
            boolean clocksDisabled = false;
            if (mode == UniverseDialerMode.COUNTDOWN && (time = compound.func_74763_f("timerCountTo")) == -1L) {
                clocksDisabled = true;
            }
            if (notLinked || clocksDisabled) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("jsg", "textures/gui/universe_warning.png"));
                GlStateManager.func_179098_w();
                GlStateManager.func_179147_l();
                if (notLinked && mode == UniverseDialerMode.COUNTDOWN) {
                    GlStateManager.func_179131_c((float)0.7f, (float)1.0f, (float)0.3f, (float)1.0f);
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                UniverseDialerTEISR.drawTexturedRect(0.72f, 0.26f, 0.0f, 0.24f, 0.24f);
            }
            if (!notLinked || mode == UniverseDialerMode.MEMORY || mode == UniverseDialerMode.COUNTDOWN) {
                if (mode == UniverseDialerMode.GATE_INFO) {
                    EnumStargateState gateStatus = EnumStargateState.valueOf(compound.func_74762_e("gateStatus"));
                    String[] opened = compound.func_74779_i("gateOpenTime").split(" ");
                    String[] iris = compound.func_74779_i("gateIrisState").split(" ");
                    String[] lastSymbol = compound.func_74779_i("gateLastSymbol").replaceAll("Glyph ", "G").split(" ");
                    float top = 0.64f;
                    float row = 0.2f;
                    float x = -0.42f;
                    float second = 0.9f;
                    UniverseDialerTEISR.drawStringWithShadow(x, top - row * 0.0f, "State:", false, false);
                    UniverseDialerTEISR.drawStringWithShadow(x, top - row * 1.0f, "Wormhole:", false, false);
                    UniverseDialerTEISR.drawStringWithShadow(x, top - row * 2.0f, "Iris:", false, false);
                    UniverseDialerTEISR.drawStringWithShadow(x, top - row * 3.0f, "Last glyph:", false, false);
                    String[] state = gateStatus.toString().replaceAll("ENGAGED", "ENGAGED INCOMING").replaceAll("ENGAGED INCOMING_INITIATING", "ENGAGED OUTGOING").replaceAll("_", " ").split(" ");
                    if (this.switchStates.size() < 4) {
                        this.switchStates.clear();
                        for (int i = 0; i < 4; ++i) {
                            this.switchStates.add(0);
                        }
                    }
                    for (int u = 0; u < 4; ++u) {
                        int max = 0;
                        switch (u) {
                            default: {
                                break;
                            }
                            case 0: {
                                max = state.length;
                                break;
                            }
                            case 1: {
                                max = opened.length;
                                break;
                            }
                            case 2: {
                                max = iris.length;
                                break;
                            }
                            case 3: {
                                max = lastSymbol.length;
                            }
                        }
                        int current = (int)Math.floor((double)(JSGMinecraftHelper.getClientTick() % (long)(40 * max)) / 40.0);
                        this.switchStates.set(u, current);
                    }
                    if (state.length > this.switchStates.get(0)) {
                        UniverseDialerTEISR.drawStringWithShadow(x + second, top - row * 0.0f, state[this.switchStates.get(0)].replaceAll("_", " "), true, false);
                    }
                    if (opened.length > this.switchStates.get(1)) {
                        UniverseDialerTEISR.drawStringWithShadow(x + second, top - row * 1.0f, opened[this.switchStates.get(1)].replaceAll("_", " "), true, false);
                    }
                    if (iris.length > this.switchStates.get(2)) {
                        UniverseDialerTEISR.drawStringWithShadow(x + second, top - row * 2.0f, iris[this.switchStates.get(2)].replaceAll("_", " "), true, false);
                    }
                    if (lastSymbol.length > this.switchStates.get(3)) {
                        UniverseDialerTEISR.drawStringWithShadow(x + second, top - row * 3.0f, lastSymbol[this.switchStates.get(3)].replaceAll("_", " "), true, false);
                    }
                } else if (mode == UniverseDialerMode.COUNTDOWN) {
                    if (notLinked) {
                        UniverseDialerTEISR.drawStringWithShadow(-0.46f, 0.03999996f, I18n.func_135052_a((String)"item.jsg.universe_dialer.countdown_not_sync", (Object[])new Object[0]), false, false);
                    }
                    if (!clocksDisabled) {
                        long countdown;
                        time = compound.func_74763_f("timerCountTo");
                        long ticks = countdown = time - JSGMinecraftHelper.getPlayerTickClientSide();
                        if (countdown < 0L) {
                            ticks = 0L;
                        }
                        if (countdown < -(20L * (long)JSGConfig.General.countdownConfig.zeroDelay)) {
                            time = -1L;
                        }
                        float y = 0.23999995f;
                        float x = 0.38f;
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                        GlStateManager.func_179139_a((double)0.03, (double)0.03, (double)0.03);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                        AncientRenderer.renderClock(ticks, false, time, true);
                        GlStateManager.func_179121_F();
                        GlStateManager.func_179121_F();
                    } else {
                        UniverseDialerTEISR.drawStringWithShadow(-0.42f, 0.33999997f, I18n.func_135052_a((String)"item.jsg.universe_dialer.countdown_not_active", (Object[])new Object[0]), false, false);
                    }
                } else {
                    byte selected = compound.func_74771_c("selected");
                    NBTTagList tagList = compound.func_150295_c(mode.tagListName, 10);
                    block13: for (int offset = -1; offset <= 1; ++offset) {
                        int index = selected + offset;
                        if (index < 0 || index >= tagList.func_74745_c()) continue;
                        boolean active = offset == 0;
                        NBTTagCompound entryCompound = tagList.func_150305_b(index);
                        switch (mode) {
                            case MEMORY: 
                            case NEARBY: {
                                boolean engage_poo;
                                UniverseDialerTEISR.drawStringWithShadow(-0.32f, 0.32f - 0.32f * (float)offset, index + 1 + ".", active, false);
                                StargateAddress address = new StargateAddress(entryCompound);
                                boolean hasUpgrade = entryCompound.func_74767_n("hasUpgrade");
                                int symbolCount = SymbolUniverseEnum.getMaxSymbolsDisplay(hasUpgrade);
                                EnumStargateState gateStatus = EnumStargateState.valueOf(compound.func_74762_e("gateStatus"));
                                boolean isIdle = gateStatus.idle();
                                StargateAddressDynamic dialedAddress = UniverseDialerTEISR.addrFromBytes(compound, "dialedAddress");
                                StargateAddressDynamic toDialAddress = UniverseDialerTEISR.addrFromBytes(compound, "toDialAddress");
                                int dialed = -1;
                                boolean isDialingThisAddr = false;
                                if (toDialAddress != null && toDialAddress.equals(address)) {
                                    dialed = 0;
                                    isDialingThisAddr = true;
                                }
                                if (dialedAddress != null && dialed >= 0) {
                                    dialed = dialedAddress.getSize();
                                }
                                if (dialed == 0 && isIdle) {
                                    dialed = -1;
                                }
                                if (dialed == -1) {
                                    engage_poo = false;
                                } else if (hasUpgrade) {
                                    engage_poo = dialed == 9;
                                } else {
                                    boolean bl = engage_poo = dialed == 7;
                                }
                                if (entryCompound.func_74764_b("name")) {
                                    String entryName = entryCompound.func_74779_i("name");
                                    if (dialed > -1) {
                                        entryName = entryName + " (" + dialed + ")";
                                    }
                                    UniverseDialerTEISR.drawStringWithShadow(-0.05f, 0.32f - 0.32f * (float)offset, entryName, active, false, true, dialed >= 0, gateStatus);
                                    continue block13;
                                }
                                for (int i = 0; i < symbolCount; ++i) {
                                    boolean engage_s = i < dialed;
                                    UniverseDialerTEISR.renderSymbol(offset, i, address.get(i), isDialingThisAddr, active, hasUpgrade, engage_s, gateStatus);
                                }
                                UniverseDialerTEISR.renderSymbol(offset, symbolCount, SymbolUniverseEnum.getOrigin(), isDialingThisAddr, active, hasUpgrade, engage_poo, gateStatus);
                                continue block13;
                            }
                            case RINGS: {
                                TransportRings rings = new TransportRings(entryCompound);
                                String name = rings.getName();
                                if (name.equals("") || name.equals("[empty]")) {
                                    name = index + "";
                                }
                                UniverseDialerTEISR.drawStringWithShadow(-0.1f, 0.32f - 0.32f * (float)offset, name, active, false);
                                continue block13;
                            }
                            case OC: {
                                ItemOCMessage message = new ItemOCMessage(entryCompound);
                                UniverseDialerTEISR.drawStringWithShadow(-0.32f, 0.32f - 0.32f * (float)offset, index + 1 + ".", active, false);
                                UniverseDialerTEISR.drawStringWithShadow(-0.1f, 0.32f - 0.32f * (float)offset, message.name, active, false);
                            }
                        }
                    }
                }
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

