/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.packet.gui.entry;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerItem;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerMode;
import tauri.dev.jsg.item.notebook.NotebookItem;
import tauri.dev.jsg.packet.gui.entry.EntryActionEnum;
import tauri.dev.jsg.packet.gui.entry.EntryDataTypeEnum;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolUniverseEnum;
import tauri.dev.jsg.tileentity.stargate.StargateUniverseBaseTile;

public class EntryActionToServer
implements IMessage {
    private EnumHand hand;
    private EntryDataTypeEnum dataType;
    private EntryActionEnum action;
    private int index;
    private String name;

    public EntryActionToServer() {
    }

    public EntryActionToServer(EnumHand hand, EntryDataTypeEnum dataType, EntryActionEnum action, int index, String name) {
        this.hand = hand;
        this.dataType = dataType;
        this.action = action;
        this.index = index;
        this.name = name;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.hand.ordinal());
        buf.writeInt(this.dataType.ordinal());
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.index);
        buf.writeInt(this.name.length());
        buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = EnumHand.values()[buf.readInt()];
        this.dataType = EntryDataTypeEnum.values()[buf.readInt()];
        this.action = EntryActionEnum.values()[buf.readInt()];
        this.index = buf.readInt();
        int size = buf.readInt();
        this.name = buf.readCharSequence(size, StandardCharsets.UTF_8).toString();
    }

    private static void tagSwitchPlaces(NBTTagList list, int a, int b) {
        NBTBase tagA = list.func_179238_g(a);
        list.func_150304_a(a, list.func_179238_g(b));
        list.func_150304_a(b, tagA);
    }

    public static class EntryActionServerHandler
    implements IMessageHandler<EntryActionToServer, IMessage> {
        public IMessage onMessage(EntryActionToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                ItemStack stack = player.func_184586_b(message.hand);
                NBTTagCompound compound = stack.func_77978_p();
                if (message.dataType.page()) {
                    NBTTagList list = compound.func_150295_c("addressList", 10);
                    switch (message.action) {
                        case RENAME: {
                            NotebookItem.setNameForIndex(list, message.index, message.name);
                            break;
                        }
                        case MOVE_UP: {
                            EntryActionToServer.tagSwitchPlaces(list, message.index, message.index - 1);
                            break;
                        }
                        case MOVE_DOWN: {
                            EntryActionToServer.tagSwitchPlaces(list, message.index, message.index + 1);
                            break;
                        }
                        case REMOVE: {
                            NBTTagCompound selectedCompound = list.func_150305_b(message.index);
                            list.func_74744_a(message.index);
                            if (list.func_74745_c() == 0) {
                                player.func_184611_a(message.hand, ItemStack.field_190927_a);
                            } else {
                                compound.func_74768_a("selected", Math.min(message.index, list.func_74745_c() - 1));
                            }
                            ItemStack pageStack = new ItemStack((Item)JSGItems.PAGE_NOTEBOOK_ITEM, 1, 1);
                            pageStack.func_77982_d(selectedCompound);
                            player.func_191521_c(pageStack);
                        }
                    }
                } else if (message.dataType.universe()) {
                    NBTTagList list = compound.func_150295_c(UniverseDialerMode.MEMORY.tagListName, 10);
                    BlockPos linkedPos = BlockPos.func_177969_a((long)compound.func_74763_f(UniverseDialerMode.MEMORY.tagPosName));
                    NBTTagCompound selectedCompound = list.func_150305_b(message.index);
                    switch (message.action) {
                        case RENAME: {
                            UniverseDialerItem.setMemoryNameForIndex(list, message.index, message.name);
                            break;
                        }
                        case MOVE_UP: {
                            EntryActionToServer.tagSwitchPlaces(list, message.index, message.index - 1);
                            break;
                        }
                        case MOVE_DOWN: {
                            EntryActionToServer.tagSwitchPlaces(list, message.index, message.index + 1);
                            break;
                        }
                        case REMOVE: {
                            list.func_74744_a(message.index);
                            UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
                            if (mode != UniverseDialerMode.MEMORY) break;
                            compound.func_74774_a("selected", (byte)Math.min(message.index, list.func_74745_c() - 1));
                            break;
                        }
                        case DIAL: {
                            int maxSymbols = SymbolUniverseEnum.getMaxSymbolsDisplay(selectedCompound.func_74767_n("hasUpgrade"));
                            StargateUniverseBaseTile gateTile = (StargateUniverseBaseTile)world.func_175625_s(linkedPos);
                            if (gateTile == null || !gateTile.dialAddress(new StargateAddress(selectedCompound), maxSymbols)) break;
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.dial_start", new Object[0]), true);
                        }
                    }
                } else if (message.dataType.oc()) {
                    NBTTagList list = compound.func_150295_c(UniverseDialerMode.OC.tagListName, 10);
                    switch (message.action) {
                        case RENAME: {
                            UniverseDialerItem.changeOCMessageAtIndex(list, message.index, ocMessage -> {
                                ocMessage.name = message.name;
                            });
                            break;
                        }
                        case MOVE_UP: {
                            EntryActionToServer.tagSwitchPlaces(list, message.index, message.index - 1);
                            break;
                        }
                        case MOVE_DOWN: {
                            EntryActionToServer.tagSwitchPlaces(list, message.index, message.index + 1);
                            break;
                        }
                        case REMOVE: {
                            list.func_74744_a(message.index);
                            UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
                            if (mode != UniverseDialerMode.OC) break;
                            compound.func_74774_a("selected", (byte)Math.min(message.index, list.func_74745_c() - 1));
                        }
                    }
                }
            });
            return null;
        }
    }
}

