/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.proxy;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.lwjgl.opengl.Display;
import tauri.dev.jsg.block.JSGBlock;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.block.stargate.StargateClassicMemberBlockColor;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.JSGConfigUtil;
import tauri.dev.jsg.entity.friendly.TokraEntity;
import tauri.dev.jsg.entity.renderer.TokraRenderer;
import tauri.dev.jsg.event.EventTickClient;
import tauri.dev.jsg.event.InputHandlerClient;
import tauri.dev.jsg.fluid.JSGBlockFluid;
import tauri.dev.jsg.fluid.JSGFluids;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.color.PageNotebookItemColor;
import tauri.dev.jsg.item.renderer.CustomModelItemInterface;
import tauri.dev.jsg.loader.ReloadListener;
import tauri.dev.jsg.proxy.IProxy;
import tauri.dev.jsg.renderer.effect.DestinyFTL;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateOrlinRenderer;
import tauri.dev.jsg.sound.JSGSoundHelperClient;
import tauri.dev.jsg.sound.SoundPositionedEnum;

public class ProxyClient
implements IProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (JSGConfig.General.visual.changeTitle) {
            Display.setTitle((String)(Display.getTitle() + " w/" + "Just Stargate Mod" + " " + "1.12.2-4.11.0.8".replaceAll("1.12.2-", "")));
        }
        this.registerRenderers();
        this.registerFluidRenderers();
        InputHandlerClient.registerKeybindings();
        MinecraftForge.EVENT_BUS.register((Object)new JSGConfigUtil());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (JSGConfig.General.mainMenuConfig.loadingMusic) {
            this.playPositionedSoundClientSide(new BlockPos(0, 0, 0), SoundPositionedEnum.LOADING_MUSIC, true);
        }
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new PageNotebookItemColor(), new Item[]{JSGItems.PAGE_NOTEBOOK_ITEM});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new StargateClassicMemberBlockColor(), new Block[]{JSGBlocks.STARGATE_MILKY_WAY_MEMBER_BLOCK, JSGBlocks.STARGATE_UNIVERSE_MEMBER_BLOCK, JSGBlocks.STARGATE_PEGASUS_MEMBER_BLOCK});
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new ReloadListener());
        MinecraftForge.EVENT_BUS.register((Object)new EventTickClient());
    }

    @Override
    public String localize(String unlocalized, Object ... args) {
        return I18n.func_135052_a((String)unlocalized, (Object[])args);
    }

    private void registerRenderers() {
        OBJLoader.INSTANCE.addDomain("jsg");
        for (JSGBlock block : JSGBlocks.BLOCKS) {
            Class<? extends TileEntity> tileClass = block.getTileEntityClass();
            TileEntitySpecialRenderer<? extends TileEntity> renderer = block.getTESR();
            if (tileClass == null || renderer == null) continue;
            ClientRegistry.bindTileEntitySpecialRenderer(tileClass, renderer);
        }
        this.registerEntityRenderers();
    }

    private void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(TokraEntity.class, TokraRenderer::new);
    }

    private void registerFluidRenderers() {
        for (JSGBlockFluid blockFluid : JSGFluids.blockFluidMap.values()) {
            ModelLoader.setCustomStateMapper((Block)blockFluid, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{JSGBlockFluid.LEVEL}).func_178441_a());
        }
    }

    @Override
    public EntityPlayer getPlayerInMessageHandler(MessageContext ctx) {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void setTileEntityItemStackRenderer(Item item) {
        item.setTileEntityItemStackRenderer(((CustomModelItemInterface)item).createTEISR());
    }

    @Override
    public EntityPlayer getPlayerClientSide() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void addScheduledTaskClientSide(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @Override
    public void orlinRendererSpawnParticles(World world, StargateAbstractRendererState rendererState) {
        StargateOrlinRenderer.spawnParticles(world, rendererState);
    }

    @Override
    public void playPositionedSoundClientSide(BlockPos pos, SoundPositionedEnum soundEnum, boolean play) {
        JSGSoundHelperClient.playPositionedSoundClientSide(pos, soundEnum, play);
    }

    @Override
    public void openGui(GuiScreen gui) {
        Minecraft.func_71410_x().func_147108_a(gui);
    }

    @Override
    public void shutDown() {
        DestinyFTL.jumpingOut = false;
        DestinyFTL.jumpingIn = false;
        Minecraft.func_71410_x().field_71474_y.func_74304_a(GameSettings.Options.FOV, DestinyFTL.defaultFov);
    }

    @Override
    public void loadCompleted() {
        if (JSGConfig.General.mainMenuConfig.loadingMusic) {
            this.playPositionedSoundClientSide(new BlockPos(0, 0, 0), SoundPositionedEnum.LOADING_MUSIC, false);
        }
    }
}

