/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.dialhomedevice;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tauri.dev.jsg.config.ingame.JSGTileEntityConfig;
import tauri.dev.jsg.renderer.activation.Activation;
import tauri.dev.jsg.renderer.activation.DHDActivation;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;

public class DHDPegasusRendererState
extends DHDAbstractRendererState {
    private static final String SYMBOL_TEXTURE_BASE = "textures/tesr/pegasus/symbol";
    private static final String BRB_TEXTURE_BASE = "textures/tesr/pegasus/brb";
    private static final String SYMBOL_TEXTURE_END = "png";
    private static final String BRB_TEXTURE_END = "jpg";
    private static final Map<BiomeOverlayEnum, TextureContainer> BIOME_TEXTURE_MAP = new HashMap<BiomeOverlayEnum, TextureContainer>();
    private final Map<SymbolInterface, Integer> BUTTON_STATE_MAP = new HashMap<SymbolInterface, Integer>(38);
    public List<Activation<SymbolInterface>> activationList = new ArrayList<Activation<SymbolInterface>>();

    public DHDPegasusRendererState() {
    }

    public DHDPegasusRendererState(StargateAddressDynamic addressDialed, boolean brbActive, BiomeOverlayEnum biomeOverride, boolean stargateIsConnected, JSGTileEntityConfig gateConfig) {
        super(addressDialed, brbActive, biomeOverride, stargateIsConnected, gateConfig);
    }

    @Override
    public DHDPegasusRendererState initClient(BlockPos pos, float horizontalRotation, BiomeOverlayEnum biomeOverlay, boolean stargateIsConnected) {
        super.initClient(pos, horizontalRotation, biomeOverlay, stargateIsConnected);
        for (SymbolPegasusEnum symbol : SymbolPegasusEnum.values()) {
            if (symbol.brb()) {
                this.BUTTON_STATE_MAP.put(symbol, this.brbActive ? 5 : 0);
                continue;
            }
            this.BUTTON_STATE_MAP.put(symbol, this.addressDialed.contains(symbol) ? 5 : 0);
        }
        return this;
    }

    private boolean isSymbolActiveClientSide(SymbolPegasusEnum symbol) {
        return this.BUTTON_STATE_MAP.get(symbol) != 0;
    }

    public void clearSymbols(long totalWorldTime) {
        for (SymbolPegasusEnum symbol : SymbolPegasusEnum.values()) {
            if (!this.isSymbolActiveClientSide(symbol)) continue;
            this.activationList.add(new DHDActivation(symbol, totalWorldTime, true));
        }
    }

    public void activateSymbol(long totalWorldTime, SymbolPegasusEnum symbol) {
        this.activationList.add(new DHDActivation(symbol, totalWorldTime, false));
    }

    @Override
    public void iterate(World world, double partialTicks) {
        Activation.iterate(this.activationList, world.func_82737_E(), partialTicks, (index, stage) -> this.BUTTON_STATE_MAP.put((SymbolInterface)index, Math.round(stage)));
    }

    public ResourceLocation getButtonTexture(SymbolPegasusEnum symbol, BiomeOverlayEnum biomeOverlay) {
        TextureContainer container = BIOME_TEXTURE_MAP.get((Object)biomeOverlay);
        if (symbol.brb()) {
            return container.BRB_RESOURCE_MAP.get(this.BUTTON_STATE_MAP.get(symbol));
        }
        return container.SYMBOL_RESOURCE_MAP.get(this.BUTTON_STATE_MAP.get(symbol));
    }

    @Override
    public boolean isButtonActive(SymbolInterface symbol) {
        return this.BUTTON_STATE_MAP.get((SymbolPegasusEnum)symbol) == 5;
    }

    @Override
    public int getActivatedButtons() {
        int count = 0;
        SymbolInterface origin = SymbolPegasusEnum.getOrigin();
        for (int state : this.BUTTON_STATE_MAP.values()) {
            if (state <= 0) continue;
            ++count;
        }
        if (this.BUTTON_STATE_MAP.get((SymbolPegasusEnum)origin) > 0) {
            --count;
        }
        return count;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.addressDialed = new StargateAddressDynamic(SymbolTypeEnum.PEGASUS);
        super.fromBytes(buf);
    }

    static {
        for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
            TextureContainer container = new TextureContainer();
            for (int i = 0; i <= 5; ++i) {
                container.SYMBOL_RESOURCE_MAP.put(i, new ResourceLocation("jsg", SYMBOL_TEXTURE_BASE + i + biomeOverlay.suffix + "." + SYMBOL_TEXTURE_END));
                container.BRB_RESOURCE_MAP.put(i, new ResourceLocation("jsg", BRB_TEXTURE_BASE + i + biomeOverlay.suffix + "." + BRB_TEXTURE_END));
            }
            BIOME_TEXTURE_MAP.put(biomeOverlay, container);
        }
    }

    private static class TextureContainer {
        public final Map<Integer, ResourceLocation> SYMBOL_RESOURCE_MAP = new HashMap<Integer, ResourceLocation>();
        public final Map<Integer, ResourceLocation> BRB_RESOURCE_MAP = new HashMap<Integer, ResourceLocation>();

        private TextureContainer() {
        }
    }
}

