/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.props;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.tileentity.props.AncientSignTile;

public class AncientSignRendererState
extends State {
    public String[] lines = AncientSignTile.getNewLines();
    public int color = 0xFFFFFF;

    public AncientSignRendererState() {
    }

    public AncientSignRendererState(String[] lines, int color) {
        this.lines = lines;
        this.color = color;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.color);
        for (int i = 0; i < 7; ++i) {
            buf.writeInt(this.lines[i].length());
            buf.writeCharSequence((CharSequence)this.lines[i], StandardCharsets.UTF_8);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.color = buf.readInt();
        for (int i = 0; i < 7; ++i) {
            int len = buf.readInt();
            this.lines[i] = buf.readCharSequence(len, StandardCharsets.UTF_8).toString();
        }
    }
}

