/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.activation.Activation;
import tauri.dev.jsg.renderer.activation.StargateActivation;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.stargate.ChevronEnum;

public class ChevronTextureList {
    private final List<ChevronEnum> activeChevrons = new ArrayList<ChevronEnum>(9);
    public Map<ChevronEnum, Integer> CHEVRON_STATE_MAP = new HashMap<ChevronEnum, Integer>(9);
    private final List<Activation<ChevronEnum>> activationList = new ArrayList<Activation<ChevronEnum>>();
    private final Map<BiomeOverlayEnum, ResourceLocation> CHEVRON_RESOURCE_MAP = new HashMap<BiomeOverlayEnum, ResourceLocation>();
    private final Map<BiomeOverlayEnum, ResourceLocation> CHEVRON_LIGHT_RESOURCE_MAP = new HashMap<BiomeOverlayEnum, ResourceLocation>();
    private final Map<BiomeOverlayEnum, ResourceLocation> CHEVRON_LIGHT_RESOURCE_MAP_OFF = new HashMap<BiomeOverlayEnum, ResourceLocation>();

    public ChevronTextureList(String chevronTextureBase) {
        for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
            this.CHEVRON_LIGHT_RESOURCE_MAP.put(biomeOverlay, TextureLoader.getTextureResource(chevronTextureBase + "_light" + biomeOverlay.suffix + ".png"));
            this.CHEVRON_LIGHT_RESOURCE_MAP_OFF.put(biomeOverlay, TextureLoader.getTextureResource(chevronTextureBase + "_light_off" + biomeOverlay.suffix + ".png"));
            this.CHEVRON_RESOURCE_MAP.put(biomeOverlay, TextureLoader.getTextureResource(chevronTextureBase + biomeOverlay.suffix + ".png"));
        }
    }

    public ChevronTextureList(String chevronTextureBase, int activeChevrons, boolean isFinalActive) {
        this(chevronTextureBase);
        if (isFinalActive) {
            --activeChevrons;
        }
        for (int i = 0; i < activeChevrons; ++i) {
            this.activeChevrons.add(ChevronEnum.valueOf(i));
        }
        if (isFinalActive) {
            this.activeChevrons.add(ChevronEnum.getFinal());
        }
    }

    public void initClient() {
        for (ChevronEnum chevron : ChevronEnum.values()) {
            this.CHEVRON_STATE_MAP.put(chevron, this.activeChevrons.contains(chevron) ? 10 : 0);
        }
    }

    public ChevronEnum getCurrentChevron() {
        if (this.activeChevrons.size() > 0) {
            return this.activeChevrons.get(this.activeChevrons.size() - 1);
        }
        return ChevronEnum.C1;
    }

    public ChevronEnum getNextChevron() {
        if (this.activeChevrons.size() > 0) {
            return this.getCurrentChevron().getNext();
        }
        return ChevronEnum.C1;
    }

    public void activateNextChevron(long totalWorldTime) {
        ChevronEnum next = this.getNextChevron();
        this.activationList.add(new StargateActivation(next, totalWorldTime, false));
        this.activeChevrons.add(next);
    }

    public void activateNextChevron(long totalWorldTime, int chevron) {
        if (chevron < 10) {
            this.activateNextChevron(totalWorldTime);
            return;
        }
        ChevronEnum chev = ChevronEnum.valueOf(chevron - 10);
        this.activationList.add(new StargateActivation(chev, totalWorldTime, false));
        this.activeChevrons.add(chev);
    }

    public void activateFinalChevron(long totalWorldTime) {
        this.activationList.add(new StargateActivation(ChevronEnum.getFinal(), totalWorldTime, false));
        this.activeChevrons.add(ChevronEnum.getFinal());
    }

    public void deactivateFinalChevron(long totalWorldTime) {
        this.activationList.add(new StargateActivation(ChevronEnum.getFinal(), totalWorldTime, true));
        this.activeChevrons.remove(ChevronEnum.getFinal());
    }

    public void clearChevrons(long totalWorldTime) {
        for (ChevronEnum chevron : this.activeChevrons) {
            this.activationList.add(new StargateActivation(chevron, totalWorldTime, true));
        }
        this.activeChevrons.clear();
    }

    public void lightUpChevrons(long totalWorldTime, int incomingAddressSize) {
        for (ChevronEnum chevron : Arrays.asList(ChevronEnum.C7, ChevronEnum.C8)) {
            if (!this.activeChevrons.contains(chevron) || chevron.index < incomingAddressSize - 1) continue;
            this.activationList.add(new StargateActivation(chevron, totalWorldTime, true));
        }
        this.activeChevrons.clear();
        while (this.activeChevrons.size() < incomingAddressSize - 1) {
            this.activateNextChevron(totalWorldTime);
        }
        this.activateFinalChevron(totalWorldTime);
    }

    public void iterate(World world, double partialTicks) {
        Activation.iterate(this.activationList, world.func_82737_E(), partialTicks, (index, stage) -> this.CHEVRON_STATE_MAP.put((ChevronEnum)index, Math.round(stage)));
    }

    public ResourceLocation get(BiomeOverlayEnum overlayEnum, ChevronEnum chevron, boolean onlyLight) {
        if (onlyLight) {
            if (this.getState(chevron) < 1) {
                return this.CHEVRON_LIGHT_RESOURCE_MAP_OFF.get((Object)overlayEnum);
            }
            return this.CHEVRON_LIGHT_RESOURCE_MAP.get((Object)overlayEnum);
        }
        return this.CHEVRON_RESOURCE_MAP.get((Object)overlayEnum);
    }

    public int getState(ChevronEnum chevron) {
        return this.CHEVRON_STATE_MAP.get(chevron);
    }

    public float getColor(ChevronEnum chevron) {
        float MIN = 0.8f;
        if (this.getState(chevron) == 0) {
            return 1.0f;
        }
        return (float)this.getState(chevron) / 10.0f * 0.19999999f + 0.8f;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.activeChevrons.size());
        for (ChevronEnum chevron : this.activeChevrons) {
            buf.writeInt(chevron.index);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.activeChevrons.clear();
        for (int i = 0; i < size; ++i) {
            this.activeChevrons.add(ChevronEnum.valueOf(buf.readInt()));
        }
    }
}

