/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.model.ModelLoader;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.stargate.ChevronEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateClassicRenderer;
import tauri.dev.jsg.renderer.stargate.StargateMilkyWayRendererState;
import tauri.dev.jsg.stargate.network.SymbolMilkyWayEnum;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.util.math.MathFunction;
import tauri.dev.jsg.util.math.MathFunctionImpl;
import tauri.dev.jsg.util.math.MathRange;

public class StargateMilkyWayRenderer
extends StargateClassicRenderer<StargateMilkyWayRendererState> {
    public static final Vec3d RING_LOC = new Vec3d(0.0, -0.122333, -5.97E-4);
    private static final float GATE_DIAMETER = 10.1815f;
    private static final MathRange CHEVRON_OPEN_RANGE = new MathRange(0.0f, 1.57f);
    private static final MathFunction CHEVRON_OPEN_FUNCTION = new MathFunctionImpl(x -> x * x * x * x / 80.0f);
    private static final MathRange CHEVRON_CLOSE_RANGE = new MathRange(0.0f, 1.428f);
    private static final MathFunction CHEVRON_CLOSE_FUNCTION = new MathFunctionImpl(x0 -> MathHelper.func_76134_b((float)(x0 * 1.1f)) / 12.0f);

    @Override
    public float getGateDiameter() {
        return 10.1815f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.0;
    }

    @Override
    protected void renderGate(StargateAbstractBaseTile te, StargateMilkyWayRendererState rendererState, double partialTicks) {
        this.setGateHeatColor(rendererState);
        this.renderRing(te, rendererState, partialTicks);
        this.setGateHeatColor(rendererState);
        this.renderChevrons(rendererState, partialTicks);
        this.setGateHeatColor(rendererState);
        GlStateManager.func_179094_E();
        this.applyLightMap((StargateAbstractRendererState)rendererState, partialTicks);
        ElementEnum.MILKYWAY_GATE.bindTextureAndRender(rendererState.getBiomeOverlay());
        GlStateManager.func_179121_F();
    }

    private void renderRing(StargateAbstractBaseTile te, StargateMilkyWayRendererState rendererState, double partialTicks) {
        GlStateManager.func_179094_E();
        this.applyLightMap((StargateAbstractRendererState)rendererState, partialTicks);
        float angularRotation = rendererState.spinHelper.getCurrentSymbol().getAngle();
        if (rendererState.spinHelper.getIsSpinning()) {
            angularRotation += rendererState.spinHelper.apply((double)this.func_178459_a().func_82737_E() + partialTicks);
        }
        GlStateManager.func_179137_b((double)StargateMilkyWayRenderer.RING_LOC.field_72450_a, (double)StargateMilkyWayRenderer.RING_LOC.field_72449_c, (double)StargateMilkyWayRenderer.RING_LOC.field_72448_b);
        GlStateManager.func_179114_b((float)(-angularRotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-StargateMilkyWayRenderer.RING_LOC.field_72450_a), (double)(-StargateMilkyWayRenderer.RING_LOC.field_72449_c), (double)(-StargateMilkyWayRenderer.RING_LOC.field_72448_b));
        ElementEnum.MILKYWAY_RING.bindTextureAndRender(rendererState.getBiomeOverlay());
        ModelLoader.getModel(((SymbolMilkyWayEnum)SymbolMilkyWayEnum.getOrigin()).getModelResource(rendererState.getBiomeOverlay(), this.func_178459_a().field_73011_w.getDimension(), false, false, ((StargateClassicBaseTile)te).getConfig().getOption(StargateClassicBaseTile.ConfigOptions.ORIGIN_MODEL.id).getEnumValue().getIntValue())).render();
        GlStateManager.func_179121_F();
    }

    private float calculateTopChevronOffset(StargateMilkyWayRendererState rendererState, double partialTicks) {
        float tick = (float)((double)(this.func_178459_a().func_82737_E() - rendererState.chevronActionStart) + partialTicks);
        float x = tick / 6.0f;
        if (rendererState.chevronOpening) {
            if (CHEVRON_OPEN_RANGE.test(Float.valueOf(x))) {
                return CHEVRON_OPEN_FUNCTION.apply(x);
            }
            rendererState.chevronOpen = true;
            rendererState.chevronOpening = false;
        } else if (rendererState.chevronClosing) {
            if (CHEVRON_CLOSE_RANGE.test(Float.valueOf(x))) {
                return CHEVRON_CLOSE_FUNCTION.apply(x);
            }
            rendererState.chevronOpen = false;
            rendererState.chevronClosing = false;
        }
        return rendererState.chevronOpen ? 0.08333f : 0.0f;
    }

    @Override
    protected void renderChevron(StargateMilkyWayRendererState rendererState, double partialTicks, ChevronEnum chevron, boolean onlyLight) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)chevron.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        if (onlyLight) {
            float color = rendererState.chevronTextureList.getColor(chevron);
            GlStateManager.func_179124_c((float)color, (float)color, (float)color);
        } else {
            this.setGateHeatColor(rendererState);
        }
        TextureLoader.getTexture(rendererState.chevronTextureList.get(rendererState.getBiomeOverlay(), chevron, onlyLight)).bindTexture();
        if (chevron.isFinal()) {
            float chevronOffset = this.calculateTopChevronOffset(rendererState, partialTicks);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)chevronOffset, (float)0.0f);
            ElementEnum.MILKYWAY_CHEVRON_LIGHT.render();
            GlStateManager.func_179109_b((float)0.0f, (float)(-2.0f * chevronOffset), (float)0.0f);
            ElementEnum.MILKYWAY_CHEVRON_MOVING.render();
            GlStateManager.func_179121_F();
        } else {
            ElementEnum.MILKYWAY_CHEVRON_MOVING.render();
            ElementEnum.MILKYWAY_CHEVRON_LIGHT.render();
        }
        if (!onlyLight) {
            this.setGateHeatColor(rendererState);
            this.applyLightMap((StargateAbstractRendererState)rendererState, partialTicks);
            ElementEnum.MILKYWAY_CHEVRON_FRAME.bindTextureAndRender(rendererState.getBiomeOverlay());
            ElementEnum.MILKYWAY_CHEVRON_BACK.render();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

