/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.stargate;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.texture.Texture;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.stargate.ChevronEnum;
import tauri.dev.jsg.renderer.stargate.StargateAbstractRendererState;
import tauri.dev.jsg.renderer.stargate.StargateClassicRenderer;
import tauri.dev.jsg.renderer.stargate.StargatePegasusRendererState;
import tauri.dev.jsg.stargate.network.SymbolPegasusEnum;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.util.JSGTextureLightningHelper;
import tauri.dev.jsg.util.math.NumberUtils;

public class StargatePegasusRenderer
extends StargateClassicRenderer<StargatePegasusRendererState> {
    public static final Vec3d RING_LOC = new Vec3d(0.0, -0.122333, -5.97E-4);
    public static final float GATE_DIAMETER = 10.1815f;
    private static final int GLYPHS_COUNT = 36;

    @Override
    public float getGateDiameter() {
        return 10.1815f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.0;
    }

    @Override
    protected void renderGate(StargateAbstractBaseTile te, StargatePegasusRendererState rendererState, double partialTicks) {
        int index;
        this.setGateHeatColor(rendererState);
        this.renderRing(rendererState, partialTicks);
        this.setGateHeatColor(rendererState);
        this.renderChevrons(rendererState, partialTicks);
        this.setGateHeatColor(rendererState);
        GlStateManager.func_179094_E();
        this.applyLightMap((StargateAbstractRendererState)rendererState, partialTicks);
        ElementEnum.PEGASUS_GATE.bindTextureAndRender(rendererState.getBiomeOverlay());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        JSGTextureLightningHelper.lightUpTexture(1.0f);
        if (rendererState.spinHelper.getIsSpinning() && !rendererState.slotToGlyphMap.containsKey(index = Math.round(rendererState.spinHelper.apply((double)this.func_178459_a().func_82737_E() + partialTicks)))) {
            this.renderGlyph(rendererState.spinHelper.getTargetSymbol().getId(), index, false);
        }
        for (int i = 0; i < 38; ++i) {
            if (!rendererState.slotToGlyphMap.containsKey(i) && i < 36) {
                if (rendererState.spinHelper.getIsSpinning() || rendererState.slotToGlyphMap.size() != 0) continue;
                this.renderGlyph(i, i, true);
                continue;
            }
            if (!rendererState.slotToGlyphMap.containsKey(i) && i >= 36) continue;
            this.renderGlyph(rendererState.slotToGlyphMap.get(i), i, false);
        }
        this.applyLightMap((StargateAbstractRendererState)rendererState, partialTicks);
        GlStateManager.func_179121_F();
    }

    private void renderRing(StargatePegasusRendererState rendererState, double partialTicks) {
        GlStateManager.func_179094_E();
        if (rendererState.horizontalRotation == 90.0f || rendererState.horizontalRotation == 270.0f) {
            GlStateManager.func_179137_b((double)StargatePegasusRenderer.RING_LOC.field_72448_b, (double)StargatePegasusRenderer.RING_LOC.field_72449_c, (double)StargatePegasusRenderer.RING_LOC.field_72450_a);
            GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-StargatePegasusRenderer.RING_LOC.field_72448_b), (double)(-StargatePegasusRenderer.RING_LOC.field_72449_c), (double)(-StargatePegasusRenderer.RING_LOC.field_72450_a));
        } else {
            GlStateManager.func_179137_b((double)StargatePegasusRenderer.RING_LOC.field_72450_a, (double)StargatePegasusRenderer.RING_LOC.field_72449_c, (double)StargatePegasusRenderer.RING_LOC.field_72448_b);
            GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-StargatePegasusRenderer.RING_LOC.field_72450_a), (double)(-StargatePegasusRenderer.RING_LOC.field_72449_c), (double)(-StargatePegasusRenderer.RING_LOC.field_72448_b));
        }
        if (ElementEnum.PEGASUS_RING.modelResource != null && ElementEnum.PEGASUS_RING.biomeTextureResourceMap != null && ElementEnum.PEGASUS_RING.biomeTextureResourceMap.get((Object)rendererState.getBiomeOverlay()) != null) {
            ElementEnum.PEGASUS_RING.bindTextureAndRender(rendererState.getBiomeOverlay());
        }
        GlStateManager.func_179121_F();
    }

    @Override
    protected void renderChevron(StargatePegasusRendererState rendererState, double partialTicks, ChevronEnum chevron, boolean onlyLight) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)chevron.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        if (onlyLight) {
            float color = rendererState.chevronTextureList.getColor(chevron);
            GlStateManager.func_179124_c((float)color, (float)color, (float)color);
        } else {
            this.setGateHeatColor(rendererState);
        }
        Texture chevronTexture = TextureLoader.getTexture(rendererState.chevronTextureList.get(rendererState.getBiomeOverlay(), chevron, onlyLight));
        if (chevronTexture != null) {
            chevronTexture.bindTexture();
            if (chevron.isFinal()) {
                float chevronOffset = 0.0f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)chevronOffset, (float)0.0f);
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render();
                GlStateManager.func_179109_b((float)0.0f, (float)(-2.0f * chevronOffset), (float)0.0f);
                ElementEnum.PEGASUS_CHEVRON_MOVING.render();
                GlStateManager.func_179121_F();
            } else {
                ElementEnum.PEGASUS_CHEVRON_MOVING.render();
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render();
            }
            if (!onlyLight) {
                ElementEnum.PEGASUS_CHEVRON_FRAME.bindTextureAndRender(rendererState.getBiomeOverlay());
                ElementEnum.PEGASUS_CHEVRON_BACK.render();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private double[] getPositionInRingAtIndex(double radius, int index) {
        double deg = 10.0 * (double)index;
        double rad = Math.toRadians(deg);
        return new double[]{radius * Math.cos(rad), radius * Math.sin(rad), deg};
    }

    protected void renderGlyph(int glyphId, int slot, boolean deactivated) {
        this.renderGlyph(glyphId, slot, deactivated, false);
        if (deactivated) {
            this.renderGlyph(glyphId, slot, false, true);
        }
    }

    protected void renderGlyph(int glyphId, int slot, boolean deactivated, boolean translatePos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        double[] slotPos = this.getPositionInRingAtIndex(4.2407502174377445, slot);
        GlStateManager.func_179137_b((double)NumberUtils.round(slotPos[0], 3), (double)NumberUtils.round(slotPos[1], 3), (double)(translatePos ? -0.105 : 0.205));
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        String path = String.format("pegasus/%s.png", deactivated ? "glyphs_off" : "glyphs");
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLoader.getTextureResource(path));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double radius = 0.94;
        int textureSlot = SymbolPegasusEnum.valueOf((int)glyphId).textureSlot;
        double[] uv = this.getPositionInRingAtIndex(radius, -textureSlot);
        double x = (uv[0] + radius) / 2.0;
        double y = (uv[1] + radius) / 2.0;
        double tileSize = 0.27;
        double uvSize = 0.0625;
        GlStateManager.func_179114_b((float)(10.0f * (float)(slot - textureSlot)), (float)0.0f, (float)1.0f, (float)0.0f);
        buffer.func_181662_b(-tileSize, 0.0, -tileSize).func_187315_a(x, y).func_181675_d();
        buffer.func_181662_b(-tileSize, 0.0, tileSize).func_187315_a(x, y + uvSize).func_181675_d();
        buffer.func_181662_b(tileSize, 0.0, tileSize).func_187315_a(x + uvSize, y + uvSize).func_181675_d();
        buffer.func_181662_b(tileSize, 0.0, -tileSize).func_187315_a(x + uvSize, y).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

