/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.transportrings;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import tauri.dev.jsg.block.props.TRPlatformBlock;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.loader.texture.TextureLoader;
import tauri.dev.jsg.renderer.biomes.BiomeOverlayEnum;
import tauri.dev.jsg.renderer.transportrings.Ring;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.state.transportrings.TransportRingsRendererState;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.transportrings.RingsPlatform;

public abstract class TransportRingsAbstractRenderer
extends TileEntitySpecialRenderer<TransportRingsAbstractTile> {
    public static final int RING_COUNT = 5;
    public static final int INTERVAL_UPRISING = 5;
    public static final int INTERVAL_FALLING = 5;
    public static final double ANIMATION_SPEED_DIVISOR = 2.7;
    public static final int PLATFORM_ANIMATION_DURATION = 20;
    public static final float PLATFORM_MAX_Y = 0.8f;
    public static final float PLATFORM_MAX_X = 5.0f;

    public abstract void renderRings(TransportRingsRendererState var1, float var2, int var3, float var4);

    public boolean isGlobalRenderer(@Nonnull TransportRingsAbstractTile te) {
        return true;
    }

    public void render(TransportRingsAbstractTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TransportRingsRendererState state = te.getRendererState();
        if (state == null) {
            return;
        }
        World world = te.func_145831_w();
        int ringsDistance = state.ringsDistance;
        if (state.rings.size() < 5) {
            for (int i = state.rings.size(); i < 5; ++i) {
                state.rings.add(new Ring(i));
            }
        }
        for (Ring ring : state.rings) {
            ring.setWorld(world);
            ring.setConfig(state.ringsConfig);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)1.666355, (double)0.5);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        float relativeY = -5.0f;
        int coef = 1;
        if (ringsDistance < 0) {
            relativeY = 2.0f;
            coef = -1;
        }
        long tick = world.func_82737_E() - state.animationStart;
        this.renderPlatform(state, tick, te);
        GlStateManager.func_179109_b((float)0.0f, (float)relativeY, (float)0.0f);
        this.renderRings(state, partialTicks, ringsDistance, -relativeY * (float)coef);
        GlStateManager.func_179121_F();
        if (state.isAnimationActive) {
            if (state.ringsUprising) {
                if (tick > 30L && (tick -= 30L) % 5L == 0L && tick != state.lastTick) {
                    state.currentRing = (int)(tick / 5L) - 1;
                    for (int ring = state.lastRingAnimated + 1; ring < Math.min(state.currentRing, 5); ++ring) {
                        state.rings.get(ring).setTop();
                    }
                    if (state.currentRing < 5) {
                        state.rings.get(state.currentRing).animate(state.ringsUprising);
                        state.lastRingAnimated = state.currentRing;
                        state.lastTick = tick;
                    }
                    if (state.currentRing >= 4) {
                        state.ringsUprising = false;
                        state.lastRingAnimated = 5;
                        state.lastTick = -1L;
                    }
                }
            } else if (tick > 100L && (tick -= 100L) % 5L == 0L && tick != state.lastTick) {
                state.currentRing = 5 - (int)(tick / 5L);
                for (int ring = state.lastRingAnimated - 1; ring > Math.max(state.currentRing, -1); --ring) {
                    state.rings.get(ring).setDown();
                }
                if (state.currentRing >= 0) {
                    state.rings.get(state.currentRing).animate(state.ringsUprising);
                    state.lastRingAnimated = state.currentRing;
                } else {
                    state.isAnimationActive = false;
                }
                state.lastTick = tick;
            }
            te.setState(StateTypeEnum.RENDERER_STATE, state);
        }
    }

    public void renderPlatform(TransportRingsRendererState state, long tick, TransportRingsAbstractTile te) {
        int distance;
        RingsPlatform platform = te.getPlatform();
        if (platform == null) {
            return;
        }
        IBlockState blockOverlayState = te.getPlatformOverlayBlockState();
        ResourceLocation platformOverlayTextureLocation = TextureLoader.getBlockTexture(blockOverlayState);
        TRPlatformBlock platformBlock = platform.platformBlock;
        ElementEnum platformMoving = platformBlock.getPlatformModelMoving();
        ElementEnum platformBase = platformBlock.getPlatformModelBase();
        ElementEnum platformToOverlay = platformBlock.getPlatformModelToOverlay();
        boolean canRenderUnderZero = platformBlock.canRenderUnderZero();
        float platformX = 0.0f;
        float platformY = 0.0f;
        int coefficient = -1;
        if (state.ringsDistance >= 0) {
            if (state.isAnimationActive) {
                if (tick < 20L) {
                    if (state.ringsUprising) {
                        float multiplier = (float)tick / 13.333334f;
                        if (multiplier > 1.0f) {
                            multiplier = 1.0f;
                        }
                        if (multiplier < -1.0f) {
                            multiplier = -1.0f;
                        }
                        if (tick > 6L) {
                            platformX = multiplier * 5.0f;
                            platformY = 0.8f;
                        }
                        if (tick <= 6L) {
                            platformY = multiplier * 0.8f;
                        }
                    }
                } else {
                    platformX = 5.0f;
                    platformY = 0.8f;
                }
            }
            if (!state.ringsUprising) {
                long tick2 = tick - 135L;
                if (tick2 >= 0L) {
                    if (tick2 <= 20L) {
                        float multiplier = (float)tick2 / 13.333334f;
                        if (multiplier > 1.0f) {
                            multiplier = 1.0f;
                        }
                        if (multiplier < -1.0f) {
                            multiplier = -1.0f;
                        }
                        if (tick2 <= 6L) {
                            platformX = 5.0f - multiplier * 5.0f;
                            platformY = 0.8f;
                        }
                        if (tick2 > 6L) {
                            platformY = 0.8f - multiplier * 0.8f;
                        }
                    }
                } else {
                    platformX = 5.0f;
                    platformY = 0.8f;
                }
            }
        }
        if ((distance = state.ringsDistance) < 0) {
            if (!canRenderUnderZero) {
                return;
            }
            distance += 4;
        }
        if (platformMoving != null && state.ringsConfig.getOption(TransportRingsAbstractTile.ConfigOptions.RENDER_PLATFORM_MOVING.id).getBooleanValue()) {
            for (int i = 0; i < 2; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(platformX * (float)(i == 1 ? 1 : -1)), (float)(platformY * (float)coefficient - 3.4f + (float)(distance * 2)), (float)0.0f);
                if (i == 1) {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                platformMoving.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
                GlStateManager.func_179121_F();
            }
        }
        if (JSGConfig.General.devConfig.enableDevMode && platformBase != null && state.ringsConfig.getOption(TransportRingsAbstractTile.ConfigOptions.RENDER_PLATFORM_BASE.id).getBooleanValue()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(-3.4f + (float)(distance * 2)), (float)0.0f);
            platformBase.bindTextureAndRender(BiomeOverlayEnum.NORMAL);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(platformOverlayTextureLocation);
            platformToOverlay.render();
            GlStateManager.func_179121_F();
        }
    }
}

