/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.sound;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;

public class JSGSoundCategory {
    private static final String SRG_soundLevels = "field_186714_aM";
    private static final String SRG_SOUND_CATEGORIES = "field_187961_k";
    private static Map<SoundCategory, Float> soundLevels;
    private static Map<SoundCategory, Float> SOUND_LEVELS;
    private static final JSGSoundCategory instance;

    private JSGSoundCategory() {
    }

    public static JSGSoundCategory getInstance() {
        return instance;
    }

    public static SoundCategory add(String name) {
        String constantName = name.toUpperCase().replace(" ", "");
        String referenceName = constantName.toLowerCase();
        SoundCategory soundCategory = (SoundCategory)EnumHelper.addEnum(SoundCategory.class, (String)constantName, (Class[])new Class[]{String.class}, (Object[])new Object[]{referenceName});
        Map SOUND_CATEGORIES = (Map)ObfuscationReflectionHelper.getPrivateValue(SoundCategory.class, (Object)SoundCategory.BLOCKS, (String[])new String[]{"SOUND_CATEGORIES", SRG_SOUND_CATEGORIES});
        if (SOUND_CATEGORIES.containsKey(referenceName)) {
            throw new Error("Clash in Sound Category name pools! Cannot insert " + constantName);
        }
        SOUND_CATEGORIES.put(referenceName, soundCategory);
        if (!SOUND_CATEGORIES.containsKey(referenceName)) {
            JSG.warn("JSG sound category did not load properly, forcing into Blocks category - 2");
            return SoundCategory.BLOCKS;
        }
        try {
            if (FMLLaunchHandler.side() == Side.CLIENT) {
                JSGSoundCategory.setSoundLevels();
                SOUND_LEVELS.get(soundCategory);
            }
            return soundCategory;
        }
        catch (Exception e) {
            JSG.warn("JSG sound category did not load properly, forcing into Blocks category - 1");
            return SoundCategory.BLOCKS;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void setSoundLevels() {
        soundLevels = Maps.newEnumMap(SoundCategory.class);
        ObfuscationReflectionHelper.setPrivateValue(GameSettings.class, (Object)Minecraft.func_71410_x().field_71474_y, soundLevels, (String[])new String[]{"soundLevels", SRG_soundLevels});
        SOUND_LEVELS = (Map)ObfuscationReflectionHelper.getPrivateValue(GameSettings.class, (Object)Minecraft.func_71410_x().field_71474_y, (String[])new String[]{"soundLevels", SRG_soundLevels});
    }

    static {
        instance = new JSGSoundCategory();
    }
}

