/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.sound;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.SoundPositionedPlayToClient;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;

@Mod.EventBusSubscriber
public class JSGSoundHelper {
    public static void playPositionedSound(World world, BlockPos pos, SoundPositionedEnum soundEnum, boolean play) {
        JSGPacketHandler.INSTANCE.sendToAllTracking((IMessage)new SoundPositionedPlayToClient(pos, soundEnum, play), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 512.0));
    }

    public static void playSoundEventClientSide(World world, BlockPos pos, SoundEventEnum soundEventEnum) {
        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundEventEnum.soundEvent, JSG.JSG_SOUNDS, soundEventEnum.volume * JSGConfig.General.audio.volume * 5.0f, 1.0f, false);
    }

    public static void playSoundEvent(World world, BlockPos pos, SoundEventEnum soundEventEnum) {
        world.func_184133_a(null, pos, soundEventEnum.soundEvent, JSG.JSG_SOUNDS, soundEventEnum.volume * JSGConfig.General.audio.volume * 5.0f, 1.0f);
    }

    public static void playSoundToPlayer(EntityPlayerMP player, SoundEventEnum soundEventEnum, BlockPos pos) {
        player.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(soundEventEnum.soundEvent, JSG.JSG_SOUNDS, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundEventEnum.volume * JSGConfig.General.audio.volume * 5.0f, 1.0f));
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEventEnum soundEventEnum : SoundEventEnum.values()) {
            event.getRegistry().register((IForgeRegistryEntry)soundEventEnum.soundEvent);
        }
    }
}

