/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.merging;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tauri.dev.jsg.block.stargate.StargateAbstractMemberBlock;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.stargate.EnumMemberVariant;
import tauri.dev.jsg.tileentity.stargate.StargateAbstractBaseTile;
import tauri.dev.jsg.util.BlockHelpers;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.JSGAxisAlignedBB;

public abstract class StargateAbstractMergeHelper {
    private BlockPos topBlock = null;

    @Nonnull
    public abstract List<BlockPos> getRingBlocks();

    @Nonnull
    public abstract List<BlockPos> getChevronBlocks();

    public BlockPos getTopBlock() {
        if (this.topBlock == null) {
            this.topBlock = BlockHelpers.getHighest(this.getChevronBlocks());
        }
        if (this.topBlock == null) {
            this.topBlock = BlockHelpers.getHighest(this.getRingBlocks());
        }
        return this.topBlock;
    }

    @Nonnull
    public List<BlockPos> getAbsentBlockPositions(IBlockAccess world, BlockPos basePos, EnumFacing facing, EnumFacing facingVertical, EnumMemberVariant variant) {
        List<BlockPos> blocks = null;
        switch (variant) {
            case CHEVRON: {
                blocks = this.getChevronBlocks();
                break;
            }
            case RING: {
                blocks = this.getRingBlocks();
            }
        }
        return blocks.stream().map(pos -> FacingHelper.rotateBlock(pos, facing, facingVertical).func_177971_a((Vec3i)basePos)).filter(pos -> !this.matchMember(world.func_180495_p(pos))).collect(Collectors.toList());
    }

    @Nullable
    public abstract EnumMemberVariant getMemberVariantFromItemStack(ItemStack var1);

    public abstract JSGAxisAlignedBB getBaseSearchBox();

    public abstract boolean matchBase(IBlockState var1);

    public abstract boolean matchMember(IBlockState var1);

    public abstract StargateAbstractMemberBlock getMemberBlock();

    @Nullable
    public StargateAbstractBaseTile findBaseTile(IBlockAccess blockAccess, BlockPos memberPos, EnumFacing facing, EnumFacing verticalFacing) {
        JSGAxisAlignedBB globalBox = this.getBaseSearchBox().rotate(verticalFacing).rotate(facing).offset(memberPos);
        for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)globalBox.getMinBlockPos(), (BlockPos)globalBox.getMaxBlockPos())) {
            if (!this.matchBase(blockAccess.func_180495_p((BlockPos)pos))) continue;
            return (StargateAbstractBaseTile)blockAccess.func_175625_s(pos.func_185334_h());
        }
        return null;
    }

    protected abstract boolean checkMemberBlock(IBlockAccess var1, BlockPos var2, EnumFacing var3, EnumFacing var4, EnumMemberVariant var5);

    public boolean checkBlocks(IBlockAccess blockAccess, BlockPos basePos, EnumFacing baseFacing, EnumFacing baseFacingVertical) {
        if (JSGConfig.General.debug.checkGateMerge) {
            for (BlockPos pos : this.getRingBlocks()) {
                if (this.checkMemberBlock(blockAccess, FacingHelper.rotateBlock(pos, baseFacing, baseFacingVertical).func_177971_a((Vec3i)basePos), baseFacing, baseFacingVertical, EnumMemberVariant.RING)) continue;
                return false;
            }
            for (BlockPos pos : this.getChevronBlocks()) {
                if (this.checkMemberBlock(blockAccess, FacingHelper.rotateBlock(pos, baseFacing, baseFacingVertical).func_177971_a((Vec3i)basePos), baseFacing, baseFacingVertical, EnumMemberVariant.CHEVRON)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract void updateMemberMergeStatus(World var1, BlockPos var2, BlockPos var3, EnumFacing var4, EnumFacing var5, boolean var6);

    public void updateMembersMergeStatus(World world, BlockPos basePos, EnumFacing baseFacing, EnumFacing baseFacingVertical, boolean shouldBeMerged) {
        for (BlockPos pos : this.getRingBlocks()) {
            this.updateMemberMergeStatus(world, pos, basePos, baseFacing, baseFacingVertical, shouldBeMerged);
        }
        for (BlockPos pos : this.getChevronBlocks()) {
            this.updateMemberMergeStatus(world, pos, basePos, baseFacing, baseFacingVertical, shouldBeMerged);
        }
    }

    public void updateMembersBasePos(IBlockAccess blockAccess, BlockPos basePos, EnumFacing baseFacing, EnumFacing baseFacingVertical) {
    }
}

