/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.stargate.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import tauri.dev.jsg.datafixer.StargateNetworkReader18;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.StargateAddressDynamic;
import tauri.dev.jsg.stargate.network.StargatePos;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.stargate.network.internalgates.StargateAddressesEnum;
import tauri.dev.jsg.stargate.network.internalgates.StargateInternalAddress;
import tauri.dev.jsg.stargate.network.internalgates.StargateInternalGates;
import tauri.dev.jsg.worldgen.structures.EnumStructures;
import tauri.dev.jsg.worldgen.structures.JSGStructuresGenerator;
import tauri.dev.jsg.worldgen.util.GeneratedStargate;

public class StargateNetwork
extends WorldSavedData {
    private static final String DATA_NAME = "jsg_StargateNetworkData";
    public final StargateInternalGates INTERNAL_GATES = new StargateInternalGates();
    private Map<SymbolTypeEnum, Map<StargateAddress, StargatePos>> stargateNetworkMap = new HashMap<SymbolTypeEnum, Map<StargateAddress, StargatePos>>();
    private StargateAddress netherGateAddress;

    public StargateNetwork() {
        super(DATA_NAME);
        this.init();
    }

    public StargateNetwork(String dataName) {
        super(dataName);
        this.init();
    }

    public static StargateNetwork get(World world) {
        MapStorage storage = world.func_175693_T();
        StargateNetwork instance = (StargateNetwork)Objects.requireNonNull(storage).func_75742_a(StargateNetwork.class, DATA_NAME);
        if (instance == null) {
            instance = new StargateNetwork();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    private void init() {
        for (SymbolTypeEnum symbolType : SymbolTypeEnum.values()) {
            this.stargateNetworkMap.put(symbolType, new ConcurrentHashMap());
        }
        this.INTERNAL_GATES.init();
    }

    private Map<StargateAddress, StargatePos> getMapFromAddress(StargateAddress address) {
        return this.stargateNetworkMap.get(address.getSymbolType());
    }

    public Map<SymbolTypeEnum, Map<StargateAddress, StargatePos>> getMap() {
        return this.stargateNetworkMap;
    }

    public boolean isStargateInNetwork(StargateAddress gateAddress) {
        return this.getMapFromAddress(gateAddress).containsKey(gateAddress);
    }

    @Nullable
    public StargatePos getStargate(StargateAddress address) {
        if (address == null) {
            return null;
        }
        if (address.getSize() < 7) {
            return null;
        }
        StargatePos pos = this.getMapFromAddress(address).get(address);
        if (pos != null && pos.getWorld() == null) {
            return null;
        }
        return pos;
    }

    public void addStargate(StargateAddress gateAddress, StargatePos stargatePos) {
        if (gateAddress == null) {
            return;
        }
        this.getMapFromAddress(gateAddress).put(gateAddress, stargatePos);
        this.func_76185_a();
    }

    public void removeStargate(StargateAddress gateAddress) {
        if (gateAddress == null) {
            return;
        }
        this.getMapFromAddress(gateAddress).remove(gateAddress);
        this.func_76185_a();
    }

    public boolean hasNetherGate() {
        return this.netherGateAddress != null;
    }

    public void deleteNetherGate() {
        this.netherGateAddress = null;
        this.func_76185_a();
    }

    public StargateAddress getNetherGate() {
        return this.netherGateAddress;
    }

    public void setNetherGate(StargateAddress address) {
        this.netherGateAddress = address;
        this.func_76185_a();
    }

    public static GeneratedStargate generateNetherGate(StargateNetwork network, World world, BlockPos pos) {
        GeneratedStargate stargate = JSGStructuresGenerator.generateStructure(EnumStructures.NETHER_MW, world, new Random(), pos.func_177958_n() / 16 / 8, pos.func_177952_p() / 16 / 8, true);
        if (stargate != null) {
            network.setNetherGate(stargate.address);
        }
        return stargate;
    }

    public StargateInternalAddress getInternalAddress(int id) {
        return this.INTERNAL_GATES.map.get(id);
    }

    public void setLastActivatedOrlins(StargateAddress address) {
        this.getInternalAddress((int)StargateAddressesEnum.EARTH.id).addressToReplace.clear();
        this.getInternalAddress((int)StargateAddressesEnum.EARTH.id).addressToReplace.addAll(address);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound compound) {
        if (compound.func_74764_b("size")) {
            StargateNetworkReader18.readOldMap(compound, this);
        }
        NBTTagList stargateTagList = compound.func_150295_c("stargates", 10);
        for (NBTBase baseTag : stargateTagList) {
            NBTTagCompound stargateCompound = (NBTTagCompound)baseTag;
            StargateAddress stargateAddress = new StargateAddress(stargateCompound.func_74775_l("address"));
            StargatePos stargatePos = new StargatePos(stargateAddress.getSymbolType(), stargateCompound.func_74775_l("pos"));
            this.getMapFromAddress(stargateAddress).put(stargateAddress, stargatePos);
        }
        if (compound.func_74764_b("netherGateAddress")) {
            this.netherGateAddress = new StargateAddress(compound.func_74775_l("netherGateAddress"));
        }
        this.INTERNAL_GATES.deserializeNBT(compound.func_74775_l("internalGates"));
        if (compound.func_74764_b("lastActivatedOrlins")) {
            this.getInternalAddress((int)StargateAddressesEnum.EARTH.id).addressToReplace.clear();
            this.getInternalAddress((int)StargateAddressesEnum.EARTH.id).addressToReplace.addAll(new StargateAddressDynamic(compound.func_74775_l("lastActivatedOrlins")));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList stargateTagList = new NBTTagList();
        for (Map<StargateAddress, StargatePos> stargateMap : this.stargateNetworkMap.values()) {
            for (Map.Entry<StargateAddress, StargatePos> stargateEntry : stargateMap.entrySet()) {
                NBTTagCompound stargateCompound = new NBTTagCompound();
                stargateCompound.func_74782_a("address", (NBTBase)stargateEntry.getKey().serializeNBT());
                stargateCompound.func_74782_a("pos", (NBTBase)stargateEntry.getValue().serializeNBT());
                stargateTagList.func_74742_a((NBTBase)stargateCompound);
            }
        }
        compound.func_74782_a("stargates", (NBTBase)stargateTagList);
        if (this.netherGateAddress != null) {
            compound.func_74782_a("netherGateAddress", (NBTBase)this.netherGateAddress.serializeNBT());
        }
        compound.func_74782_a("internalGates", (NBTBase)this.INTERNAL_GATES.serializeNBT());
        return compound;
    }
}

