/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.tileentity.machine;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import tauri.dev.jsg.gui.container.machine.pcbfabricator.PCBFabricatorContainerGuiUpdate;
import tauri.dev.jsg.machine.AbstractMachineRecipe;
import tauri.dev.jsg.machine.pcbfabricator.PCBFabricatorRecipe;
import tauri.dev.jsg.machine.pcbfabricator.PCBFabricatorRecipes;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;
import tauri.dev.jsg.renderer.machine.AbstractMachineRendererState;
import tauri.dev.jsg.renderer.machine.PCBFabricatorRendererState;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.state.State;
import tauri.dev.jsg.state.StateTypeEnum;
import tauri.dev.jsg.tileentity.machine.AbstractMachineTile;
import tauri.dev.jsg.util.JSGItemStackHandler;

public class PCBFabricatorTile
extends AbstractMachineTile {
    public PCBFabricatorRendererState rendererState = new PCBFabricatorRendererState();
    public static final int CONTAINER_SIZE = 10;
    protected final JSGItemStackHandler itemStackHandler = new JSGItemStackHandler(10){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot != 9;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            PCBFabricatorTile.this.func_70296_d();
            PCBFabricatorTile.this.sendState(StateTypeEnum.RENDERER_UPDATE, PCBFabricatorTile.this.getState(StateTypeEnum.RENDERER_UPDATE));
        }
    };
    protected final StargateAbstractEnergyStorage energyStorage = new StargateAbstractEnergyStorage(9000000, 20000){

        @Override
        protected void onEnergyChanged() {
            PCBFabricatorTile.this.func_70296_d();
        }
    };
    protected final FluidTank fluidHandler = new FluidTank(5000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null;
        }

        protected void onContentsChanged() {
            PCBFabricatorTile.this.func_70296_d();
            PCBFabricatorTile.this.sendState(StateTypeEnum.RENDERER_UPDATE, PCBFabricatorTile.this.getState(StateTypeEnum.RENDERER_UPDATE));
        }
    };

    @Override
    public JSGItemStackHandler getJSGItemHandler() {
        return this.itemStackHandler;
    }

    @Override
    protected void playLoopSound(boolean stop) {
        JSGSoundHelper.playPositionedSound(this.field_145850_b, this.field_174879_c, SoundPositionedEnum.BEAMER_LOOP, !stop);
    }

    @Override
    protected void playSound(boolean start) {
        if (!start) {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_STOP);
        } else {
            JSGSoundHelper.playSoundEvent(this.field_145850_b, this.field_174879_c, SoundEventEnum.BEAMER_START);
        }
    }

    @Override
    public AbstractMachineRecipe getRecipeIfPossible() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            stacks.add(this.itemStackHandler.getStackInSlot(i));
        }
        for (PCBFabricatorRecipe recipe : PCBFabricatorRecipes.RECIPES) {
            if (this.itemStackHandler.insertItem(9, recipe.getResult(), true).equals(recipe.getResult()) || this.fluidHandler.getFluid() == null || !recipe.isOk(this.energyStorage.getEnergyStored(), new FluidStack(this.fluidHandler.getFluid(), this.fluidHandler.getFluidAmount()), stacks)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    protected void workIsDone() {
        if (!this.isWorking || this.currentRecipe == null) {
            return;
        }
        PCBFabricatorRecipe currentRecipe = (PCBFabricatorRecipe)this.currentRecipe;
        this.itemStackHandler.insertItem(9, currentRecipe.getResult(), false);
        this.fluidHandler.drainInternal(currentRecipe.getSubFluidStack().amount, true);
        for (int i = 0; i < 9; ++i) {
            int amount = 0;
            if (currentRecipe.getPattern().size() > i && currentRecipe.getPattern().get(i) != null) {
                amount = currentRecipe.getPattern().get(i).func_190916_E();
            }
            this.itemStackHandler.extractItem(i, amount, false);
        }
        super.workIsDone();
    }

    @Override
    public StargateAbstractEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_UPDATE: {
                return new PCBFabricatorContainerGuiUpdate(this.energyStorage.getEnergyStored(), this.fluidHandler.getFluid() != null ? new FluidStack(this.fluidHandler.getFluid(), this.fluidHandler.getFluidAmount()) : null, this.energyTransferedLastTick, this.machineStart, this.machineEnd);
            }
            case RENDERER_UPDATE: {
                float[] fArray;
                ItemStack stack;
                ItemStack itemStack = stack = this.currentRecipe != null ? ((PCBFabricatorRecipe)this.currentRecipe).getResult() : this.itemStackHandler.getStackInSlot(9);
                if (this.currentRecipe != null) {
                    fArray = ((PCBFabricatorRecipe)this.currentRecipe).getBeamColors();
                } else {
                    float[] fArray2 = new float[3];
                    fArray2[0] = 1.0f;
                    fArray2[1] = 1.0f;
                    fArray = fArray2;
                    fArray2[2] = 1.0f;
                }
                float[] colors = fArray;
                return new PCBFabricatorRendererState(this.workStateChanged, this.machineProgress, this.isWorking, stack, colors);
            }
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        switch (stateType) {
            case GUI_UPDATE: {
                return new PCBFabricatorContainerGuiUpdate();
            }
            case RENDERER_UPDATE: {
                return new PCBFabricatorRendererState();
            }
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        switch (stateType) {
            case GUI_UPDATE: {
                PCBFabricatorContainerGuiUpdate guiUpdate = (PCBFabricatorContainerGuiUpdate)state;
                this.energyStorage.setEnergyStored(guiUpdate.energyStored);
                this.energyTransferedLastTick = guiUpdate.energyTransferedLastTick;
                this.machineStart = guiUpdate.machineStart;
                this.machineEnd = guiUpdate.machineEnd;
                this.fluidHandler.setFluid(guiUpdate.fluidStack);
                this.func_70296_d();
                break;
            }
            case RENDERER_UPDATE: {
                this.rendererState = (PCBFabricatorRendererState)state;
                this.machineProgress = this.rendererState.machineProgress;
                this.isWorking = this.rendererState.isWorking;
                this.func_70296_d();
            }
        }
    }

    @Override
    public AbstractMachineRendererState getRendererState() {
        return this.rendererState;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound fluidHandlerCompound = new NBTTagCompound();
        this.fluidHandler.writeToNBT(fluidHandlerCompound);
        compound.func_74782_a("fluidHandler", (NBTBase)fluidHandlerCompound);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.fluidHandler.readFromNBT(compound.func_74775_l("fluidHandler"));
        super.func_145839_a(compound);
    }
}

